/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.resource;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.tacz.guns.api.client.animation.Animations;
import com.tacz.guns.api.client.animation.ObjectAnimation;
import com.tacz.guns.client.model.bedrock.BedrockModel;
import com.tacz.guns.client.resource.ClientGunPackLoader;
import com.tacz.guns.client.resource.pojo.animation.bedrock.BedrockAnimationFile;
import com.tacz.guns.client.resource.pojo.model.BedrockModelPOJO;
import com.tacz.guns.client.resource.pojo.model.BedrockVersion;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;

public class InternalAssetLoader {
    public static final ResourceLocation DEFAULT_BULLET_TEXTURE = new ResourceLocation("tacz", "textures/entity/basic_bullet.png");
    public static final ResourceLocation DEFAULT_BULLET_MODEL = new ResourceLocation("tacz", "models/bedrock/basic_bullet.json");
    public static final ResourceLocation TARGET_MINECART_MODEL_LOCATION = new ResourceLocation("tacz", "models/bedrock/target_minecart.json");
    public static final ResourceLocation TARGET_MINECART_TEXTURE_LOCATION = new ResourceLocation("tacz", "textures/entity/target_minecart.png");
    public static final ResourceLocation ENTITY_EMPTY_TEXTURE = new ResourceLocation("tacz", "textures/entity/empty.png");
    public static final ResourceLocation TARGET_MODEL_LOCATION = new ResourceLocation("tacz", "models/bedrock/target.json");
    public static final ResourceLocation TARGET_TEXTURE_LOCATION = new ResourceLocation("tacz", "textures/block/target.png");
    public static final ResourceLocation STATUE_MODEL_LOCATION = new ResourceLocation("tacz", "models/bedrock/statue.json");
    public static final ResourceLocation STATUE_TEXTURE_LOCATION = new ResourceLocation("tacz", "textures/block/statue.png");
    public static final ResourceLocation SMITH_TABLE_MODEL_LOCATION = new ResourceLocation("tacz", "models/bedrock/gun_smith_table.json");
    public static final ResourceLocation SMITH_TABLE_TEXTURE_LOCATION = new ResourceLocation("tacz", "textures/block/gun_smith_table.png");
    private static final ResourceLocation DEFAULT_PISTOL_ANIMATIONS_LOC = new ResourceLocation("tacz", "animations/pistol_default.animation.json");
    private static final ResourceLocation DEFAULT_RIFLE_ANIMATIONS_LOC = new ResourceLocation("tacz", "animations/rifle_default.animation.json");
    private static final Map<ResourceLocation, BedrockModel> BEDROCK_MODELS = Maps.newHashMap();
    private static List<ObjectAnimation> defaultPistolAnimations;
    private static List<ObjectAnimation> defaultRifleAnimations;

    public static void onResourceReload() {
        BedrockAnimationFile pistolAnimationFile = InternalAssetLoader.loadAnimations(DEFAULT_PISTOL_ANIMATIONS_LOC);
        BedrockAnimationFile rifleAnimationFile = InternalAssetLoader.loadAnimations(DEFAULT_RIFLE_ANIMATIONS_LOC);
        defaultPistolAnimations = Animations.createAnimationFromBedrock(pistolAnimationFile);
        defaultRifleAnimations = Animations.createAnimationFromBedrock(rifleAnimationFile);
        BEDROCK_MODELS.clear();
        InternalAssetLoader.loadBedrockModels(SMITH_TABLE_MODEL_LOCATION);
        InternalAssetLoader.loadBedrockModels(TARGET_MODEL_LOCATION);
        InternalAssetLoader.loadBedrockModels(TARGET_MINECART_MODEL_LOCATION);
        InternalAssetLoader.loadBedrockModels(DEFAULT_BULLET_MODEL);
        InternalAssetLoader.loadBedrockModels(STATUE_MODEL_LOCATION);
    }

    private static BedrockAnimationFile loadAnimations(ResourceLocation resourceLocation) {
        BedrockAnimationFile bedrockAnimationFile;
        block8: {
            InputStream inputStream = Minecraft.m_91087_().m_91098_().m_215595_(resourceLocation);
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                JsonObject json = JsonParser.parseReader((Reader)bufferedReader).getAsJsonObject();
                bedrockAnimationFile = (BedrockAnimationFile)ClientGunPackLoader.GSON.fromJson((JsonElement)json, BedrockAnimationFile.class);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonIOException | JsonSyntaxException | IOException e) {
                    throw new RuntimeException(e);
                }
            }
            inputStream.close();
        }
        return bedrockAnimationFile;
    }

    private static void loadBedrockModels(ResourceLocation location) {
        try (InputStream stream = Minecraft.m_91087_().m_91098_().m_215595_(location);){
            BedrockModelPOJO pojo = (BedrockModelPOJO)ClientGunPackLoader.GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), BedrockModelPOJO.class);
            BEDROCK_MODELS.put(location, new BedrockModel(pojo, BedrockVersion.NEW));
        }
        catch (JsonIOException | JsonSyntaxException | IOException e) {
            e.fillInStackTrace();
        }
    }

    public static List<ObjectAnimation> getDefaultPistolAnimations() {
        return defaultPistolAnimations;
    }

    public static List<ObjectAnimation> getDefaultRifleAnimations() {
        return defaultRifleAnimations;
    }

    public static Optional<BedrockModel> getBedrockModel(ResourceLocation location) {
        return Optional.ofNullable(BEDROCK_MODELS.get(location));
    }
}

