/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.resource;

import com.tacz.guns.client.download.ClientGunPackDownloadManager;
import com.tacz.guns.client.resource.ClientGunPackLoader;
import com.tacz.guns.config.ServerConfig;
import com.tacz.guns.config.sync.SyncConfig;
import com.tacz.guns.network.message.ServerMessageSyncGunPack;
import com.tacz.guns.resource.CommonGunPackLoader;
import com.tacz.guns.resource.VersionChecker;
import com.tacz.guns.resource.network.CommonGunPackNetwork;
import com.tacz.guns.resource.network.DataType;
import java.io.File;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;

public class ClientReloadManager {
    private static final EnumMap<DataType, Map<ResourceLocation, String>> LOCALE_CACHE = new EnumMap(DataType.class);

    public static void reloadAllPack() {
        VersionChecker.clearCache();
        ClientGunPackLoader.init();
        CommonGunPackLoader.reloadAsset();
        ClientGunPackLoader.reloadAsset();
        CommonGunPackLoader.reloadIndex();
        ClientGunPackLoader.reloadIndex();
        CommonGunPackLoader.reloadRecipes();
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91091_() && mc.m_91092_() != null && mc.m_91092_().m_6992_()) {
            CommonGunPackNetwork.syncClientExceptSelf((MinecraftServer)mc.m_91092_(), (Player)Minecraft.m_91087_().f_91074_);
            return;
        }
        if (!mc.m_91090_()) {
            if (ServerConfig.SERVER_CONFIG_SPEC != null && ServerConfig.SERVER_CONFIG_SPEC.isLoaded() && !((List)SyncConfig.CLIENT_GUN_PACK_DOWNLOAD_URLS.get()).isEmpty()) {
                ClientGunPackDownloadManager.downloadClientGunPack();
            }
            if (!LOCALE_CACHE.isEmpty()) {
                CommonGunPackNetwork.loadFromCache(LOCALE_CACHE);
            }
        }
    }

    public static void loadClientDownloadGunPack(File file) {
        ClientGunPackLoader.readZipAsset(file);
        if (!LOCALE_CACHE.isEmpty()) {
            CommonGunPackNetwork.loadFromCache(LOCALE_CACHE);
        }
    }

    public static void cacheAll(ServerMessageSyncGunPack message) {
        LOCALE_CACHE.clear();
        LOCALE_CACHE.putAll(message.getCache());
    }
}

