/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gameplay;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.animation.statemachine.GunAnimationStateMachine;
import com.tacz.guns.client.gameplay.LocalPlayerDataHolder;
import com.tacz.guns.client.sound.SoundPlayManager;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.message.ClientMessagePlayerBoltGun;
import com.tacz.guns.resource.pojo.data.gun.Bolt;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class LocalPlayerBolt {
    private final LocalPlayerDataHolder data;
    private final LocalPlayer player;

    public LocalPlayerBolt(LocalPlayerDataHolder data, LocalPlayer player) {
        this.data = data;
        this.player = player;
    }

    public void bolt() {
        if (this.data.clientStateLock) {
            return;
        }
        if (this.data.isBolting) {
            return;
        }
        ItemStack mainhandItem = this.player.m_21205_();
        Item item = mainhandItem.m_41720_();
        if (!(item instanceof IGun)) {
            return;
        }
        IGun iGun = (IGun)item;
        ResourceLocation gunId = iGun.getGunId(mainhandItem);
        TimelessAPI.getClientGunIndex(gunId).ifPresent(gunIndex -> {
            Bolt boltType = gunIndex.getGunData().getBolt();
            if (boltType != Bolt.MANUAL_ACTION) {
                return;
            }
            if (iGun.hasBulletInBarrel(mainhandItem)) {
                return;
            }
            if (iGun.getCurrentAmmoCount(mainhandItem) == 0) {
                return;
            }
            this.data.lockState(operator -> operator.getSynBoltCoolDown() >= 0L);
            this.data.isBolting = true;
            NetworkHandler.CHANNEL.sendToServer((Object)new ClientMessagePlayerBoltGun());
            GunAnimationStateMachine animationStateMachine = gunIndex.getAnimationStateMachine();
            if (animationStateMachine != null) {
                SoundPlayManager.playBoltSound((LivingEntity)this.player, gunIndex);
                animationStateMachine.onGunBolt();
            }
        });
    }

    public void tickAutoBolt() {
        ItemStack mainhandItem = this.player.m_21205_();
        Item item = mainhandItem.m_41720_();
        if (!(item instanceof IGun)) {
            this.data.isBolting = false;
            return;
        }
        IGun iGun = (IGun)item;
        this.bolt();
        if (this.data.isBolting && iGun.hasBulletInBarrel(mainhandItem)) {
            this.data.isBolting = false;
        }
    }
}

