/*
 * Decompiled with CFR 0.152.
 */
package net.grid.vampiresdelight.data.recipe;

import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModItems;
import java.util.Objects;
import java.util.function.Consumer;
import net.grid.vampiresdelight.common.registry.VDItems;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.registries.ForgeRegistries;
import vectorwing.farmersdelight.common.crafting.ingredient.ToolActionIngredient;
import vectorwing.farmersdelight.common.tag.ForgeTags;
import vectorwing.farmersdelight.data.builder.CuttingBoardRecipeBuilder;

public class VDCuttingRecipes {
    public static void register(Consumer<FinishedRecipe> consumer) {
        VDCuttingRecipes.cuttingAnimalItems(consumer);
        VDCuttingRecipes.cuttingFoods(consumer);
        VDCuttingRecipes.cuttingFlowers(consumer);
        VDCuttingRecipes.salvagingMinerals(consumer);
        VDCuttingRecipes.strippingWood(consumer);
        VDCuttingRecipes.salvagingWoodenFurniture(consumer);
        VDCuttingRecipes.salvagingUsingShears(consumer);
    }

    private static void cuttingAnimalItems(Consumer<FinishedRecipe> consumer) {
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.HUMAN_HEART.get()}), (Ingredient)Ingredient.m_204132_((TagKey)ForgeTags.TOOLS_KNIVES), (ItemLike)((ItemLike)VDItems.HEART_PIECES.get()), (int)2).build(consumer, VDCuttingRecipes.itemLocationCutting((Item)ModItems.HUMAN_HEART.get()));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)VDItems.RAW_BAT.get()}), (Ingredient)Ingredient.m_204132_((TagKey)ForgeTags.TOOLS_KNIVES), (ItemLike)((ItemLike)VDItems.RAW_BAT_CHOPS.get()), (int)2).build(consumer, VDCuttingRecipes.itemLocationCutting((Item)VDItems.RAW_BAT.get()));
    }

    private static void cuttingFoods(Consumer<FinishedRecipe> consumer) {
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)VDItems.BLOOD_PIE.get()}), (Ingredient)Ingredient.m_204132_((TagKey)ForgeTags.TOOLS_KNIVES), (ItemLike)((ItemLike)VDItems.BLOOD_PIE_SLICE.get()), (int)4).build(consumer, VDCuttingRecipes.itemLocationCutting((Item)VDItems.BLOOD_PIE.get()));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)VDItems.ORCHID_CAKE.get()}), (Ingredient)Ingredient.m_204132_((TagKey)ForgeTags.TOOLS_KNIVES), (ItemLike)((ItemLike)VDItems.ORCHID_CAKE_SLICE.get()), (int)7).build(consumer, VDCuttingRecipes.itemLocationCutting((Item)VDItems.ORCHID_CAKE.get()));
    }

    private static void cuttingFlowers(Consumer<FinishedRecipe> consumer) {
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)VDItems.WILD_GARLIC.get()}), (Ingredient)Ingredient.m_204132_((TagKey)ForgeTags.TOOLS_KNIVES), (ItemLike)((ItemLike)ModItems.ITEM_GARLIC.get()), (int)1).addResult((ItemLike)Items.f_42491_, 2).addResultWithChance((ItemLike)Items.f_42496_, 0.25f).build(consumer, VDCuttingRecipes.itemLocationCutting((Item)VDItems.WILD_GARLIC.get()));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.VAMPIRE_ORCHID.get()}), (Ingredient)Ingredient.m_204132_((TagKey)ForgeTags.TOOLS_KNIVES), (ItemLike)((ItemLike)VDItems.ORCHID_PETALS.get()), (int)2).addResultWithChance((ItemLike)VDItems.ORCHID_SEEDS.get(), 0.7f, 2).addResultWithChance((ItemLike)ModBlocks.CURSED_ROOTS.get(), 0.3f, 1).build(consumer, VDCuttingRecipes.blockLocationCutting((Block)ModBlocks.VAMPIRE_ORCHID.get()));
    }

    private static void salvagingMinerals(Consumer<FinishedRecipe> consumer) {
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.DARK_STONE.get()}), (Ingredient)new ToolActionIngredient(ToolActions.PICKAXE_DIG), (ItemLike)((ItemLike)ModBlocks.COBBLED_DARK_STONE.get()), (int)1).build(consumer, VDCuttingRecipes.blockLocationCutting((Block)ModBlocks.DARK_STONE.get()));
    }

    private static void strippingWood(Consumer<FinishedRecipe> consumer) {
        VDCuttingRecipes.stripLogForBark(consumer, (Block)ModBlocks.CURSED_SPRUCE_LOG.get(), (Block)ModBlocks.STRIPPED_CURSED_SPRUCE_LOG.get());
        VDCuttingRecipes.stripLogForBark(consumer, (Block)ModBlocks.DARK_SPRUCE_LOG.get(), (Block)ModBlocks.STRIPPED_DARK_SPRUCE_LOG.get());
    }

    private static void salvagingWoodenFurniture(Consumer<FinishedRecipe> consumer) {
        VDCuttingRecipes.salvagePlankFromFurniture(consumer, (Block)ModBlocks.CURSED_SPRUCE_PLANKS.get(), (Block)ModBlocks.CURSED_SPRUCE_DOOR.get(), (Block)ModBlocks.CURSED_SPRUCE_TRAPDOOR.get(), (Block)ModBlocks.CURSED_SPRUCE_SIGN.get(), (Block)ModBlocks.CURSED_SPRUCE_HANGING_SIGN.get());
        VDCuttingRecipes.salvagePlankFromFurniture(consumer, (Block)ModBlocks.DARK_SPRUCE_PLANKS.get(), (Block)ModBlocks.DARK_SPRUCE_DOOR.get(), (Block)ModBlocks.DARK_SPRUCE_TRAPDOOR.get(), (Block)ModBlocks.DARK_SPRUCE_SIGN.get(), (Block)ModBlocks.DARK_SPRUCE_HANGING_SIGN.get());
    }

    private static void salvagingUsingShears(Consumer<FinishedRecipe> consumer) {
        VDCuttingRecipes.salvageLeatherArmor(consumer, 1, (Item)ModItems.ARMOR_OF_SWIFTNESS_HEAD_NORMAL.get(), (Item)ModItems.ARMOR_OF_SWIFTNESS_CHEST_NORMAL.get(), (Item)ModItems.ARMOR_OF_SWIFTNESS_LEGS_NORMAL.get(), (Item)ModItems.ARMOR_OF_SWIFTNESS_FEET_NORMAL.get());
        VDCuttingRecipes.salvageLeatherArmor(consumer, 2, (Item)ModItems.ARMOR_OF_SWIFTNESS_HEAD_ENHANCED.get(), (Item)ModItems.ARMOR_OF_SWIFTNESS_CHEST_ENHANCED.get(), (Item)ModItems.ARMOR_OF_SWIFTNESS_LEGS_ENHANCED.get(), (Item)ModItems.ARMOR_OF_SWIFTNESS_FEET_ENHANCED.get(), (Item)ModItems.ARMOR_OF_SWIFTNESS_HEAD_ULTIMATE.get(), (Item)ModItems.ARMOR_OF_SWIFTNESS_CHEST_ULTIMATE.get(), (Item)ModItems.ARMOR_OF_SWIFTNESS_LEGS_ULTIMATE.get(), (Item)ModItems.ARMOR_OF_SWIFTNESS_FEET_ULTIMATE.get());
    }

    private static void stripLogForBark(Consumer<FinishedRecipe> consumer, Block log, Block strippedLog) {
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{log}), (Ingredient)new ToolActionIngredient(ToolActions.AXE_STRIP), (ItemLike)strippedLog).addResult((ItemLike)vectorwing.farmersdelight.common.registry.ModItems.TREE_BARK.get()).addSound(Objects.requireNonNull(ForgeRegistries.SOUND_EVENTS.getKey((Object)SoundEvents.f_11688_)).toString()).build(consumer, VDCuttingRecipes.blockLocationCutting(log));
    }

    private static void salvagePlankFromFurniture(Consumer<FinishedRecipe> consumer, Block plank, Block door, Block trapdoor, Block sign, Block hangingSign) {
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{door}), (Ingredient)new ToolActionIngredient(ToolActions.AXE_DIG), (ItemLike)plank).build(consumer, VDCuttingRecipes.blockLocationCutting(door));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{trapdoor}), (Ingredient)new ToolActionIngredient(ToolActions.AXE_DIG), (ItemLike)plank).build(consumer, VDCuttingRecipes.blockLocationCutting(trapdoor));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{sign}), (Ingredient)new ToolActionIngredient(ToolActions.AXE_DIG), (ItemLike)plank).build(consumer, VDCuttingRecipes.blockLocationCutting(sign));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{hangingSign}), (Ingredient)new ToolActionIngredient(ToolActions.AXE_DIG), (ItemLike)plank).build(consumer, VDCuttingRecipes.blockLocationCutting(hangingSign));
    }

    private static void salvageLeatherArmor(Consumer<FinishedRecipe> consumer, int leatherAmount, Item ... items) {
        for (Item item : items) {
            CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), (Ingredient)Ingredient.m_204132_((TagKey)Tags.Items.SHEARS), (ItemLike)Items.f_42454_, (int)leatherAmount).build(consumer, VDCuttingRecipes.itemLocationCutting(item));
        }
    }

    private static ResourceLocation itemLocationCutting(Item item) {
        return new ResourceLocation("vampiresdelight:cutting/" + Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item)).m_135815_());
    }

    private static ResourceLocation blockLocationCutting(Block block) {
        return new ResourceLocation("vampiresdelight:cutting/" + Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_());
    }
}

