/*
 * Decompiled with CFR 0.152.
 */
package net.grid.vampiresdelight.data.recipe;

import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModTags;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.grid.vampiresdelight.common.registry.VDBlocks;
import net.grid.vampiresdelight.common.registry.VDItems;
import net.grid.vampiresdelight.common.tag.VDForgeTags;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import vectorwing.farmersdelight.common.tag.ForgeTags;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class VDCraftingRecipes {
    public static final List<Item> DYES = List.of(Items.f_42498_, Items.f_42494_, Items.f_42495_, Items.f_42492_, Items.f_42490_, Items.f_42496_, Items.f_42538_, Items.f_42491_, Items.f_42540_, Items.f_42537_, Items.f_42536_, Items.f_42489_, Items.f_42493_, Items.f_42497_, Items.f_42539_, Items.f_42535_);

    public static void register(Consumer<FinishedRecipe> consumer) {
        VDCraftingRecipes.recipesBlocks(consumer);
        VDCraftingRecipes.recipesMaterials(consumer);
        VDCraftingRecipes.recipesFoodstuffs(consumer);
        VDCraftingRecipes.recipesPouring(consumer);
        VDCraftingRecipes.recipesFoodBlocks(consumer);
        VDCraftingRecipes.recipesCraftedMeals(consumer);
    }

    private static void recipesBlocks(Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)VDBlocks.DARK_STONE_STOVE.get())).m_126130_("iii").m_126130_("d d").m_126130_("dCd").m_206416_(Character.valueOf('i'), Tags.Items.INGOTS_IRON).m_126127_(Character.valueOf('d'), (ItemLike)ModBlocks.DARK_STONE_BRICKS.get()).m_126127_(Character.valueOf('C'), (ItemLike)Blocks.f_50683_).m_126132_(VDCraftingRecipes.hasBlock((Block)ModBlocks.DARK_STONE_BRICKS.get()), (CriterionTriggerInstance)VDCraftingRecipes.has((ItemLike)ModBlocks.DARK_STONE_BRICKS.get())).m_126132_(VDCraftingRecipes.hasBlock(Blocks.f_50683_), (CriterionTriggerInstance)VDCraftingRecipes.has((ItemLike)Blocks.f_50683_)).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)VDBlocks.DARK_SPRUCE_CABINET.get())).m_126130_("___").m_126130_("D D").m_126130_("___").m_126127_(Character.valueOf('_'), (ItemLike)ModBlocks.DARK_SPRUCE_SLAB.get()).m_126127_(Character.valueOf('D'), (ItemLike)ModBlocks.DARK_SPRUCE_TRAPDOOR.get()).m_126132_(VDCraftingRecipes.hasBlock((Block)ModBlocks.DARK_SPRUCE_TRAPDOOR.get()), (CriterionTriggerInstance)VDCraftingRecipes.has((ItemLike)ModBlocks.DARK_SPRUCE_TRAPDOOR.get())).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)VDBlocks.CURSED_SPRUCE_CABINET.get())).m_126130_("___").m_126130_("D D").m_126130_("___").m_126127_(Character.valueOf('_'), (ItemLike)ModBlocks.CURSED_SPRUCE_SLAB.get()).m_126127_(Character.valueOf('D'), (ItemLike)ModBlocks.CURSED_SPRUCE_TRAPDOOR.get()).m_126132_(VDCraftingRecipes.hasBlock((Block)ModBlocks.CURSED_SPRUCE_TRAPDOOR.get()), (CriterionTriggerInstance)VDCraftingRecipes.has((ItemLike)ModBlocks.CURSED_SPRUCE_TRAPDOOR.get())).m_176498_(consumer);
        VDCraftingRecipes.wineShelfRecipe((Block)VDBlocks.OAK_WINE_SHELF.get(), Blocks.f_50398_, Blocks.f_50705_, consumer);
        VDCraftingRecipes.wineShelfRecipe((Block)VDBlocks.SPRUCE_WINE_SHELF.get(), Blocks.f_50399_, Blocks.f_50741_, consumer);
        VDCraftingRecipes.wineShelfRecipe((Block)VDBlocks.BIRCH_WINE_SHELF.get(), Blocks.f_50400_, Blocks.f_50742_, consumer);
        VDCraftingRecipes.wineShelfRecipe((Block)VDBlocks.JUNGLE_WINE_SHELF.get(), Blocks.f_50401_, Blocks.f_50743_, consumer);
        VDCraftingRecipes.wineShelfRecipe((Block)VDBlocks.ACACIA_WINE_SHELF.get(), Blocks.f_50402_, Blocks.f_50744_, consumer);
        VDCraftingRecipes.wineShelfRecipe((Block)VDBlocks.DARK_OAK_WINE_SHELF.get(), Blocks.f_50403_, Blocks.f_50745_, consumer);
        VDCraftingRecipes.wineShelfRecipe((Block)VDBlocks.MANGROVE_WINE_SHELF.get(), Blocks.f_220851_, Blocks.f_220865_, consumer);
        VDCraftingRecipes.wineShelfRecipe((Block)VDBlocks.CHERRY_WINE_SHELF.get(), Blocks.f_271301_, Blocks.f_271304_, consumer);
        VDCraftingRecipes.wineShelfRecipe((Block)VDBlocks.BAMBOO_WINE_SHELF.get(), Blocks.f_244004_, Blocks.f_244477_, consumer);
        VDCraftingRecipes.wineShelfRecipe((Block)VDBlocks.CRIMSON_WINE_SHELF.get(), Blocks.f_50657_, Blocks.f_50655_, consumer);
        VDCraftingRecipes.wineShelfRecipe((Block)VDBlocks.WARPED_WINE_SHELF.get(), Blocks.f_50658_, Blocks.f_50656_, consumer);
        VDCraftingRecipes.wineShelfRecipe((Block)VDBlocks.CURSED_SPRUCE_WINE_SHELF.get(), (Block)ModBlocks.CURSED_SPRUCE_SLAB.get(), (Block)ModBlocks.CURSED_SPRUCE_PLANKS.get(), consumer);
        VDCraftingRecipes.wineShelfRecipe((Block)VDBlocks.DARK_SPRUCE_WINE_SHELF.get(), (Block)ModBlocks.DARK_SPRUCE_SLAB.get(), (Block)ModBlocks.DARK_SPRUCE_PLANKS.get(), consumer);
        VDCraftingRecipes.barStoolRecipe((Block)VDBlocks.WHITE_BAR_STOOL.get(), Blocks.f_50041_, consumer);
        VDCraftingRecipes.barStoolRecipe((Block)VDBlocks.ORANGE_BAR_STOOL.get(), Blocks.f_50042_, consumer);
        VDCraftingRecipes.barStoolRecipe((Block)VDBlocks.MAGENTA_BAR_STOOL.get(), Blocks.f_50096_, consumer);
        VDCraftingRecipes.barStoolRecipe((Block)VDBlocks.LIGHT_BLUE_BAR_STOOL.get(), Blocks.f_50097_, consumer);
        VDCraftingRecipes.barStoolRecipe((Block)VDBlocks.YELLOW_BAR_STOOL.get(), Blocks.f_50098_, consumer);
        VDCraftingRecipes.barStoolRecipe((Block)VDBlocks.LIME_BAR_STOOL.get(), Blocks.f_50099_, consumer);
        VDCraftingRecipes.barStoolRecipe((Block)VDBlocks.PINK_BAR_STOOL.get(), Blocks.f_50100_, consumer);
        VDCraftingRecipes.barStoolRecipe((Block)VDBlocks.GRAY_BAR_STOOL.get(), Blocks.f_50101_, consumer);
        VDCraftingRecipes.barStoolRecipe((Block)VDBlocks.LIGHT_GRAY_BAR_STOOL.get(), Blocks.f_50102_, consumer);
        VDCraftingRecipes.barStoolRecipe((Block)VDBlocks.CYAN_BAR_STOOL.get(), Blocks.f_50103_, consumer);
        VDCraftingRecipes.barStoolRecipe((Block)VDBlocks.PURPLE_BAR_STOOL.get(), Blocks.f_50104_, consumer);
        VDCraftingRecipes.barStoolRecipe((Block)VDBlocks.BLUE_BAR_STOOL.get(), Blocks.f_50105_, consumer);
        VDCraftingRecipes.barStoolRecipe((Block)VDBlocks.BROWN_BAR_STOOL.get(), Blocks.f_50106_, consumer);
        VDCraftingRecipes.barStoolRecipe((Block)VDBlocks.GREEN_BAR_STOOL.get(), Blocks.f_50107_, consumer);
        VDCraftingRecipes.barStoolRecipe((Block)VDBlocks.RED_BAR_STOOL.get(), Blocks.f_50108_, consumer);
        VDCraftingRecipes.barStoolRecipe((Block)VDBlocks.BLACK_BAR_STOOL.get(), Blocks.f_50109_, consumer);
        VDCraftingRecipes.colorBlockWithDye(List.of((Item)VDItems.BLACK_BAR_STOOL.get(), (Item)VDItems.BLUE_BAR_STOOL.get(), (Item)VDItems.BROWN_BAR_STOOL.get(), (Item)VDItems.CYAN_BAR_STOOL.get(), (Item)VDItems.GRAY_BAR_STOOL.get(), (Item)VDItems.GREEN_BAR_STOOL.get(), (Item)VDItems.LIGHT_BLUE_BAR_STOOL.get(), (Item)VDItems.LIGHT_GRAY_BAR_STOOL.get(), (Item)VDItems.LIME_BAR_STOOL.get(), (Item)VDItems.MAGENTA_BAR_STOOL.get(), (Item)VDItems.ORANGE_BAR_STOOL.get(), (Item)VDItems.PINK_BAR_STOOL.get(), (Item)VDItems.PURPLE_BAR_STOOL.get(), (Item)VDItems.RED_BAR_STOOL.get(), (Item)VDItems.YELLOW_BAR_STOOL.get(), (Item)VDItems.WHITE_BAR_STOOL.get()), consumer);
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)VDItems.GARLIC_CRATE.get()), (int)1).m_126130_("###").m_126130_("###").m_126130_("###").m_126127_(Character.valueOf('#'), (ItemLike)ModItems.ITEM_GARLIC.get()).m_126132_("has_garlic", (CriterionTriggerInstance)VDCraftingRecipes.has((ItemLike)ModItems.ITEM_GARLIC.get())).m_176498_(consumer);
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)VDItems.ORCHID_BAG.get()), (int)1).m_126130_("###").m_126130_("###").m_126130_("###").m_126127_(Character.valueOf('#'), (ItemLike)VDItems.ORCHID_PETALS.get()).m_126132_(VDCraftingRecipes.hasItem((Item)VDItems.ORCHID_PETALS.get()), (CriterionTriggerInstance)VDCraftingRecipes.has((ItemLike)VDItems.ORCHID_PETALS.get())).m_176498_(consumer);
    }

    private static void recipesMaterials(Consumer<FinishedRecipe> consumer) {
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.ITEM_GARLIC.get()), (int)9).m_126209_((ItemLike)VDItems.GARLIC_CRATE.get()).m_126132_(VDCraftingRecipes.hasItem((Item)VDItems.GARLIC_CRATE.get()), (CriterionTriggerInstance)VDCraftingRecipes.has((ItemLike)VDItems.GARLIC_CRATE.get())).m_126140_(consumer, new ResourceLocation("vampiresdelight", "garlic_from_crate"));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)VDItems.ORCHID_PETALS.get()), (int)9).m_126209_((ItemLike)VDItems.ORCHID_BAG.get()).m_126132_(VDCraftingRecipes.hasItem((Item)VDItems.ORCHID_BAG.get()), (CriterionTriggerInstance)VDCraftingRecipes.has((ItemLike)VDItems.ORCHID_BAG.get())).m_126140_(consumer, new ResourceLocation("vampiresdelight", "orchid_petals_from_bag"));
    }

    private static void recipesFoodstuffs(Consumer<FinishedRecipe> consumer) {
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)VDItems.RICE_DOUGH.get()), (int)3).m_126209_((ItemLike)Items.f_42447_).m_206419_(ForgeTags.CROPS_RICE).m_206419_(ForgeTags.CROPS_RICE).m_206419_(ForgeTags.CROPS_RICE).m_126132_("has_rice", (CriterionTriggerInstance)VDCraftingRecipes.has((TagKey<Item>)ForgeTags.CROPS_RICE)).m_126140_(consumer, new ResourceLocation("vampiresdelight", "rice_dough_from_water"));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)VDItems.RICE_DOUGH.get()), (int)3).m_206419_(ForgeTags.EGGS).m_206419_(ForgeTags.CROPS_RICE).m_206419_(ForgeTags.CROPS_RICE).m_206419_(ForgeTags.CROPS_RICE).m_126132_("has_rice", (CriterionTriggerInstance)VDCraftingRecipes.has((TagKey<Item>)ForgeTags.CROPS_RICE)).m_126140_(consumer, new ResourceLocation("vampiresdelight", "rice_dough_from_eggs"));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)VDItems.BLOOD_DOUGH.get()), (int)1).m_126209_((ItemLike)VDItems.BLOOD_SYRUP.get()).m_126209_((ItemLike)VDItems.RICE_DOUGH.get()).m_126132_(VDCraftingRecipes.hasItem((Item)VDItems.BLOOD_SYRUP.get()), (CriterionTriggerInstance)VDCraftingRecipes.has((ItemLike)VDItems.BLOOD_SYRUP.get())).m_176498_(consumer);
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)VDItems.PURE_SORBET.get()), (int)1).m_126130_(" sa").m_126130_("ips").m_126130_("ti ").m_206416_(Character.valueOf('p'), ModTags.Items.PURE_BLOOD).m_126127_(Character.valueOf('s'), (ItemLike)Items.f_42780_).m_126127_(Character.valueOf('a'), (ItemLike)Items.f_42410_).m_126127_(Character.valueOf('i'), (ItemLike)Items.f_41980_).m_126127_(Character.valueOf('t'), (ItemLike)Items.f_42398_).m_126132_("has_pure_blood", (CriterionTriggerInstance)VDCraftingRecipes.has((TagKey<Item>)ModTags.Items.PURE_BLOOD)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)VDItems.SUGARED_BERRIES.get()), (int)1).m_126209_((ItemLike)Items.f_42780_).m_126209_((ItemLike)Items.f_42501_).m_126132_(VDCraftingRecipes.hasItem(Items.f_42780_), (CriterionTriggerInstance)VDCraftingRecipes.has((ItemLike)Items.f_42780_)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)VDItems.ORCHID_COOKIE.get()), (int)8).m_126209_((ItemLike)VDItems.ORCHID_PETALS.get()).m_126209_((ItemLike)Items.f_42405_).m_126209_((ItemLike)Items.f_42405_).m_126132_(VDCraftingRecipes.hasItem((Item)VDItems.ORCHID_PETALS.get()), (CriterionTriggerInstance)VDCraftingRecipes.has((ItemLike)VDItems.ORCHID_PETALS.get())).m_126140_(consumer, new ResourceLocation("vampiresdelight", "orchid_cookie_from_wheat"));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)VDItems.ORCHID_COOKIE.get()), (int)8).m_126209_((ItemLike)VDItems.ORCHID_PETALS.get()).m_206419_(ForgeTags.CROPS_RICE).m_206419_(ForgeTags.CROPS_RICE).m_126132_(VDCraftingRecipes.hasItem((Item)VDItems.ORCHID_PETALS.get()), (CriterionTriggerInstance)VDCraftingRecipes.has((ItemLike)VDItems.ORCHID_PETALS.get())).m_126140_(consumer, new ResourceLocation("vampiresdelight", "orchid_cookie_from_rice"));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)VDItems.CURSED_CUPCAKE.get())).m_126209_((ItemLike)VDItems.BLOOD_BAGEL.get()).m_206419_(ForgeTags.MILK).m_126209_((ItemLike)Items.f_42501_).m_126132_(VDCraftingRecipes.hasItem((Item)VDItems.BLOOD_BAGEL.get()), (CriterionTriggerInstance)VDCraftingRecipes.has((ItemLike)VDItems.BLOOD_BAGEL.get())).m_176498_(consumer);
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)VDItems.ORCHID_ECLAIR.get()), (int)1).m_126209_((ItemLike)VDItems.ORCHID_PETALS.get()).m_206419_(ForgeTags.BREAD).m_126209_((ItemLike)Items.f_42780_).m_126132_(VDCraftingRecipes.hasItem((Item)VDItems.ORCHID_PETALS.get()), (CriterionTriggerInstance)VDCraftingRecipes.has((ItemLike)VDItems.ORCHID_PETALS.get())).m_176498_(consumer);
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)VDItems.ORCHID_ICE_CREAM.get()), (int)1).m_126209_((ItemLike)VDItems.ORCHID_PETALS.get()).m_126209_((ItemLike)VDItems.ORCHID_PETALS.get()).m_206419_(ForgeTags.MILK).m_126209_((ItemLike)Items.f_41980_).m_126209_((ItemLike)Items.f_42501_).m_126209_((ItemLike)Items.f_42399_).m_126132_(VDCraftingRecipes.hasItem((Item)VDItems.ORCHID_PETALS.get()), (CriterionTriggerInstance)VDCraftingRecipes.has((ItemLike)VDItems.ORCHID_PETALS.get())).m_176498_(consumer);
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)VDItems.SNOW_WHITE_ICE_CREAM.get()), (int)1).m_206419_(ModTags.Items.HOLY_WATER).m_206419_(ForgeTags.MILK).m_126209_((ItemLike)Items.f_42533_).m_126209_((ItemLike)Items.f_41980_).m_126209_((ItemLike)Items.f_42501_).m_126132_("has_holy_water", (CriterionTriggerInstance)VDCraftingRecipes.has((TagKey<Item>)ModTags.Items.HOLY_WATER)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)VDItems.DARK_ICE_CREAM.get()), (int)1).m_126209_((ItemLike)VDItems.BLOOD_SYRUP.get()).m_206419_(ForgeTags.GRAIN).m_206419_(ForgeTags.GRAIN).m_126209_((ItemLike)Items.f_41980_).m_126209_((ItemLike)Items.f_41980_).m_126184_(Ingredient.m_43938_(Stream.of(new Ingredient.ItemValue(new ItemStack((ItemLike)Items.f_42532_)), new Ingredient.ItemValue(new ItemStack((ItemLike)ModBlocks.CURSED_SPRUCE_SAPLING.get())), new Ingredient.ItemValue(new ItemStack((ItemLike)ModBlocks.DARK_SPRUCE_SAPLING.get())), new Ingredient.ItemValue(new ItemStack((ItemLike)ModBlocks.DARK_SPRUCE_LEAVES.get()))))).m_126132_(VDCraftingRecipes.hasItem((Item)VDItems.BLOOD_SYRUP.get()), (CriterionTriggerInstance)VDCraftingRecipes.has((ItemLike)VDItems.BLOOD_SYRUP.get())).m_176498_(consumer);
    }

    private static void recipesPouring(Consumer<FinishedRecipe> consumer) {
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)VDItems.DANDELION_BEER_MUG.get()), (int)1).m_126209_((ItemLike)VDItems.DANDELION_BEER_BOTTLE.get()).m_126209_((ItemLike)Items.f_42590_).m_126132_(VDCraftingRecipes.hasItem((Item)VDItems.DANDELION_BEER_BOTTLE.get()), (CriterionTriggerInstance)VDCraftingRecipes.has((ItemLike)VDItems.DANDELION_BEER_BOTTLE.get())).m_176498_(consumer);
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)VDItems.BLOOD_WINE_GLASS.get()), (int)1).m_126209_((ItemLike)VDItems.BLOOD_WINE_BOTTLE.get()).m_126209_((ItemLike)Items.f_42590_).m_126132_(VDCraftingRecipes.hasItem((Item)VDItems.BLOOD_WINE_BOTTLE.get()), (CriterionTriggerInstance)VDCraftingRecipes.has((ItemLike)VDItems.BLOOD_WINE_BOTTLE.get())).m_176498_(consumer);
    }

    private static void recipesFoodBlocks(Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)VDItems.BLOOD_PIE.get()), (int)1).m_126130_("sss").m_126130_("wxw").m_126130_("bOb").m_126127_(Character.valueOf('w'), (ItemLike)Items.f_42588_).m_126127_(Character.valueOf('b'), (ItemLike)VDItems.BLOOD_SYRUP.get()).m_126127_(Character.valueOf('x'), (ItemLike)Items.f_42501_).m_126127_(Character.valueOf('s'), (ItemLike)Items.f_42780_).m_126127_(Character.valueOf('O'), (ItemLike)vectorwing.farmersdelight.common.registry.ModItems.PIE_CRUST.get()).m_126132_(VDCraftingRecipes.hasItem((Item)VDItems.BLOOD_SYRUP.get()), (CriterionTriggerInstance)VDCraftingRecipes.has((ItemLike)VDItems.BLOOD_SYRUP.get())).m_176498_(consumer);
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)VDItems.BLOOD_PIE.get()), (int)1).m_126130_("##").m_126130_("##").m_126127_(Character.valueOf('#'), (ItemLike)VDItems.BLOOD_PIE_SLICE.get()).m_126132_(VDCraftingRecipes.hasItem((Item)VDItems.BLOOD_PIE_SLICE.get()), (CriterionTriggerInstance)VDCraftingRecipes.has((ItemLike)VDItems.BLOOD_PIE_SLICE.get())).m_126140_(consumer, new ResourceLocation("vampiresdelight", "blood_pie_from_slices"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)VDItems.ORCHID_CAKE.get()), (int)1).m_126130_("mmm").m_126130_("oso").m_126130_("www").m_206416_(Character.valueOf('m'), ForgeTags.MILK).m_126127_(Character.valueOf('o'), (ItemLike)VDItems.ORCHID_PETALS.get()).m_126127_(Character.valueOf('s'), (ItemLike)Items.f_42501_).m_206416_(Character.valueOf('w'), ForgeTags.GRAIN_WHEAT).m_126132_(VDCraftingRecipes.hasItem((Item)VDItems.ORCHID_PETALS.get()), (CriterionTriggerInstance)VDCraftingRecipes.has((ItemLike)VDItems.ORCHID_PETALS.get())).m_176498_(consumer);
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)VDItems.ORCHID_CAKE.get()), (int)1).m_126209_((ItemLike)VDItems.ORCHID_CAKE_SLICE.get()).m_126209_((ItemLike)VDItems.ORCHID_CAKE_SLICE.get()).m_126209_((ItemLike)VDItems.ORCHID_CAKE_SLICE.get()).m_126209_((ItemLike)VDItems.ORCHID_CAKE_SLICE.get()).m_126209_((ItemLike)VDItems.ORCHID_CAKE_SLICE.get()).m_126209_((ItemLike)VDItems.ORCHID_CAKE_SLICE.get()).m_126209_((ItemLike)VDItems.ORCHID_CAKE_SLICE.get()).m_126132_(VDCraftingRecipes.hasItem((Item)VDItems.ORCHID_CAKE_SLICE.get()), (CriterionTriggerInstance)VDCraftingRecipes.has((ItemLike)VDItems.ORCHID_CAKE_SLICE.get())).m_126140_(consumer, new ResourceLocation("vampiresdelight", "orchid_cake_from_slices"));
    }

    private static void recipesCraftedMeals(Consumer<FinishedRecipe> consumer) {
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)VDItems.FISH_BURGER.get())).m_206419_(VDForgeTags.BREAD_RICE).m_206419_(ForgeTags.COOKED_FISHES).m_206419_(ForgeTags.SALAD_INGREDIENTS).m_206419_(VDForgeTags.VEGETABLES_GARLIC).m_126132_("has_garlic", (CriterionTriggerInstance)VDCraftingRecipes.has(VDForgeTags.VEGETABLES_GARLIC)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)VDItems.BLOOD_SAUSAGE.get())).m_126209_((ItemLike)VDItems.BLOOD_SYRUP.get()).m_206419_(ForgeTags.VEGETABLES_ONION).m_126184_(Ingredient.m_43938_(Stream.of(new Ingredient.TagValue(ForgeTags.COOKED_BEEF), new Ingredient.TagValue(ForgeTags.COOKED_CHICKEN), new Ingredient.TagValue(ForgeTags.COOKED_MUTTON), new Ingredient.TagValue(ForgeTags.COOKED_PORK)))).m_126132_(VDCraftingRecipes.hasItem((Item)VDItems.BLOOD_SYRUP.get()), (CriterionTriggerInstance)VDCraftingRecipes.has((ItemLike)VDItems.BLOOD_SYRUP.get())).m_176498_(consumer);
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)VDItems.BLOOD_HOT_DOG.get())).m_126209_((ItemLike)VDItems.BLOOD_SAUSAGE.get()).m_206419_(ForgeTags.BREAD).m_126132_(VDCraftingRecipes.hasItem((Item)VDItems.BLOOD_SAUSAGE.get()), (CriterionTriggerInstance)VDCraftingRecipes.has((ItemLike)VDItems.BLOOD_SAUSAGE.get())).m_176498_(consumer);
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)VDItems.BAGEL_SANDWICH.get())).m_126209_((ItemLike)VDItems.BLOOD_BAGEL.get()).m_206419_(ForgeTags.COOKED_BACON).m_126209_((ItemLike)vectorwing.farmersdelight.common.registry.ModItems.FRIED_EGG.get()).m_126132_(VDCraftingRecipes.hasItem((Item)VDItems.BLOOD_BAGEL.get()), (CriterionTriggerInstance)VDCraftingRecipes.has((ItemLike)VDItems.BLOOD_BAGEL.get())).m_176498_(consumer);
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)VDItems.EYES_ON_STICK.get())).m_126209_((ItemLike)VDItems.HUMAN_EYE.get()).m_126209_((ItemLike)VDItems.HUMAN_EYE.get()).m_206419_(ForgeTags.CROPS_TOMATO).m_126184_(Ingredient.m_43938_(Stream.of(new Ingredient.ItemValue(new ItemStack((ItemLike)Items.f_41952_)), new Ingredient.ItemValue(new ItemStack((ItemLike)Items.f_41953_))))).m_126209_((ItemLike)Items.f_42398_).m_126132_(VDCraftingRecipes.hasItem((Item)VDItems.HUMAN_EYE.get()), (CriterionTriggerInstance)VDCraftingRecipes.has((ItemLike)VDItems.HUMAN_EYE.get())).m_176498_(consumer);
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)VDItems.EYE_CROISSANT.get())).m_206419_(ForgeTags.BREAD).m_126209_((ItemLike)VDItems.HUMAN_EYE.get()).m_126209_((ItemLike)VDItems.HUMAN_EYE.get()).m_206419_(ForgeTags.SALAD_INGREDIENTS).m_206419_(ForgeTags.CROPS_TOMATO).m_126132_(VDCraftingRecipes.hasItem((Item)VDItems.HUMAN_EYE.get()), (CriterionTriggerInstance)VDCraftingRecipes.has((ItemLike)VDItems.HUMAN_EYE.get())).m_176498_(consumer);
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)VDItems.BAT_TACO.get())).m_206419_(ForgeTags.BREAD).m_206419_(VDForgeTags.COOKED_BAT).m_206419_(ForgeTags.SALAD_INGREDIENTS).m_206419_(ForgeTags.CROPS_TOMATO).m_126132_("has_cooked_bat", (CriterionTriggerInstance)VDCraftingRecipes.has(VDForgeTags.COOKED_BAT)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)VDItems.HARDTACK.get())).m_126209_((ItemLike)Items.f_42405_).m_126209_((ItemLike)Items.f_42405_).m_126209_((ItemLike)Items.f_42405_).m_126209_((ItemLike)Items.f_42405_).m_126132_(VDCraftingRecipes.hasItem(Items.f_42405_), (CriterionTriggerInstance)VDCraftingRecipes.has((ItemLike)Items.f_42405_)).m_176498_(consumer);
    }

    private static void wineShelfRecipe(Block wineShelfBlock, Block slabBlock, Block planksBlock, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)wineShelfBlock).m_126130_("SSS").m_126130_(" P ").m_126130_("SSS").m_126127_(Character.valueOf('S'), (ItemLike)slabBlock).m_126127_(Character.valueOf('P'), (ItemLike)planksBlock).m_126132_(VDCraftingRecipes.hasBlock(slabBlock), (CriterionTriggerInstance)VDCraftingRecipes.has((ItemLike)slabBlock)).m_176498_(consumer);
    }

    private static void barStoolRecipe(Block barStoolBlock, Block woolBlock, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)barStoolBlock).m_126130_("W").m_126130_("F").m_126130_("F").m_206416_(Character.valueOf('F'), ItemTags.f_13176_).m_126127_(Character.valueOf('W'), (ItemLike)woolBlock).m_126132_(VDCraftingRecipes.hasBlock(woolBlock), (CriterionTriggerInstance)VDCraftingRecipes.has((ItemLike)woolBlock)).m_176498_(consumer);
    }

    private static void colorBlockWithDye(List<Item> pDyeableItems, Consumer<FinishedRecipe> consumer) {
        for (int i = 0; i < DYES.size(); ++i) {
            Item dyeItem = DYES.get(i);
            Item dyeableItem = pDyeableItems.get(i);
            ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)dyeableItem).m_126209_((ItemLike)dyeItem).m_126184_(Ingredient.m_43921_(pDyeableItems.stream().filter(item -> !item.equals(dyeableItem)).map(ItemStack::new))).m_126132_("has_needed_dye", (CriterionTriggerInstance)VDCraftingRecipes.has((ItemLike)dyeItem)).m_126140_(consumer, new ResourceLocation("vampiresdelight", "dye_" + VDCraftingRecipes.itemName(dyeableItem)));
        }
    }

    private static InventoryChangeTrigger.TriggerInstance has(ItemLike pItemLike) {
        return VDCraftingRecipes.inventoryTrigger(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{pItemLike}).m_45077_());
    }

    private static InventoryChangeTrigger.TriggerInstance has(TagKey<Item> pTag) {
        return VDCraftingRecipes.inventoryTrigger(ItemPredicate.Builder.m_45068_().m_204145_(pTag).m_45077_());
    }

    private static InventoryChangeTrigger.TriggerInstance inventoryTrigger(ItemPredicate ... pPredicates) {
        return new InventoryChangeTrigger.TriggerInstance(ContextAwarePredicate.f_285567_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, pPredicates);
    }

    private static String itemName(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item).m_135815_();
    }

    private static String blockName(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
    }

    private static String hasItem(Item item) {
        return "has_" + VDCraftingRecipes.itemName(item);
    }

    private static String hasBlock(Block block) {
        return "has_" + VDCraftingRecipes.blockName(block);
    }
}

