/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.decay;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.event.Event;
import dev.architectury.event.EventFactory;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.dimdev.dimdoors.world.decay.DecayCondition;
import org.dimdev.dimdoors.world.decay.DecayResult;
import org.dimdev.dimdoors.world.decay.DecaySource;

public record DecayPattern(List<DecayCondition> conditions, DecayResult result) {
    public static Codec<DecayPattern> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DecayCondition.LIST_CODEC.fieldOf("conditions").forGetter(DecayPattern::conditions), (App)DecayResult.CODEC.fieldOf("result").forGetter(DecayPattern::result)).apply((Applicative)instance, DecayPattern::new));
    public static final Event<EntropyEvent> ENTROPY_EVENT = EventFactory.of(entropyEvents -> (world, pos, entorpy) -> {
        for (EntropyEvent event : entropyEvents) {
            event.entropy(world, pos, entorpy);
        }
    });

    public boolean test(Level world, BlockPos pos, BlockState origin, BlockState targetBlock, FluidState targetFluid, DecaySource source) {
        return this.conditions.stream().allMatch(condition -> condition.test(world, pos, origin, targetBlock, targetFluid, source));
    }

    public void process(Level world, BlockPos pos, BlockState origin, BlockState targetBlock, FluidState targetFluid, DecaySource source) {
        ((EntropyEvent)ENTROPY_EVENT.invoker()).entropy(world, pos, this.result.process(world, pos, origin, targetBlock, targetFluid, source));
    }

    public Set<ResourceKey<Block>> constructApplicableBlocks() {
        return this.conditions.stream().flatMap(a -> a.constructApplicableBlocks().stream()).collect(Collectors.toSet());
    }

    public Set<ResourceKey<Fluid>> constructApplicableFluids() {
        return this.conditions.stream().flatMap(a -> a.constructApplicableFluids().stream()).collect(Collectors.toSet());
    }

    public Object willBecome(Object prior) {
        return this.result.produces(prior);
    }

    public boolean shouldDropThread(ServerLevel world, BlockPos pos) {
        return world.m_213780_().m_188501_() < this.result.worldThreadChance();
    }

    private static interface EntropyEvent {
        public void entropy(Level var1, BlockPos var2, int var3);
    }
}

