/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.rift.targets;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Rotations;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.rift.target.EntityTarget;
import org.dimdev.dimdoors.api.util.EntityUtils;
import org.dimdev.dimdoors.api.util.Location;
import org.dimdev.dimdoors.api.util.TeleportUtil;
import org.dimdev.dimdoors.block.ModBlocks;
import org.dimdev.dimdoors.block.UnravelUtil;
import org.dimdev.dimdoors.rift.targets.VirtualTarget;
import org.dimdev.dimdoors.world.ModDimensions;

public class EscapeTarget
extends VirtualTarget
implements EntityTarget {
    private static final Logger LOGGER = LogManager.getLogger();
    private static ResourceKey<Level> targetWorldResourceKey;
    public static final Codec<EscapeTarget> CODEC;
    protected final boolean canEscapeLimbo;

    public EscapeTarget(boolean canEscapeLimbo) {
        this.canEscapeLimbo = canEscapeLimbo;
    }

    @Override
    public boolean receiveEntity(Entity entity, Vec3 relativePos, Rotations relativeAngle, Vec3 relativeVelocity, Location location2) {
        if (!ModDimensions.isPocketDimension(entity.m_9236_()) && !ModDimensions.isLimboDimension(entity.m_9236_())) {
            return false;
        }
        if (ModDimensions.isLimboDimension(entity.m_9236_()) && !this.canEscapeLimbo) {
            return false;
        }
        if (entity.m_9236_().f_46443_) {
            return false;
        }
        UUID uuid = entity.m_20148_();
        if (uuid != null) {
            Location destLoc;
            if (entity.m_9236_().m_46003_(uuid) == null) {
                LOGGER.log(org.apache.logging.log4j.Level.ERROR, "Tried to get player for escape target from uuid, but player does not exist, uh oh");
                return false;
            }
            if (((ServerPlayer)entity.m_9236_().m_46003_(uuid)).m_8961_() != null && DimensionalDoors.getConfig().getLimboConfig().escapeTargetWorld == null && !DimensionalDoors.getConfig().getLimboConfig().escapeToWorldSpawn) {
                LOGGER.log(org.apache.logging.log4j.Level.INFO, "Sending player from limbo to their spawnpoint, good luck!");
                destLoc = new Location((ResourceKey<Level>)((ServerPlayer)entity.m_9236_().m_46003_(uuid)).m_8963_(), ((ServerPlayer)entity.m_9236_().m_46003_(uuid)).m_8961_());
            } else if (DimensionalDoors.getConfig().getLimboConfig().escapeTargetWorld != null && !DimensionalDoors.getConfig().getLimboConfig().escapeToWorldSpawn) {
                targetWorldResourceKey = DimensionalDoors.getConfig().getLimboConfig().escapeTargetWorld;
                if (DimensionalDoors.getWorld(targetWorldResourceKey) != null) {
                    LOGGER.log(org.apache.logging.log4j.Level.INFO, "Sending player from limbo to the exit dimension, good luck!");
                    destLoc = new Location(DimensionalDoors.getWorld(targetWorldResourceKey), new BlockPos(entity.m_20183_().m_123341_(), DimensionalDoors.getConfig().getLimboConfig().escapeTargetWorldYSpawn, entity.m_20183_().m_123343_()));
                } else {
                    LOGGER.log(org.apache.logging.log4j.Level.INFO, "Target dimension defined in config does not exist.  Use /forge dimensions for a list!");
                    LOGGER.log(org.apache.logging.log4j.Level.INFO, "Sending player from limbo to worldspawn, good luck!");
                    destLoc = new Location(DimensionalDoors.getServer().m_129783_(), DimensionalDoors.getServer().m_129783_().m_220360_());
                }
            } else {
                LOGGER.log(org.apache.logging.log4j.Level.INFO, "sending player from limbo to worldspawn, good luck!");
                destLoc = new Location(DimensionalDoors.getServer().m_129783_(), DimensionalDoors.getServer().m_129783_().m_220360_());
            }
            destLoc = EscapeTarget.randomizeLimboReturn(destLoc, DimensionalDoors.getConfig().getLimboConfig().limboReturnDistance);
            if (destLoc != null && this.canEscapeLimbo) {
                Location location = destLoc;
                entity = TeleportUtil.teleport(entity, (Level)location.getWorld(), location.getBlockPos(), relativeAngle, relativeVelocity);
                entity.f_19789_ = -500.0f;
                location.getWorld().m_46597_(location.getBlockPos(), Blocks.f_50016_.m_49966_());
                location.getWorld().m_46597_(location.getBlockPos().m_7918_(0, 1, 0), Blocks.f_50016_.m_49966_());
                RandomSource random = RandomSource.m_216327_();
                BlockPos.m_121925_((BlockPos)location.pos.m_7918_(0, -3, 0), (int)3, (int)2, (int)3).forEach(pos1 -> {
                    if (random.m_188501_() < 1.0f / (float)location.pos.m_123331_((Vec3i)pos1) * DimensionalDoors.getConfig().getLimboConfig().limboBlocksCorruptingExitWorldAmount) {
                        Block block = location.getWorld().m_8055_(pos1).m_60734_();
                        if (UnravelUtil.unravelBlocksMap.containsKey(block)) {
                            location.getWorld().m_46597_(pos1, UnravelUtil.unravelBlocksMap.get(block).m_49966_());
                        } else if (UnravelUtil.whitelistedBlocksForLimboRemoval.contains(block)) {
                            location.getWorld().m_46597_(pos1, ((Block)ModBlocks.UNRAVELLED_FABRIC.get()).m_49966_());
                        }
                    }
                });
            } else {
                if (destLoc == null) {
                    EntityUtils.chat(entity, (Component)Component.m_237115_((String)"rifts.destinations.escape.did_not_use_rift"));
                } else {
                    EntityUtils.chat(entity, (Component)Component.m_237115_((String)"rifts.destinations.escape.rift_has_closed"));
                }
                if (ModDimensions.LIMBO_DIMENSION != null) {
                    entity = TeleportUtil.teleport(entity, (Level)ModDimensions.LIMBO_DIMENSION, new BlockPos(this.location.getX(), this.location.getY(), this.location.getZ()), relativeAngle, relativeVelocity);
                    entity.f_19789_ = -500.0f;
                }
            }
            return true;
        }
        return false;
    }

    public VirtualTarget.VirtualTargetType getType() {
        return (VirtualTarget.VirtualTargetType)VirtualTarget.VirtualTargetType.ESCAPE.get();
    }

    @Override
    public VirtualTarget copy() {
        return new EscapeTarget(this.canEscapeLimbo);
    }

    public static Location randomizeLimboReturn(Location playerSpawn, int range) {
        return new Location(playerSpawn.getWorld(), EscapeTarget.randomizeCoord(playerSpawn.getX(), range), playerSpawn.getY(), EscapeTarget.randomizeCoord(playerSpawn.getZ(), range));
    }

    public static int randomizeCoord(int coord, int range) {
        Random random = new Random();
        int offset = random.nextInt(range + 1);
        boolean isPositive = random.nextBoolean();
        return isPositive ? coord + offset : coord - offset;
    }

    static {
        CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("canEscapeLimbo").forGetter(target -> target.canEscapeLimbo)).apply((Applicative)instance, EscapeTarget::new));
    }
}

