/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.rift.registry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class LinkProperties {
    public static final LinkProperties NONE = LinkProperties.builder().build();
    public float floatingWeight;
    private final float entranceWeight;
    private final Set<Integer> groups;
    private final int linksRemaining;
    private final boolean oneWay;

    public LinkProperties(float floatingWeight, float entranceWeight, Set<Integer> groups, int linksRemaining, boolean oneWay) {
        this.floatingWeight = floatingWeight;
        this.entranceWeight = entranceWeight;
        this.groups = groups;
        this.linksRemaining = linksRemaining;
        this.oneWay = oneWay;
    }

    public static LinkPropertiesBuilder builder() {
        return new LinkPropertiesBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LinkProperties)) {
            return false;
        }
        LinkProperties other = (LinkProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.floatingWeight, other.floatingWeight) != 0) {
            return false;
        }
        if (Float.compare(this.entranceWeight, other.entranceWeight) != 0) {
            return false;
        }
        if (!Objects.equals(this.groups, other.groups)) {
            return false;
        }
        if (this.linksRemaining != other.linksRemaining) {
            return false;
        }
        return this.oneWay == other.oneWay;
    }

    protected boolean canEqual(Object other) {
        return other instanceof LinkProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.floatingWeight);
        result = result * 59 + Float.floatToIntBits(this.entranceWeight);
        Set<Integer> $groups = this.groups;
        result = result * 59 + ($groups == null ? 43 : ((Object)$groups).hashCode());
        result = result * 59 + this.linksRemaining;
        result = result * 59 + (this.oneWay ? 79 : 97);
        return result;
    }

    public String toString() {
        return "LinkProperties(floatingWeight=" + this.floatingWeight + ", entranceWeight=" + this.entranceWeight + ", groups=" + String.valueOf(this.groups) + ", linksRemaining=" + this.linksRemaining + ", oneWay=" + this.oneWay + ")";
    }

    public LinkPropertiesBuilder toBuilder() {
        return new LinkPropertiesBuilder().floatingWeight(this.floatingWeight).entranceWeight(this.entranceWeight).groups(this.groups).linksRemaining(this.linksRemaining).oneWay(this.oneWay);
    }

    public static CompoundTag toNbt(LinkProperties properties) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128350_("floatingWeight", properties.floatingWeight);
        nbt.m_128350_("entranceWeight", properties.entranceWeight);
        nbt.m_128408_("groups", new ArrayList<Integer>(properties.groups));
        nbt.m_128405_("linksRemaining", properties.linksRemaining);
        nbt.m_128379_("oneWay", properties.oneWay);
        return nbt;
    }

    public static LinkProperties fromNbt(CompoundTag nbt) {
        return LinkProperties.builder().floatingWeight(nbt.m_128457_("floatingWeight")).entranceWeight(nbt.m_128457_("entranceWeight")).groups(Arrays.stream(nbt.m_128465_("groups")).boxed().collect(Collectors.toSet())).linksRemaining(nbt.m_128451_("linksRemaining")).oneWay(nbt.m_128471_("oneWay")).build();
    }

    public float getEntranceWeight() {
        return this.entranceWeight;
    }

    public Set<Integer> getGroups() {
        return this.groups;
    }

    public int getLinksRemaining() {
        return this.linksRemaining;
    }

    public LinkProperties withLinksRemaining(int linksRemaining) {
        return this.toBuilder().linksRemaining(linksRemaining).build();
    }

    public boolean isOneWay() {
        return this.oneWay;
    }

    public static class LinkPropertiesBuilder {
        private float floatingWeight;
        private float entranceWeight;
        private Set<Integer> groups = Collections.emptySet();
        private int linksRemaining;
        private boolean oneWay;

        LinkPropertiesBuilder() {
        }

        public LinkPropertiesBuilder floatingWeight(float floatingWeight) {
            this.floatingWeight = floatingWeight;
            return this;
        }

        public LinkPropertiesBuilder entranceWeight(float entranceWeight) {
            this.entranceWeight = entranceWeight;
            return this;
        }

        public LinkPropertiesBuilder groups(Set<Integer> groups) {
            this.groups = groups;
            return this;
        }

        public LinkPropertiesBuilder linksRemaining(int linksRemaining) {
            this.linksRemaining = linksRemaining;
            return this;
        }

        public LinkPropertiesBuilder oneWay(boolean oneWay) {
            this.oneWay = oneWay;
            return this;
        }

        public LinkProperties build() {
            return new LinkProperties(this.floatingWeight, this.entranceWeight, this.groups, this.linksRemaining, this.oneWay);
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("floatingWeight", this.floatingWeight).append("entranceWeight", this.entranceWeight).append("groups", this.groups).append("linksRemaining", this.linksRemaining).append("oneWay", this.oneWay).toString();
        }
    }
}

