/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.block.entity;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.dimdev.dimdoors.block.entity.ModBlockEntityTypes;
import org.dimdev.dimdoors.recipe.ModRecipeTypes;
import org.dimdev.dimdoors.recipe.TesselatingRecipe;
import org.dimdev.dimdoors.screen.TessellatingContainer;
import org.jetbrains.annotations.Nullable;

public class TesselatingLoomBlockEntity
extends BlockEntity
implements MenuProvider,
WorldlyContainer,
RecipeHolder,
StackedContentsCompatible {
    public static final int DATA_WEAVING_TIME = 0;
    public static final int DATA_WEAVING_TIME_TOTAL = 1;
    public static final int NUM_DATA_VALUES = 2;
    private static final int[] OUTPUT_SLOTS = new int[]{9};
    private static final int[] INPUT_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private static final int[] SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    private static final int DEFAULT_WEAVE_TIME = 200;
    private static final String INVENTORY_TAG = "Inventory";
    private static final String WEAVE_TIME_TAG = "WeaveTime";
    private static final String WEAVE_TIME_TOTAL_TAG = "WeaveTimeTotal";
    public int weaveTime;
    public int weaveTimeTotal;
    public final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> TesselatingLoomBlockEntity.this.weaveTime;
                case 1 -> TesselatingLoomBlockEntity.this.weaveTimeTotal;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    TesselatingLoomBlockEntity.this.weaveTime = value;
                    break;
                }
                case 1: {
                    TesselatingLoomBlockEntity.this.weaveTimeTotal = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    public NonNullList<ItemStack> inventory;
    public ItemStack output = ItemStack.f_41583_;
    private TesselatingRecipe cachedRecipe;
    private final List<TessellatingContainer> openContainers = new ArrayList<TessellatingContainer>();
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();

    public TesselatingLoomBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.TESSELATING_LOOM.get(), pos, state);
        this.inventory = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        CompoundTag inventoryTag = new CompoundTag();
        ContainerHelper.m_18973_((CompoundTag)inventoryTag, this.inventory);
        inventoryTag.m_128365_("Output", (Tag)this.output.m_41739_(new CompoundTag()));
        nbt.m_128365_(INVENTORY_TAG, (Tag)inventoryTag);
        nbt.m_128405_(WEAVE_TIME_TAG, this.weaveTime);
        nbt.m_128405_(WEAVE_TIME_TOTAL_TAG, this.weaveTimeTotal);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        CompoundTag inventoryTag = nbt.m_128469_(INVENTORY_TAG);
        ContainerHelper.m_18973_((CompoundTag)inventoryTag, this.inventory);
        this.output = ItemStack.m_41712_((CompoundTag)inventoryTag.m_128469_("Output"));
        this.weaveTime = nbt.m_128451_(WEAVE_TIME_TAG);
        this.weaveTimeTotal = nbt.m_128451_(WEAVE_TIME_TOTAL_TAG);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    @Nullable
    public TessellatingContainer createMenu(int syncId, Inventory inv, Player player) {
        return this.createMenu(syncId, inv);
    }

    public TessellatingContainer createMenu(int syncId, Inventory inv) {
        return new TessellatingContainer(syncId, this, inv, this.dataAccess);
    }

    public int[] m_7071_(Direction dir) {
        return SLOTS;
    }

    public boolean m_7155_(int slot, ItemStack stack, Direction dir) {
        return slot != 9;
    }

    public boolean m_7157_(int slot, ItemStack stack, Direction dir) {
        return slot == 9;
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        return slot != 9;
    }

    public boolean m_7983_() {
        for (ItemStack stack : this.inventory) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return this.output.m_41619_();
    }

    public int m_6643_() {
        return 10;
    }

    public ItemStack m_8020_(int slot) {
        if (slot < 9) {
            return (ItemStack)this.inventory.get(slot);
        }
        if (!this.output.m_41619_()) {
            return this.output;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack m_7407_(int slot, int amount) {
        if (slot == 9) {
            return this.output.m_41620_(amount);
        }
        return ContainerHelper.m_18969_(this.inventory, (int)slot, (int)amount);
    }

    public ItemStack m_8016_(int slot) {
        if (slot == 9) {
            ItemStack output = this.output;
            this.output = ItemStack.f_41583_;
            return output;
        }
        return ContainerHelper.m_18966_(this.inventory, (int)slot);
    }

    public void m_6836_(int slot, ItemStack stack) {
        if (slot == 9) {
            this.output = stack;
            return;
        }
        this.inventory.set(slot, (Object)stack);
        this.m_6596_();
    }

    public void m_6596_() {
        super.m_6596_();
        for (TessellatingContainer c : this.openContainers) {
            c.m_6199_((Container)this);
        }
    }

    public boolean m_6542_(Player player) {
        return player.m_20097_().m_123331_((Vec3i)this.f_58858_) <= 64.0;
    }

    public void m_5809_(StackedContents finder) {
        for (ItemStack stack : this.inventory) {
            finder.m_36491_(stack);
        }
    }

    public void m_6029_(Recipe<?> recipe) {
        if (recipe instanceof TesselatingRecipe) {
            TesselatingRecipe tesselatingRecipe;
            this.cachedRecipe = tesselatingRecipe = (TesselatingRecipe)recipe;
        }
    }

    public Recipe<?> m_7928_() {
        return this.cachedRecipe;
    }

    public void m_6211_() {
        this.inventory.clear();
    }

    private Optional<? extends TesselatingRecipe> getCurrentRecipe() {
        TesselatingRecipe mapRecipe;
        if (this.f_58857_ == null || this.m_7983_()) {
            return Optional.empty();
        }
        if (this.cachedRecipe != null && (mapRecipe = this.getRecipe(this.cachedRecipe.m_6423_())) != null && mapRecipe.matches(this, this.f_58857_)) {
            return Optional.of(this.cachedRecipe);
        }
        return this.getRecipe();
    }

    public <T extends TesselatingRecipe> TesselatingRecipe getRecipe(ResourceLocation location) {
        RecipeManager manager = this.f_58857_.m_7465_();
        TesselatingRecipe recipe = (TesselatingRecipe)manager.m_44054_((RecipeType)ModRecipeTypes.SHAPED_TESSELATING.get()).get(location);
        if (recipe == null) {
            recipe = (TesselatingRecipe)manager.m_44054_((RecipeType)ModRecipeTypes.SHAPELESS_TESSELATING.get()).get(location);
        }
        return recipe;
    }

    public Optional<? extends TesselatingRecipe> getRecipe() {
        RecipeManager manager = this.f_58857_.m_7465_();
        Optional recipe = manager.m_44015_((RecipeType)ModRecipeTypes.SHAPED_TESSELATING.get(), (Container)this, this.f_58857_);
        return recipe.isEmpty() ? manager.m_44015_((RecipeType)ModRecipeTypes.SHAPELESS_TESSELATING.get(), (Container)this, this.f_58857_) : recipe;
    }

    private int getWeavingTotalTime() {
        return this.getCurrentRecipe().map(TesselatingRecipe::weavingTime).orElse(200);
    }

    public void serverTick() {
        TesselatingRecipe recipe = this.getRecipe().orElse(null);
        if (this.cachedRecipe == null || this.cachedRecipe != recipe) {
            this.cachedRecipe = recipe;
            this.weaveTimeTotal = this.getWeavingTotalTime();
        }
        if (this.cachedRecipe != null) {
            this.tryWeave();
        } else {
            this.tryDecrementCookTime();
        }
    }

    public void tryDecrementCookTime() {
        if (this.weaveTime > 0) {
            this.weaveTime = Mth.m_14045_((int)(this.weaveTime - 2), (int)0, (int)this.weaveTimeTotal);
            this.m_6596_();
        }
    }

    private void tryWeave() {
        ItemStack output = this.cachedRecipe.m_5874_((Container)this, this.f_58857_.m_9598_());
        if (this.canAcceptOutput(output)) {
            ++this.weaveTime;
            if (this.weaveTime >= this.weaveTimeTotal) {
                this.weaveTime = 0;
                this.cachedRecipe = null;
                this.takeInputs();
                this.insertOutput(output);
            }
            this.m_6596_();
        } else {
            this.tryDecrementCookTime();
        }
    }

    private void insertOutput(ItemStack output) {
        if (output.m_41619_()) {
            return;
        }
        if (output.m_41753_()) {
            for (int slot : OUTPUT_SLOTS) {
                ItemStack existing = this.m_8020_(slot);
                if (!existing.m_41619_() && ItemStack.m_150942_((ItemStack)output, (ItemStack)existing)) {
                    int total = existing.m_41613_() + output.m_41613_();
                    if (total <= existing.m_41741_()) {
                        output.m_41764_(0);
                        existing.m_41764_(total);
                    } else if (existing.m_41613_() < existing.m_41741_()) {
                        output.m_41774_(existing.m_41741_() - existing.m_41613_());
                        existing.m_41764_(existing.m_41741_());
                    }
                }
                if (!output.m_41619_()) continue;
                return;
            }
        }
        for (int slot : OUTPUT_SLOTS) {
            if (!this.m_8020_(slot).m_41619_()) continue;
            this.m_6836_(slot, output.m_41620_(output.m_41613_()));
        }
    }

    private void takeInputs() {
        for (int slot : INPUT_SLOTS) {
            ItemStack stack = this.m_8020_(slot);
            Item item = stack.m_41720_();
            stack.m_41774_(1);
            if (!stack.m_41619_()) continue;
            ItemStack newStack = item.m_41469_() != null ? new ItemStack((ItemLike)item.m_41469_()) : ItemStack.f_41583_;
            this.m_6836_(slot, newStack);
        }
        this.m_6596_();
    }

    private boolean canAcceptOutput(ItemStack output) {
        int remianingOutput = output.m_41613_();
        for (int slot : OUTPUT_SLOTS) {
            ItemStack existing = this.m_8020_(slot);
            if (existing.m_41619_()) {
                return true;
            }
            if (output.m_41753_() && ItemStack.m_150942_((ItemStack)existing, (ItemStack)output)) {
                if (existing.m_41613_() + remianingOutput <= existing.m_41741_()) {
                    return true;
                }
                if (existing.m_41613_() < existing.m_41741_()) {
                    remianingOutput -= existing.m_41741_() - existing.m_41613_();
                }
            }
            if (remianingOutput != 0) continue;
            return true;
        }
        return false;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public void awardUsedRecipesAndPopExperience(ServerPlayer player) {
        List<Recipe<?>> list = this.getRecipesToAwardAndPopExperience(player.m_284548_(), player.m_20182_());
        player.m_7281_(list);
        this.recipesUsed.clear();
    }

    public List<Recipe<?>> getRecipesToAwardAndPopExperience(ServerLevel level, Vec3 popVec) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            level.m_7465_().m_44043_((ResourceLocation)entry.getKey()).ifPresent(recipe -> {
                list.add(recipe);
                TesselatingLoomBlockEntity.createExperience(level, popVec, entry.getIntValue(), ((AbstractCookingRecipe)recipe).m_43750_());
            });
        }
        return list;
    }

    private static void createExperience(ServerLevel level, Vec3 popVec, int recipeIndex, float experience) {
        int i = Mth.m_14143_((float)((float)recipeIndex * experience));
        float f = Mth.m_14187_((float)((float)recipeIndex * experience));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        ExperienceOrb.m_147082_((ServerLevel)level, (Vec3)popVec, (int)i);
    }
}

