/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.api.util.math;

import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.core.Rotations;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.dimdev.dimdoors.api.util.math.TransformationMatrix3d;

public final class MathUtil {
    public static <T> T weightedRandom(Map<T, Float> weights) {
        if (weights.size() == 0) {
            return null;
        }
        int totalWeight = 0;
        for (float weight : weights.values()) {
            totalWeight = (int)((float)totalWeight + weight);
        }
        RandomSource random = RandomSource.m_216327_();
        float f = random.m_188501_() * (float)totalWeight;
        for (Map.Entry<T, Float> e : weights.entrySet()) {
            if (!((f -= e.getValue().floatValue()) < 0.0f)) continue;
            return e.getKey();
        }
        return null;
    }

    public static Rotations eulerAngle(Vec3 direction, Vec3 upwards) {
        float pitch = MathUtil.pitch(direction);
        float yaw = MathUtil.yaw(direction);
        upwards = ((TransformationMatrix3d)TransformationMatrix3d.builder().rotate(new Rotations(pitch, yaw, 0.0f)).buildReverse()).transform(upwards);
        float roll = (float)Math.toDegrees(-Math.atan2(upwards.f_82479_, upwards.f_82480_));
        return new Rotations(pitch, yaw, roll);
    }

    public static Rotations entityEulerAngle(Entity entity) {
        return new Rotations(entity.m_146909_(), entity.m_146908_(), 0.0f);
    }

    public static float yaw(Vec3 vector) {
        return (float)Math.toDegrees(-Math.atan2(vector.f_82479_, vector.f_82481_));
    }

    public static float pitch(Vec3 vector) {
        return (float)Math.toDegrees(Math.asin(-vector.f_82480_));
    }

    public static Rotations directionEulerAngle(Direction direction) {
        switch (direction) {
            case DOWN: {
                return EulerAngleDirection.DOWN.getAngle();
            }
            case UP: {
                return EulerAngleDirection.UP.getAngle();
            }
            case NORTH: {
                return EulerAngleDirection.NORTH.getAngle();
            }
            case SOUTH: {
                return EulerAngleDirection.SOUTH.getAngle();
            }
            case WEST: {
                return EulerAngleDirection.WEST.getAngle();
            }
        }
        return EulerAngleDirection.EAST.getAngle();
    }

    public static enum EulerAngleDirection {
        DOWN(new Rotations(90.0f, 0.0f, 0.0f)),
        UP(new Rotations(-90.0f, 0.0f, 0.0f)),
        NORTH(new Rotations(0.0f, -180.0f, 0.0f)),
        SOUTH(new Rotations(0.0f, 0.0f, 0.0f)),
        WEST(new Rotations(0.0f, 90.0f, 0.0f)),
        EAST(new Rotations(0.0f, -90.0f, 0.0f));

        private final Rotations angle;

        private EulerAngleDirection(Rotations angle) {
            this.angle = angle;
        }

        public Rotations getAngle() {
            return this.angle;
        }
    }
}

