/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.util;

import java.util.LinkedList;
import java.util.List;
import java.util.function.BooleanSupplier;

public final class CycleTaskHelper {
    private static final List<CycleTaskTicker> CYCLE_TASKS = new LinkedList<CycleTaskTicker>();

    public static void addCycleTask(BooleanSupplier task, long periodMs, int cycles) {
        CycleTaskTicker ticker = new CycleTaskTicker(task, periodMs, cycles);
        if (ticker.tick()) {
            CYCLE_TASKS.add(ticker);
        }
    }

    public static void tick() {
        CYCLE_TASKS.removeIf(ticker -> !ticker.tick());
    }

    private static class CycleTaskTicker {
        private final BooleanSupplier task;
        private final float periodS;
        private final int cycles;
        private long timestamp = -1L;
        private float compensation = 0.0f;
        private int count = 0;

        private CycleTaskTicker(BooleanSupplier task, long periodMs, int cycles) {
            this.task = task;
            this.periodS = (float)periodMs / 1000.0f;
            this.cycles = cycles;
        }

        private boolean tick() {
            if (this.timestamp == -1L) {
                this.timestamp = System.currentTimeMillis();
                if (++this.count > this.cycles) {
                    return false;
                }
                return this.task.getAsBoolean();
            }
            float duration = (float)(System.currentTimeMillis() - this.timestamp) / 1000.0f + this.compensation;
            if (duration > this.periodS) {
                this.compensation = duration;
                this.timestamp = System.currentTimeMillis();
                while (this.compensation > this.periodS) {
                    if (++this.count > this.cycles) {
                        return false;
                    }
                    if (!this.task.getAsBoolean()) {
                        return false;
                    }
                    this.compensation -= this.periodS;
                }
            }
            return true;
        }
    }
}

