/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource.modifier.custom;

import com.google.gson.annotations.SerializedName;
import com.tacz.guns.api.modifier.CacheValue;
import com.tacz.guns.api.modifier.IAttachmentModifier;
import com.tacz.guns.api.modifier.JsonProperty;
import com.tacz.guns.resource.CommonGunPackLoader;
import com.tacz.guns.resource.modifier.AttachmentCacheProperty;
import com.tacz.guns.resource.modifier.AttachmentPropertyManager;
import com.tacz.guns.resource.pojo.data.attachment.Modifier;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WeightModifier
implements IAttachmentModifier<Modifier, Float> {
    public static final String ID = "weight_modifier";

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public JsonProperty<Modifier> readJson(String json) {
        Data data = (Data)CommonGunPackLoader.GSON.fromJson(json, Data.class);
        Modifier weightModifier = data.getWeightModifier();
        if (weightModifier == null) {
            weightModifier = new Modifier();
            weightModifier.setAddend(data.getWeightAddend());
        }
        return new WeightJsonProperty(weightModifier);
    }

    @Override
    public CacheValue<Float> initCache(ItemStack gunItem, GunData gunData) {
        return new CacheValue<Float>(Float.valueOf(gunData.getWeight()));
    }

    @Override
    public void eval(List<Modifier> modifiers, CacheValue<Float> cache) {
        double eval = AttachmentPropertyManager.eval(modifiers, (double)cache.getValue().floatValue());
        cache.setValue(Float.valueOf((float)eval));
    }

    @Override
    public String getOptionalFields() {
        return "weight";
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<IAttachmentModifier.DiagramsData> getPropertyDiagramsData(ItemStack gunItem, GunData gunData, AttachmentCacheProperty cacheProperty) {
        float weight = gunData.getWeight();
        float modified = ((Float)cacheProperty.getCache(ID)).floatValue() - weight;
        double percent = Math.min((double)weight / 20.0, 1.0);
        double modifierPercent = Math.min((double)modified / 20.0, 1.0);
        String titleKey = "gui.tacz.gun_refit.property_diagrams.weight";
        String positivelyString = String.format("%.2fkg \u00a7c(+%.2f)", Float.valueOf(weight), Float.valueOf(modified));
        String negativelyString = String.format("%.2fkg \u00a7a(%.2f)", Float.valueOf(weight), Float.valueOf(modified));
        String defaultString = String.format("%.2fkg", Float.valueOf(weight));
        boolean positivelyBetter = false;
        IAttachmentModifier.DiagramsData diagramsData = new IAttachmentModifier.DiagramsData(percent, modifierPercent, Float.valueOf(modified), titleKey, positivelyString, negativelyString, defaultString, positivelyBetter);
        return Collections.singletonList(diagramsData);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getDiagramsDataSize() {
        return 1;
    }

    public static class Data {
        @Nullable
        @SerializedName(value="weight_modifier")
        private Modifier weightModifier;
        @SerializedName(value="weight")
        @Deprecated
        private float weightAddend = 0.0f;

        @Nullable
        public Modifier getWeightModifier() {
            return this.weightModifier;
        }

        @Deprecated
        public float getWeightAddend() {
            return this.weightAddend;
        }
    }

    public static class WeightJsonProperty
    extends JsonProperty<Modifier> {
        public WeightJsonProperty(Modifier value) {
            super(value);
        }

        @Override
        public void initComponents() {
            Modifier value = (Modifier)this.getValue();
            float adsAddendTime = 0.0f;
            if (value != null) {
                double eval = AttachmentPropertyManager.eval(value, 0.2);
                adsAddendTime = (float)(eval - 0.2);
            }
            if (adsAddendTime > 0.0f) {
                this.components.add(Component.m_237115_((String)"tooltip.tacz.attachment.weight.increase").m_130940_(ChatFormatting.RED));
            } else if (adsAddendTime < 0.0f) {
                this.components.add(Component.m_237115_((String)"tooltip.tacz.attachment.weight.decrease").m_130940_(ChatFormatting.GREEN));
            }
        }
    }
}

