/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource.index;

import com.google.common.base.Preconditions;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.resource.CommonAssetManager;
import com.tacz.guns.resource.pojo.AttachmentIndexPOJO;
import com.tacz.guns.resource.pojo.data.attachment.AttachmentData;
import net.minecraft.resources.ResourceLocation;

public class CommonAttachmentIndex {
    private AttachmentData data;
    private AttachmentType type;
    private AttachmentIndexPOJO pojo;

    private CommonAttachmentIndex() {
    }

    public static CommonAttachmentIndex getInstance(ResourceLocation id, AttachmentIndexPOJO attachmentIndexPOJO) throws IllegalArgumentException {
        CommonAttachmentIndex index = new CommonAttachmentIndex();
        index.pojo = attachmentIndexPOJO;
        CommonAttachmentIndex.checkIndex(attachmentIndexPOJO, index);
        CommonAttachmentIndex.checkData(id, attachmentIndexPOJO, index);
        return index;
    }

    private static void checkIndex(AttachmentIndexPOJO attachmentIndexPOJO, CommonAttachmentIndex index) {
        Preconditions.checkArgument((attachmentIndexPOJO != null ? 1 : 0) != 0, (Object)"index object file is empty");
        Preconditions.checkArgument((attachmentIndexPOJO.getType() != null ? 1 : 0) != 0, (Object)"attachment type must be nonnull.");
        index.type = attachmentIndexPOJO.getType();
    }

    private static void checkData(ResourceLocation id, AttachmentIndexPOJO attachmentIndexPOJO, CommonAttachmentIndex index) {
        ResourceLocation pojoData = attachmentIndexPOJO.getData();
        Preconditions.checkArgument((pojoData != null ? 1 : 0) != 0, (Object)"index object missing pojoData field");
        AttachmentData data = CommonAssetManager.INSTANCE.getAttachmentData(pojoData);
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"there is no corresponding data file");
        index.data = data;
    }

    public AttachmentData getData() {
        return this.data;
    }

    public AttachmentType getType() {
        return this.type;
    }

    public AttachmentIndexPOJO getPojo() {
        return this.pojo;
    }
}

