/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource.index;

import com.google.common.base.Preconditions;
import com.tacz.guns.resource.pojo.AmmoIndexPOJO;

public class CommonAmmoIndex {
    private int stackSize;
    private AmmoIndexPOJO pojo;

    private CommonAmmoIndex() {
    }

    public static CommonAmmoIndex getInstance(AmmoIndexPOJO ammoIndexPOJO) throws IllegalArgumentException {
        CommonAmmoIndex index = new CommonAmmoIndex();
        index.pojo = ammoIndexPOJO;
        CommonAmmoIndex.checkIndex(ammoIndexPOJO, index);
        return index;
    }

    private static void checkIndex(AmmoIndexPOJO ammoIndexPOJO, CommonAmmoIndex index) {
        Preconditions.checkArgument((ammoIndexPOJO != null ? 1 : 0) != 0, (Object)"index object file is empty");
        index.stackSize = Math.max(ammoIndexPOJO.getStackSize(), 1);
    }

    public int getStackSize() {
        return this.stackSize;
    }

    public AmmoIndexPOJO getPojo() {
        return this.pojo;
    }
}

