/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.entity.shooter;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.event.common.GunDrawEvent;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.entity.shooter.ShooterDataHolder;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.message.event.ServerMessageGunDraw;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.modifier.AttachmentPropertyManager;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;

public class LivingEntityDrawGun {
    private final LivingEntity shooter;
    private final ShooterDataHolder data;

    public LivingEntityDrawGun(LivingEntity shooter, ShooterDataHolder data) {
        this.shooter = shooter;
        this.data = data;
    }

    public void draw(Supplier<ItemStack> gunItemSupplier) {
        long drawTime;
        this.data.initialData();
        if (this.data.drawTimestamp == -1L) {
            this.data.drawTimestamp = System.currentTimeMillis();
        }
        if ((drawTime = System.currentTimeMillis() - this.data.drawTimestamp) >= 0L) {
            this.data.drawTimestamp = (float)drawTime < this.data.currentPutAwayTimeS * 1000.0f ? System.currentTimeMillis() + drawTime : System.currentTimeMillis() + (long)(this.data.currentPutAwayTimeS * 1000.0f);
        }
        ItemStack lastItem = this.data.currentGunItem == null ? ItemStack.f_41583_ : this.data.currentGunItem.get();
        MinecraftForge.EVENT_BUS.post((Event)new GunDrawEvent(this.shooter, lastItem, gunItemSupplier.get(), LogicalSide.SERVER));
        NetworkHandler.sendToTrackingEntity(new ServerMessageGunDraw(this.shooter.m_19879_(), lastItem, gunItemSupplier.get()), (Entity)this.shooter);
        this.data.currentGunItem = gunItemSupplier;
        AttachmentPropertyManager.postChangeEvent(this.shooter, gunItemSupplier.get());
        this.updatePutAwayTime();
    }

    public long getDrawCoolDown() {
        if (this.data.currentGunItem == null) {
            return 0L;
        }
        ItemStack currentGunItem = this.data.currentGunItem.get();
        Item item = currentGunItem.m_41720_();
        if (!(item instanceof IGun)) {
            return 0L;
        }
        IGun iGun = (IGun)item;
        ResourceLocation gunId = iGun.getGunId(currentGunItem);
        Optional<CommonGunIndex> gunIndex = TimelessAPI.getCommonGunIndex(gunId);
        return gunIndex.map(index -> {
            long coolDown = (long)(index.getGunData().getDrawTime() * 1000.0f) - (System.currentTimeMillis() - this.data.drawTimestamp);
            if ((coolDown -= 5L) < 0L) {
                return 0L;
            }
            return coolDown;
        }).orElse(-1L);
    }

    private void updatePutAwayTime() {
        ItemStack gunItem = this.data.currentGunItem == null ? ItemStack.f_41583_ : this.data.currentGunItem.get();
        IGun iGun = IGun.getIGunOrNull(gunItem);
        if (iGun != null) {
            Optional<CommonGunIndex> gunIndex = TimelessAPI.getCommonGunIndex(iGun.getGunId(gunItem));
            this.data.currentPutAwayTimeS = gunIndex.map(index -> Float.valueOf(index.getGunData().getPutAwayTime())).orElse(Float.valueOf(0.0f)).floatValue();
        } else {
            this.data.currentPutAwayTimeS = 0.0f;
        }
    }
}

