/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.entity.shooter;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.gun.AbstractGunItem;
import com.tacz.guns.entity.shooter.LivingEntityDrawGun;
import com.tacz.guns.entity.shooter.LivingEntityShoot;
import com.tacz.guns.entity.shooter.ShooterDataHolder;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.pojo.data.gun.Bolt;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class LivingEntityBolt {
    private final ShooterDataHolder data;
    private final LivingEntityDrawGun draw;
    private final LivingEntityShoot shoot;

    public LivingEntityBolt(ShooterDataHolder data, LivingEntityDrawGun draw, LivingEntityShoot shoot) {
        this.data = data;
        this.draw = draw;
        this.shoot = shoot;
    }

    public void bolt() {
        if (this.data.currentGunItem == null) {
            return;
        }
        ItemStack currentGunItem = this.data.currentGunItem.get();
        Item item = currentGunItem.m_41720_();
        if (!(item instanceof IGun)) {
            return;
        }
        IGun iGun = (IGun)item;
        ResourceLocation gunId = iGun.getGunId(currentGunItem);
        TimelessAPI.getCommonGunIndex(gunId).ifPresent(gunIndex -> {
            if (this.shoot.getShootCoolDown() != 0L) {
                return;
            }
            if (this.data.reloadStateType.isReloading()) {
                return;
            }
            if (this.draw.getDrawCoolDown() != 0L) {
                return;
            }
            if (this.data.boltCoolDown >= 0L) {
                return;
            }
            Bolt boltType = gunIndex.getGunData().getBolt();
            if (boltType != Bolt.MANUAL_ACTION) {
                return;
            }
            if (iGun.hasBulletInBarrel(currentGunItem)) {
                return;
            }
            if (iGun.getCurrentAmmoCount(currentGunItem) == 0) {
                return;
            }
            this.data.boltTimestamp = System.currentTimeMillis();
            this.data.boltCoolDown = 0L;
        });
    }

    public void tickBolt() {
        if (this.data.boltCoolDown == -1L) {
            return;
        }
        if (this.data.currentGunItem == null) {
            this.data.boltCoolDown = -1L;
            return;
        }
        ItemStack currentGunItem = this.data.currentGunItem.get();
        Item item = currentGunItem.m_41720_();
        if (!(item instanceof IGun)) {
            this.data.boltCoolDown = -1L;
            return;
        }
        IGun iGun = (IGun)item;
        ResourceLocation gunId = iGun.getGunId(currentGunItem);
        Optional<CommonGunIndex> gunIndex = TimelessAPI.getCommonGunIndex(gunId);
        this.data.boltCoolDown = gunIndex.map(index -> {
            long coolDown = (long)(index.getGunData().getBoltActionTime() * 1000.0f) - (System.currentTimeMillis() - this.data.boltTimestamp);
            if ((coolDown -= 5L) < 0L) {
                return 0L;
            }
            return coolDown;
        }).orElse(-1L);
        if (this.data.boltCoolDown == 0L) {
            if (iGun instanceof AbstractGunItem) {
                AbstractGunItem logicGun = (AbstractGunItem)iGun;
                logicGun.bolt(currentGunItem);
            }
            this.data.boltCoolDown = -1L;
        }
    }
}

