/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.compat.oculus;

import com.tacz.guns.compat.oculus.legacy.OculusCompatLegacy;
import com.tacz.guns.compat.oculus.newly.OculusCompatNewly;
import java.util.function.Function;
import java.util.function.Supplier;
import net.irisshaders.iris.api.v0.IrisApi;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraftforge.fml.ModList;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public final class OculusCompat {
    private static final DefaultArtifactVersion VERSION = new DefaultArtifactVersion("1.7.0");
    private static Function<MultiBufferSource.BufferSource, Boolean> END_BATCH_FUNCTION;
    private static Supplier<Boolean> IS_RENDER_SHADOW_SUPPER;

    public static void initCompat() {
        ModList.get().getModContainerById("oculus").ifPresent(mod -> {
            if (mod.getModInfo().getVersion().compareTo((Object)VERSION) >= 0) {
                END_BATCH_FUNCTION = OculusCompatNewly::endBatch;
                IS_RENDER_SHADOW_SUPPER = OculusCompatNewly::isRenderShadow;
                OculusCompatNewly.registerPBRLoader();
            } else {
                END_BATCH_FUNCTION = OculusCompatLegacy::endBatch;
                IS_RENDER_SHADOW_SUPPER = OculusCompatLegacy::isRenderShadow;
                OculusCompatLegacy.registerPBRLoader();
            }
        });
    }

    public static boolean isRenderShadow() {
        if (ModList.get().isLoaded("oculus")) {
            return IS_RENDER_SHADOW_SUPPER.get();
        }
        return false;
    }

    public static boolean isUsingRenderPack() {
        if (ModList.get().isLoaded("oculus")) {
            return IrisApi.getInstance().isShaderPackInUse();
        }
        return false;
    }

    public static boolean endBatch(MultiBufferSource.BufferSource bufferSource) {
        if (ModList.get().isLoaded("oculus")) {
            return END_BATCH_FUNCTION.apply(bufferSource);
        }
        return false;
    }
}

