/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.event;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.gameplay.IClientPlayerGunOperator;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.entity.ReloadState;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.animation.statemachine.GunAnimationStateMachine;
import com.tacz.guns.client.gui.GunRefitScreen;
import com.tacz.guns.client.renderer.crosshair.CrosshairType;
import com.tacz.guns.compat.shouldersurfing.ShoulderSurfingCompat;
import com.tacz.guns.config.client.RenderConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="tacz")
public class RenderCrosshairEvent {
    private static final ResourceLocation HIT_ICON = new ResourceLocation("tacz", "textures/crosshair/hit/hit_marker.png");
    private static final long KEEP_TIME = 300L;
    private static boolean isRefitScreen = false;
    private static long hitTimestamp = -1L;
    private static long killTimestamp = -1L;
    private static long headShotTimestamp = -1L;

    @SubscribeEvent(receiveCanceled=true)
    public static void onRenderOverlay(RenderGuiOverlayEvent.Pre event) {
        if (event.getOverlay().id().equals((Object)VanillaGuiOverlay.CROSSHAIR.id())) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            if (!IGun.mainhandHoldGun((LivingEntity)player)) {
                return;
            }
            event.setCanceled(true);
            RenderCrosshairEvent.renderHitMarker(event.getGuiGraphics(), event.getWindow());
            ReloadState reloadState = IGunOperator.fromLivingEntity((LivingEntity)player).getSynReloadState();
            if (reloadState.getStateType().isReloading()) {
                return;
            }
            if (isRefitScreen) {
                return;
            }
            ItemStack stack = player.m_21205_();
            Item item = stack.m_41720_();
            if (!(item instanceof IGun)) {
                return;
            }
            IGun iGun = (IGun)item;
            ResourceLocation gunId = iGun.getGunId(stack);
            IClientPlayerGunOperator playerGunOperator = IClientPlayerGunOperator.fromLocalPlayer(player);
            TimelessAPI.getClientGunIndex(gunId).ifPresent(gunIndex -> {
                GunAnimationStateMachine animationStateMachine;
                if ((double)playerGunOperator.getClientAimingProgress(event.getPartialTick()) > 0.9) {
                    boolean forceShow = gunIndex.isShowCrosshair();
                    boolean shoulderSurfingForceShow = ShoulderSurfingCompat.showCrosshair();
                    if (!forceShow && !shoulderSurfingForceShow) {
                        return;
                    }
                }
                if (!(animationStateMachine = gunIndex.getAnimationStateMachine()).shouldHideCrossHair()) {
                    RenderCrosshairEvent.renderCrosshair(event.getGuiGraphics(), event.getWindow());
                }
            });
        }
    }

    @SubscribeEvent
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        isRefitScreen = Minecraft.m_91087_().f_91080_ instanceof GunRefitScreen;
    }

    private static void renderCrosshair(GuiGraphics graphics, Window window) {
        Options options = Minecraft.m_91087_().f_91066_;
        boolean shoulderSurfingForceShow = ShoulderSurfingCompat.showCrosshair();
        if (!options.m_92176_().m_90612_() && !shoulderSurfingForceShow) {
            return;
        }
        if (options.f_92062_) {
            return;
        }
        MultiPlayerGameMode gameMode = Minecraft.m_91087_().f_91072_;
        if (gameMode == null) {
            return;
        }
        if (gameMode.m_105295_() == GameType.SPECTATOR) {
            return;
        }
        int width = window.m_85445_();
        int height = window.m_85446_();
        ResourceLocation location = CrosshairType.getTextureLocation((CrosshairType)((Object)RenderConfig.CROSSHAIR_TYPE.get()));
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.9f);
        float x = (float)width / 2.0f - 8.0f;
        float y = (float)height / 2.0f - 8.0f;
        graphics.m_280163_(location, (int)x, (int)y, 0.0f, 0.0f, 16, 16, 16, 16);
    }

    private static void renderHitMarker(GuiGraphics graphics, Window window) {
        float fadeTime;
        long remainHitTime = System.currentTimeMillis() - hitTimestamp;
        long remainKillTime = System.currentTimeMillis() - killTimestamp;
        long remainHeadShotTime = System.currentTimeMillis() - headShotTimestamp;
        float offset = ((Double)RenderConfig.HIT_MARKET_START_POSITION.get()).floatValue();
        if (remainKillTime > 300L) {
            if (remainHitTime > 300L) {
                return;
            }
            fadeTime = remainHitTime;
        } else {
            offset += (float)remainKillTime * 4.0f / 300.0f;
            fadeTime = remainKillTime;
        }
        int width = window.m_85445_();
        int height = window.m_85446_();
        float x = (float)width / 2.0f - 8.0f;
        float y = (float)height / 2.0f - 8.0f;
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        if (remainHeadShotTime > 300L) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - fadeTime / 300.0f));
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)0.0f, (float)0.0f, (float)(1.0f - fadeTime / 300.0f));
        }
        graphics.m_280163_(HIT_ICON, (int)(x - offset), (int)(y - offset), 0.0f, 0.0f, 8, 8, 16, 16);
        graphics.m_280163_(HIT_ICON, (int)(x + 8.0f + offset), (int)(y - offset), 8.0f, 0.0f, 8, 8, 16, 16);
        graphics.m_280163_(HIT_ICON, (int)(x - offset), (int)(y + 8.0f + offset), 0.0f, 8.0f, 8, 8, 16, 16);
        graphics.m_280163_(HIT_ICON, (int)(x + 8.0f + offset), (int)(y + 8.0f + offset), 8.0f, 8.0f, 8, 8, 16, 16);
    }

    public static void markHitTimestamp() {
        hitTimestamp = System.currentTimeMillis();
    }

    public static void markKillTimestamp() {
        killTimestamp = System.currentTimeMillis();
    }

    public static void markHeadShotTimestamp() {
        headShotTimestamp = System.currentTimeMillis();
    }
}

