/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.api.item.gun;

import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.item.GunTabType;
import com.tacz.guns.api.item.IAmmo;
import com.tacz.guns.api.item.IAmmoBox;
import com.tacz.guns.api.item.IAttachment;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.api.item.builder.AmmoItemBuilder;
import com.tacz.guns.api.item.builder.GunItemBuilder;
import com.tacz.guns.client.renderer.item.GunItemRenderer;
import com.tacz.guns.client.resource.index.ClientGunIndex;
import com.tacz.guns.inventory.tooltip.GunTooltip;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.pojo.data.gun.Bolt;
import com.tacz.guns.resource.pojo.data.gun.FeedType;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.util.AllowAttachmentTagMatcher;
import com.tacz.guns.util.AttachmentDataUtils;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class AbstractGunItem
extends Item
implements IGun {
    protected AbstractGunItem(Item.Properties pProperties) {
        super(pProperties);
    }

    private static Comparator<Map.Entry<ResourceLocation, CommonGunIndex>> idNameSort() {
        return Comparator.comparingInt(m -> ((CommonGunIndex)m.getValue()).getSort());
    }

    public abstract void bolt(ItemStack var1);

    public abstract void shoot(ItemStack var1, Supplier<Float> var2, Supplier<Float> var3, boolean var4, LivingEntity var5);

    public abstract void fireSelect(ItemStack var1);

    public abstract void melee(LivingEntity var1, ItemStack var2);

    public boolean canReload(LivingEntity shooter, ItemStack gunItem) {
        int maxAmmoCount;
        ResourceLocation gunId = this.getGunId(gunItem);
        CommonGunIndex gunIndex = TimelessAPI.getCommonGunIndex(gunId).orElse(null);
        if (gunIndex == null) {
            return false;
        }
        int currentAmmoCount = this.getCurrentAmmoCount(gunItem);
        if (currentAmmoCount >= (maxAmmoCount = AttachmentDataUtils.getAmmoCountWithAttachment(gunItem, gunIndex.getGunData()))) {
            return false;
        }
        if (this.useDummyAmmo(gunItem)) {
            return this.getDummyAmmoAmount(gunItem) > 0;
        }
        return shooter.getCapability(ForgeCapabilities.ITEM_HANDLER, null).map(cap -> {
            for (int i = 0; i < cap.getSlots(); ++i) {
                IAmmoBox iAmmoBox;
                IAmmo iAmmo;
                ItemStack checkAmmoStack = cap.getStackInSlot(i);
                Item patt3544$temp = checkAmmoStack.m_41720_();
                if (patt3544$temp instanceof IAmmo && (iAmmo = (IAmmo)patt3544$temp).isAmmoOfGun(gunItem, checkAmmoStack)) {
                    return true;
                }
                Item patt3712$temp = checkAmmoStack.m_41720_();
                if (!(patt3712$temp instanceof IAmmoBox) || !(iAmmoBox = (IAmmoBox)patt3712$temp).isAmmoBoxOfGun(gunItem, checkAmmoStack)) continue;
                return true;
            }
            return false;
        }).orElse(false);
    }

    public void doReload(LivingEntity shooter, ItemStack gunItem, boolean loadBarrel) {
        ResourceLocation gunId = this.getGunId(gunItem);
        CommonGunIndex gunIndex = TimelessAPI.getCommonGunIndex(gunId).orElse(null);
        if (gunIndex == null) {
            return;
        }
        int maxAmmoCount = AttachmentDataUtils.getAmmoCountWithAttachment(gunItem, gunIndex.getGunData());
        int currentAmmoCount = this.getCurrentAmmoCount(gunItem);
        int needAmmoCount = maxAmmoCount - currentAmmoCount;
        int updatedAmmoCount = currentAmmoCount;
        switch (gunIndex.getGunData().getReloadData().getType()) {
            case MAGAZINE: {
                if (IGunOperator.fromLivingEntity(shooter).needCheckAmmo()) {
                    if (this.useDummyAmmo(gunItem)) {
                        updatedAmmoCount += this.findAndExtractDummyAmmo(gunItem, needAmmoCount);
                        break;
                    }
                    updatedAmmoCount += shooter.getCapability(ForgeCapabilities.ITEM_HANDLER, null).map(cap -> this.findAndExtractInventoryAmmos((IItemHandler)cap, gunItem, needAmmoCount)).orElse(0).intValue();
                    break;
                }
                updatedAmmoCount = maxAmmoCount;
                break;
            }
            case FUEL: {
                if (IGunOperator.fromLivingEntity(shooter).needCheckAmmo()) {
                    if (this.useDummyAmmo(gunItem)) {
                        if (this.findAndExtractDummyAmmo(gunItem, 1) <= 0) break;
                        updatedAmmoCount = maxAmmoCount;
                        break;
                    }
                    if (shooter.getCapability(ForgeCapabilities.ITEM_HANDLER, null).map(cap -> this.findAndExtractInventoryAmmos((IItemHandler)cap, gunItem, 1)).orElse(0) <= 0) break;
                    updatedAmmoCount = maxAmmoCount;
                    break;
                }
                updatedAmmoCount = maxAmmoCount;
                break;
            }
        }
        this.finishReload(gunItem, updatedAmmoCount, loadBarrel);
    }

    @Override
    public void dropAllAmmo(Player player, ItemStack gunItem) {
        int ammoCount = this.getCurrentAmmoCount(gunItem);
        if (ammoCount <= 0) {
            return;
        }
        ResourceLocation gunId = this.getGunId(gunItem);
        TimelessAPI.getCommonGunIndex(gunId).ifPresent(index -> {
            if (this.useDummyAmmo(gunItem)) {
                this.setCurrentAmmoCount(gunItem, 0);
                if (index.getGunData().getReloadData().getType().equals((Object)FeedType.FUEL)) {
                    return;
                }
                this.addDummyAmmoAmount(gunItem, ammoCount);
                return;
            }
            ResourceLocation ammoId = index.getGunData().getAmmoId();
            if (player.m_7500_()) {
                int maxAmmCount = AttachmentDataUtils.getAmmoCountWithAttachment(gunItem, index.getGunData());
                this.setCurrentAmmoCount(gunItem, maxAmmCount);
                return;
            }
            if (index.getGunData().getReloadData().getType().equals((Object)FeedType.FUEL)) {
                this.setCurrentAmmoCount(gunItem, 0);
                return;
            }
            TimelessAPI.getCommonAmmoIndex(ammoId).ifPresent(ammoIndex -> {
                int stackSize = ammoIndex.getStackSize();
                int tmpAmmoCount = ammoCount;
                int roundCount = tmpAmmoCount / (stackSize + 1);
                for (int i = 0; i <= roundCount; ++i) {
                    int count = Math.min(tmpAmmoCount, stackSize);
                    ItemStack ammoItem = AmmoItemBuilder.create().setId(ammoId).setCount(count).build();
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)ammoItem);
                    tmpAmmoCount -= stackSize;
                }
                this.setCurrentAmmoCount(gunItem, 0);
            });
        });
    }

    public int findAndExtractInventoryAmmos(IItemHandler itemHandler, ItemStack gunItem, int needAmmoCount) {
        Item extractItem;
        IAmmo iAmmo;
        ItemStack checkAmmoStack;
        Item item;
        int cnt = needAmmoCount;
        for (int i = 0; !(i >= itemHandler.getSlots() || (item = (checkAmmoStack = itemHandler.getStackInSlot(i)).m_41720_()) instanceof IAmmo && (iAmmo = (IAmmo)item).isAmmoOfGun(gunItem, checkAmmoStack) && (cnt -= (extractItem = itemHandler.extractItem(i, cnt, false)).m_41613_()) <= 0); ++i) {
            IAmmoBox iAmmoBox;
            extractItem = checkAmmoStack.m_41720_();
            if (!(extractItem instanceof IAmmoBox) || !(iAmmoBox = (IAmmoBox)extractItem).isAmmoBoxOfGun(gunItem, checkAmmoStack)) continue;
            int boxAmmoCount = iAmmoBox.getAmmoCount(checkAmmoStack);
            int extractCount = Math.min(boxAmmoCount, cnt);
            int remainCount = boxAmmoCount - extractCount;
            iAmmoBox.setAmmoCount(checkAmmoStack, remainCount);
            if (remainCount <= 0) {
                iAmmoBox.setAmmoId(checkAmmoStack, DefaultAssets.EMPTY_AMMO_ID);
            }
            if ((cnt -= extractCount) <= 0) break;
        }
        return needAmmoCount - cnt;
    }

    public int findAndExtractDummyAmmo(ItemStack gunItem, int needAmmoCount) {
        int dummyAmmoCount = this.getDummyAmmoAmount(gunItem);
        int extractCount = Math.min(dummyAmmoCount, needAmmoCount);
        this.addDummyAmmoAmount(gunItem, -extractCount);
        return extractCount;
    }

    public void finishReload(ItemStack gunItem, int ammoCount, boolean loadBarrel) {
        ResourceLocation gunId = this.getGunId(gunItem);
        Bolt boltType = TimelessAPI.getCommonGunIndex(gunId).map(index -> index.getGunData().getBolt()).orElse(null);
        this.setCurrentAmmoCount(gunItem, ammoCount);
        if (loadBarrel && (boltType == Bolt.MANUAL_ACTION || boltType == Bolt.CLOSED_BOLT)) {
            this.reduceCurrentAmmoCount(gunItem);
            this.setBulletInBarrel(gunItem, true);
        }
    }

    @Deprecated
    public void reloadAmmo(ItemStack gunItem, int ammoCount, boolean loadBarrel) {
        throw new UnsupportedOperationException("this method is deprecated, please use \u2018doReload\u2019 instead");
    }

    @Override
    public boolean allowAttachment(ItemStack gun, ItemStack attachmentItem) {
        IAttachment iAttachment = IAttachment.getIAttachmentOrNull(attachmentItem);
        IGun iGun = IGun.getIGunOrNull(gun);
        if (iGun != null && iAttachment != null) {
            ResourceLocation gunId = iGun.getGunId(gun);
            ResourceLocation attachmentId = iAttachment.getAttachmentId(attachmentItem);
            return AllowAttachmentTagMatcher.match(gunId, attachmentId);
        }
        return false;
    }

    @Override
    public boolean allowAttachmentType(ItemStack gun, AttachmentType type) {
        IGun iGun = IGun.getIGunOrNull(gun);
        if (iGun != null) {
            return TimelessAPI.getCommonGunIndex(iGun.getGunId(gun)).map(gunIndex -> {
                List<AttachmentType> allowAttachments = gunIndex.getGunData().getAllowAttachments();
                if (allowAttachments == null) {
                    return false;
                }
                return allowAttachments.contains((Object)type);
            }).orElse(false);
        }
        return false;
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public Component m_7626_(@Nonnull ItemStack stack) {
        ResourceLocation gunId = this.getGunId(stack);
        Optional<ClientGunIndex> gunIndex = TimelessAPI.getClientGunIndex(gunId);
        if (gunIndex.isPresent()) {
            return Component.m_237115_((String)gunIndex.get().getName());
        }
        return super.m_7626_(stack);
    }

    public static NonNullList<ItemStack> fillItemCategory(GunTabType type) {
        NonNullList stacks = NonNullList.m_122779_();
        TimelessAPI.getAllCommonGunIndex().stream().sorted(AbstractGunItem.idNameSort()).forEach(entry -> {
            String indexType;
            CommonGunIndex index = (CommonGunIndex)entry.getValue();
            GunData gunData = index.getGunData();
            String key = type.name().toLowerCase(Locale.US);
            if (key.equals(indexType = index.getType())) {
                ItemStack itemStack = GunItemBuilder.create().setId((ResourceLocation)entry.getKey()).setFireMode(gunData.getFireModeSet().get(0)).setAmmoCount(gunData.getAmmoAmount()).setAmmoInBarrel(true).build();
                stacks.add((Object)itemStack);
            }
        });
        return stacks;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                Minecraft minecraft = Minecraft.m_91087_();
                return new GunItemRenderer(minecraft.m_167982_(), minecraft.m_167973_());
            }
        });
    }

    @Nonnull
    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof IGun) {
            IGun iGun = (IGun)item;
            Optional<CommonGunIndex> optional = TimelessAPI.getCommonGunIndex(this.getGunId(stack));
            if (optional.isPresent()) {
                CommonGunIndex gunIndex = optional.get();
                ResourceLocation ammoId = gunIndex.getGunData().getAmmoId();
                return Optional.of(new GunTooltip(stack, iGun, ammoId, gunIndex));
            }
        }
        return Optional.empty();
    }
}

