/*
 * Decompiled with CFR 0.152.
 */
package me.edoren.skin_changer.client;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import me.edoren.skin_changer.client.api.ISkinTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.NotNull;

public class CustomSkinTexture
extends SimpleTexture
implements ISkinTexture {
    private final WeakReference<ByteBuffer> _data;

    public CustomSkinTexture(ResourceLocation location, ByteBuffer data) {
        super(location);
        if (data == null) {
            throw new IllegalArgumentException("Buffer must not be null");
        }
        this._data = new WeakReference<ByteBuffer>(data);
    }

    @Override
    public ByteBuffer getData() {
        return (ByteBuffer)this._data.get();
    }

    public ResourceLocation getLocation() {
        return this.f_118129_;
    }

    public void m_6704_(@NotNull ResourceManager manager) throws IOException {
        ByteBuffer buffer = this.getData();
        if (buffer != null) {
            NativeImage image = NativeImage.m_85062_((ByteBuffer)buffer.duplicate());
            if (!RenderSystem.isOnRenderThreadOrInit()) {
                RenderSystem.recordRenderCall(() -> this.upload(image));
            } else {
                this.upload(image);
            }
        }
    }

    private void upload(NativeImage image) {
        TextureUtil.prepareImage((int)this.m_117963_(), (int)0, (int)image.m_84982_(), (int)image.m_85084_());
        image.m_85040_(0, 0, 0, true);
    }
}

