/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar.element;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.lwjgl.opengl.GL11;
import xaero.common.IXaeroMinimap;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRenderer;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.common.icon.XaeroIcon;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.element.render.MinimapElementRenderer;
import xaero.common.minimap.radar.MinimapRadar;
import xaero.common.minimap.radar.category.EntityRadarCategory;
import xaero.common.minimap.radar.category.EntityRadarCategoryManager;
import xaero.common.minimap.radar.category.setting.EntityRadarCategorySettings;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.render.radar.EntityIconManager;
import xaero.common.minimap.render.radar.element.RadarElementReader;
import xaero.common.minimap.render.radar.element.RadarRenderContext;
import xaero.common.minimap.render.radar.element.RadarRenderProvider;
import xaero.common.misc.Misc;
import xaero.common.settings.ModSettings;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.Minimap;
import xaero.hud.minimap.element.render.MinimapElementRenderInfo;
import xaero.hud.minimap.element.render.MinimapElementRenderLocation;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.render.TextureLocations;

public final class RadarRenderer
extends MinimapElementRenderer<Entity, RadarRenderContext> {
    private final IXaeroMinimap modMain;
    private final EntityIconManager entityIconManager;
    private final Minimap minimap;
    private MinimapElementRenderInfo compatibleRenderInfo;
    private final RadarRenderProvider radarRenderProvider;
    private boolean ignoreProviderCheck;
    private MultiBufferSource.BufferSource minimapBufferSource;
    private double maxDistanceSquared;

    private RadarRenderer(IXaeroMinimap modMain, EntityIconManager entityIconManager, Minimap minimap, RadarElementReader elementReader, RadarRenderProvider provider, RadarRenderContext context) {
        super(elementReader, provider, context);
        this.modMain = modMain;
        this.entityIconManager = entityIconManager;
        this.minimap = minimap;
        this.radarRenderProvider = provider;
    }

    @Override
    public void preRender(MinimapElementRenderInfo renderInfo, MultiBufferSource.BufferSource vanillaBufferSource, MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers) {
        ModSettings settings = this.modMain.getSettings();
        this.entityIconManager.allowPrerender();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureLocations.GUI_TEXTURES);
        Minecraft.m_91087_().m_91097_().m_174784_(TextureLocations.GUI_TEXTURES);
        if (settings.getSmoothDots()) {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        } else {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        RenderType dotsRenderType = settings.getSmoothDots() ? CustomRenderTypes.GUI_BILINEAR : CustomRenderTypes.GUI_NEAREST;
        MinimapSession session = BuiltInHudModules.MINIMAP.getCurrentSession();
        ((RadarRenderContext)this.context).minimapRadar = session.getProcessor().getEntityRadar();
        ((RadarRenderContext)this.context).reversedOrder = ModSettings.keyReverseEntityRadar.m_90857_();
        ((RadarRenderContext)this.context).nameScale = settings.getDotNameScale();
        ((RadarRenderContext)this.context).smoothDots = settings.getSmoothDots();
        ((RadarRenderContext)this.context).debugEntityIcons = settings.debugEntityIcons;
        ((RadarRenderContext)this.context).debugEntityVariantIds = settings.debugEntityVariantIds;
        ((RadarRenderContext)this.context).dotsStyle = settings.getDotsStyle();
        ((RadarRenderContext)this.context).dotsRenderType = dotsRenderType;
        RenderSystem.disableDepthTest();
        vanillaBufferSource.m_109911_();
        this.minimapBufferSource = this.modMain.getHudRenderer().getCustomVertexConsumers().getBetterPVPRenderTypeBuffers();
        ((RadarRenderContext)this.context).dotsBufferBuilder = this.minimapBufferSource.m_6299_(dotsRenderType);
        ((RadarRenderContext)this.context).nameBgBuilder = this.minimapBufferSource.m_6299_(CustomRenderTypes.RADAR_NAME_BGS);
        ((RadarRenderContext)this.context).iconsRenderer = multiTextureRenderTypeRenderers.getRenderer(t -> RenderSystem.setShaderTexture((int)0, (int)t), MultiTextureRenderTypeRendererProvider::defaultTextureBind, CustomRenderTypes.GUI_BILINEAR);
        ((RadarRenderContext)this.context).font = Minecraft.m_91087_().f_91062_;
        ((RadarRenderContext)this.context).helper = this.modMain.getMinimap().getMinimapFBORenderer().getHelper();
        double playerDimDiv = renderInfo.backgroundCoordinateScale / renderInfo.renderEntityDimensionScale;
        this.maxDistanceSquared = ((RadarRenderContext)this.context).minimapRadar.getMaxDistance(session.getProcessor(), settings.minimapShape == 1) * playerDimDiv * playerDimDiv;
    }

    @Override
    public void postRender(MinimapElementRenderInfo renderInfo, MultiBufferSource.BufferSource vanillaBufferSource, MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers) {
        if (((RadarRenderContext)this.context).reversedOrder) {
            this.minimapBufferSource.m_109912_(((RadarRenderContext)this.context).dotsRenderType);
        }
        multiTextureRenderTypeRenderers.draw(((RadarRenderContext)this.context).iconsRenderer);
        if (!((RadarRenderContext)this.context).reversedOrder) {
            this.minimapBufferSource.m_109912_(((RadarRenderContext)this.context).dotsRenderType);
        }
        this.minimapBufferSource.m_109911_();
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)515);
        ((RadarRenderContext)this.context).iconsRenderer = null;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureLocations.GUI_TEXTURES);
        Minecraft.m_91087_().m_91097_().m_174784_(TextureLocations.GUI_TEXTURES);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
    }

    @Override
    public boolean renderElement(Entity e, boolean highlighted, boolean outOfBounds, double optionalDepth, float optionalScale, double partialX, double partialY, MinimapElementRenderInfo renderInfo, GuiGraphics guiGraphics, MultiBufferSource.BufferSource vanillaBufferSource) {
        double dotsScale;
        boolean usableIcon;
        XaeroIcon entityHeadTexture;
        if (!(highlighted || this.ignoreProviderCheck || this.radarRenderProvider.isUsed())) {
            throw new IllegalStateException("this renderer can only be used with its element provider");
        }
        if (renderInfo.location == MinimapElementRenderLocation.IN_MINIMAP) {
            double offx = e.m_20185_() - ((RadarRenderContext)this.context).renderEntity.m_20185_();
            double offx2 = offx * offx;
            if (offx2 > this.maxDistanceSquared) {
                return false;
            }
            double offy = e.m_20189_() - ((RadarRenderContext)this.context).renderEntity.m_20189_();
            double offy2 = offy * offy;
            if (offy2 > this.maxDistanceSquared) {
                return false;
            }
        }
        int nameSetting = ((RadarRenderContext)this.context).nameSettingForList;
        if (highlighted && !this.radarRenderProvider.isUsed()) {
            EntityRadarCategoryManager entityCategoryManager = ((RadarRenderContext)this.context).minimapRadar.getEntityCategoryManager();
            EntityRadarCategory rootCategory = entityCategoryManager.getRootCategory();
            EntityRadarCategory category = entityCategoryManager.getRuleResolver().resolve(rootCategory, e, renderInfo.player);
            this.radarRenderProvider.setupContextForCategory(category, (RadarRenderContext)this.context);
            this.radarRenderProvider.setupContextForEntity(e, (RadarRenderContext)this.context);
            nameSetting = category.getSettingValue(EntityRadarCategorySettings.NAMES).intValue();
        }
        RadarRenderContext context = (RadarRenderContext)this.context;
        MinimapRendererHelper helper = context.helper;
        PoseStack matrixStack = guiGraphics.m_280168_();
        if (e instanceof Player) {
            if (this.modMain.getTrackedPlayerRenderer().getCollector().playerExists(e.m_20148_())) {
                this.modMain.getTrackedPlayerRenderer().getCollector().confirmPlayerRadarRender((Player)e);
            }
            if (this.modMain.getSupportMods().worldmap() && (this.modMain.getSupportMods().worldmapSupport.hasTrackedPlayerSystemSupport() || this.modMain.getSupportMods().pac() && this.modMain.getSupportMods().worldmapSupport.supportsPacPlayerRadarFilter())) {
                this.modMain.getSupportMods().worldmapSupport.confirmPlayerRadarRender((Player)e);
            }
        }
        MinimapElementRenderLocation location = renderInfo.location;
        RenderTarget framebuffer = renderInfo.framebuffer;
        Entity renderEntity = renderInfo.renderEntity;
        boolean cave = renderInfo.cave;
        Player player = renderInfo.player;
        float optionScaleAdjust = location == MinimapElementRenderLocation.OVER_MINIMAP ? 0.5f : 1.0f;
        optionalScale *= optionScaleAdjust;
        int nameOffsetX = 0;
        int nameOffsetY = 0;
        matrixStack.m_85836_();
        boolean icon = context.icon;
        boolean name = context.name;
        if (highlighted && nameSetting > 0) {
            name = true;
        }
        XaeroIcon xaeroIcon = entityHeadTexture = icon ? this.entityIconManager.getEntityIcon(guiGraphics, e, framebuffer, helper, (float)context.iconScale, context.debugEntityIcons, context.debugEntityVariantIds) : null;
        if (entityHeadTexture == EntityIconManager.DOT) {
            entityHeadTexture = null;
            icon = false;
        }
        float offh = (float)(renderEntity.m_20186_() - e.m_20186_());
        matrixStack.m_85837_(partialX, partialY, 0.0);
        boolean bl = usableIcon = entityHeadTexture != null && entityHeadTexture != EntityIconManager.FAILED;
        if (usableIcon) {
            float a;
            float r;
            float g;
            float b;
            dotsScale = context.iconScale;
            double clampedScale = Math.max(1.0, dotsScale * (double)optionalScale);
            matrixStack.m_85841_((float)clampedScale, (float)clampedScale, 1.0f);
            float brightness = context.minimapRadar.getEntityBrightness(offh, context.heightLimit, context.startFadingAt, context.heightBasedFade);
            if (!cave) {
                g = b = brightness;
                r = b;
                a = 1.0f;
            } else {
                b = 1.0f;
                g = 1.0f;
                r = 1.0f;
                a = brightness;
            }
            helper.prepareMyTexturedColoredModalRect(matrixStack.m_85850_().m_252922_(), -31.0f, -31.0f, entityHeadTexture.getOffsetX() + 1, entityHeadTexture.getOffsetY() + 1, 62.0f, 62.0f, 62.0f, entityHeadTexture.getTextureAtlas().getWidth(), entityHeadTexture.getTextureAtlas().getTextureId(), r, g, b, a, context.iconsRenderer);
        } else {
            boolean smooth = context.smoothDots;
            if (!smooth) {
                optionalScale = (float)Math.ceil(optionalScale);
            }
            matrixStack.m_85841_(optionalScale, optionalScale, 1.0f);
            if (icon && context.displayNameWhenIconFails && entityHeadTexture == EntityIconManager.FAILED) {
                name = true;
            }
            dotsScale = context.dotScale;
            int color = context.minimapRadar.getEntityColour(player, e, offh, cave, context.entityCategory, context.heightLimit, context.startFadingAt, context.heightBasedFade, context.colorIndex);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            float a = (float)(color >> 24 & 0xFF) / 255.0f;
            int dotTextureX = 0;
            int dotTextureY = 0;
            int dotTextureW = 0;
            int dotTextureH = 0;
            float dotOffset = 0.0f;
            double dotActualScale = optionalScale;
            if (context.dotsStyle == 1) {
                if (smooth) {
                    dotTextureX = 1;
                    dotTextureY = 88;
                } else {
                    dotsScale = (int)dotsScale;
                    dotTextureX = 9;
                    dotTextureY = 77;
                }
                dotOffset = -3.5f;
                dotTextureH = 8;
                dotTextureW = 8;
                dotActualScale *= dotsScale;
                matrixStack.m_85841_((float)dotsScale, (float)dotsScale, 1.0f);
            } else {
                switch (context.dotSize) {
                    case 1: {
                        dotOffset = -4.5f;
                        dotTextureY = 108;
                        dotTextureH = 9;
                        dotTextureW = 9;
                        break;
                    }
                    case 3: {
                        dotOffset = -7.5f;
                        dotTextureY = 128;
                        dotTextureH = 15;
                        dotTextureW = 15;
                        break;
                    }
                    case 4: {
                        dotOffset = -10.5f;
                        dotTextureY = 160;
                        dotTextureH = 21;
                        dotTextureW = 21;
                        break;
                    }
                    default: {
                        dotOffset = -5.5f;
                        dotTextureY = 117;
                        dotTextureH = 11;
                        dotTextureW = 11;
                    }
                }
            }
            if (!smooth) {
                double dotRadius = (double)(-dotOffset) * dotActualScale;
                double dotRadiusPartial = dotRadius - (double)((int)dotRadius);
                nameOffsetX = partialX - dotRadiusPartial <= -0.5 ? -1 : 0;
                nameOffsetY = partialY - dotRadiusPartial < -0.5 ? -1 : 0;
            }
            helper.addTexturedColoredRectToExistingBuffer(matrixStack.m_85850_().m_252922_(), context.dotsBufferBuilder, dotOffset, dotOffset, dotTextureX, dotTextureY, dotTextureW, dotTextureH, r, g, b, a, 256.0f);
        }
        matrixStack.m_85849_();
        int displayY = context.displayY;
        if (name || displayY > 0) {
            matrixStack.m_85836_();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            matrixStack.m_85837_((double)nameOffsetX, (double)nameOffsetY, optionalDepth + (double)0.1f);
            int offsetY = usableIcon ? 11 : 5;
            matrixStack.m_252880_(0.0f, (float)Math.round((double)offsetY * dotsScale * (double)optionalScale), 0.0f);
            if (optionalScale < 1.0f) {
                optionalScale = 1.0f;
            }
            double dotNameScale = context.nameScale * (double)optionalScale;
            matrixStack.m_85841_((float)dotNameScale, (float)dotNameScale, 1.0f);
            Object yValueString = null;
            if (displayY > 0) {
                int yInt = (int)Math.floor(e.m_20186_());
                int pYInt = (int)Math.floor(renderEntity.m_20186_());
                yValueString = displayY == 1 ? "" + yInt : (displayY == 2 ? "" + (yInt - pYInt) : "");
                if (((String)(yValueString = (String)yValueString + (yInt > pYInt ? "\u2191" : (yInt != pYInt ? "\u2193" : "")))).length() == 0) {
                    yValueString = "-";
                }
            }
            Font font = context.font;
            if (name) {
                Component component = Misc.getFixedDisplayName(e);
                if (component != null) {
                    Object entityName = component.getString();
                    if (displayY > 0) {
                        entityName = (String)entityName + "(" + (String)yValueString + ")";
                    }
                    int nameW = font.m_92895_((String)entityName);
                    helper.addColoredRectToExistingBuffer(matrixStack.m_85850_().m_252922_(), context.nameBgBuilder, -nameW / 2 - 2, -1.0f, nameW + 3, 10, 0.0f, 0.0f, 0.0f, 0.3529412f);
                    Misc.drawNormalText(matrixStack, (String)entityName, (float)(-nameW / 2), 0.0f, -1, false, this.minimapBufferSource);
                }
            } else if (displayY > 0) {
                String yString = yValueString;
                int yStringW = font.m_92895_(yString);
                helper.addColoredRectToExistingBuffer(matrixStack.m_85850_().m_252922_(), context.nameBgBuilder, -yStringW / 2 - 2, -1.0f, yStringW + 3, 10, 0.0f, 0.0f, 0.0f, 0.3529412f);
                Misc.drawNormalText(matrixStack, yString, (float)(-yStringW / 2), 0.0f, -1, false, this.minimapBufferSource);
            }
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            matrixStack.m_85849_();
        }
        return true;
    }

    @Deprecated
    public void renderEntityDotToFBO(int location, boolean highlit, GuiGraphics guiGraphics, MinimapProcessor minimap, Player p, Entity renderEntity, Entity e, float partial, boolean name, boolean icon, MinimapRadar minimapRadar, int style, boolean smooth, boolean debug, boolean debugEntityVariantIds, boolean cave, double dotNameScale, MultiBufferSource.BufferSource textRenderTypeBuffer, RenderType dotsRenderType, VertexConsumer dotsBufferBuilder, MultiTextureRenderTypeRenderer iconsRenderer, VertexConsumer nameBgBuilder, int dotIndex, boolean displayNameWhenIconFails, int heightLimit, boolean heightBasedFade, int startFadingAt, double iconScale, int dotSize, int colorIndex, int displayY, EntityRadarCategory category, MinimapRendererHelper helper, Font font, RenderTarget framebuffer, float minimapScale) {
        this.renderEntityDotToFBO(MinimapElementRenderLocation.fromIndex(location), highlit, guiGraphics, minimap, p, renderEntity, e, partial, name, icon, minimapRadar, style, smooth, debug, debugEntityVariantIds, cave, dotNameScale, textRenderTypeBuffer, dotsRenderType, dotsBufferBuilder, iconsRenderer, nameBgBuilder, dotIndex, displayNameWhenIconFails, heightLimit, heightBasedFade, startFadingAt, iconScale, dotSize, colorIndex, displayY, category, helper, font, framebuffer, minimapScale);
    }

    public void renderEntityDotToFBO(MinimapElementRenderLocation location, boolean highlit, GuiGraphics guiGraphics, MinimapProcessor minimap, Player p, Entity renderEntity, Entity e, float partial, boolean name, boolean icon, MinimapRadar minimapRadar, int style, boolean smooth, boolean debug, boolean debugEntityVariantIds, boolean cave, double dotNameScale, MultiBufferSource.BufferSource textRenderTypeBuffer, RenderType dotsRenderType, VertexConsumer dotsBufferBuilder, MultiTextureRenderTypeRenderer iconsRenderer, VertexConsumer nameBgBuilder, int dotIndex, boolean displayNameWhenIconFails, int heightLimit, boolean heightBasedFade, int startFadingAt, double iconScale, int dotSize, int colorIndex, int displayY, EntityRadarCategory category, MinimapRendererHelper helper, Font font, RenderTarget framebuffer, float minimapScale) {
        ((RadarRenderContext)this.context).nameScale = dotNameScale;
        ((RadarRenderContext)this.context).smoothDots = smooth;
        ((RadarRenderContext)this.context).debugEntityIcons = debug;
        ((RadarRenderContext)this.context).debugEntityVariantIds = debugEntityVariantIds;
        ((RadarRenderContext)this.context).dotsStyle = style;
        ((RadarRenderContext)this.context).dotsRenderType = dotsRenderType;
        ((RadarRenderContext)this.context).dotsBufferBuilder = dotsBufferBuilder;
        ((RadarRenderContext)this.context).nameBgBuilder = nameBgBuilder;
        ((RadarRenderContext)this.context).iconsRenderer = iconsRenderer;
        ((RadarRenderContext)this.context).font = font;
        ((RadarRenderContext)this.context).helper = helper;
        ((RadarRenderContext)this.context).name = name;
        ((RadarRenderContext)this.context).icon = icon;
        ((RadarRenderContext)this.context).displayNameWhenIconFails = displayNameWhenIconFails;
        ((RadarRenderContext)this.context).heightLimit = heightLimit;
        ((RadarRenderContext)this.context).heightBasedFade = heightBasedFade;
        ((RadarRenderContext)this.context).startFadingAt = startFadingAt;
        ((RadarRenderContext)this.context).iconScale = iconScale;
        ((RadarRenderContext)this.context).dotSize = dotSize;
        ((RadarRenderContext)this.context).colorIndex = colorIndex;
        ((RadarRenderContext)this.context).displayY = displayY;
        ((RadarRenderContext)this.context).entityCategory = category;
        ((RadarRenderContext)this.context).minimapRadar = minimapRadar;
        MinimapElementRenderInfo renderInfo = new MinimapElementRenderInfo(location, renderEntity, p, new Vec3(0.0, 0.0, 0.0), cave, 1.0f, framebuffer, 1.0, null);
        this.ignoreProviderCheck = true;
        this.renderElement(e, highlit, false, 0.0, minimapScale, 0.0, 0.0, renderInfo, guiGraphics, textRenderTypeBuffer);
        this.ignoreProviderCheck = false;
        ((RadarRenderContext)this.context).iconsRenderer = null;
    }

    @Override
    public boolean shouldRender(MinimapElementRenderLocation location) {
        return this.minimap.usingFBO() && (location == MinimapElementRenderLocation.WORLD_MAP || location == MinimapElementRenderLocation.WORLD_MAP_MENU || this.modMain.getSettings().getEntityRadar());
    }

    @Override
    @Deprecated
    public boolean renderElement(int location, boolean highlit, boolean outOfBounds, GuiGraphics guiGraphics, MultiBufferSource.BufferSource renderTypeBuffers, Font font, RenderTarget framebuffer, MinimapRendererHelper helper, Entity renderEntity, Player player, double renderX, double renderY, double renderZ, int elementIndex, double optionalDepth, float optionalScale, Entity element, double partialX, double partialY, boolean cave, float partialTicks) {
        if (this.compatibleRenderInfo == null) {
            MinimapSession session = BuiltInHudModules.MINIMAP.getCurrentSession();
            this.compatibleRenderInfo = new MinimapElementRenderInfo(MinimapElementRenderLocation.fromIndex(location), renderEntity, player, new Vec3(renderX, renderY, renderZ), cave, partialTicks, framebuffer, session.getProcessor().getLastMapDimensionScale(), session.getProcessor().getLastMapDimension());
        }
        return this.renderElement(element, highlit, outOfBounds, optionalDepth, optionalScale, partialX, partialY, this.compatibleRenderInfo, guiGraphics, renderTypeBuffers);
    }

    @Override
    @Deprecated
    public void preRender(int location, Entity renderEntity, Player player, double renderX, double renderY, double renderZ, IXaeroMinimap modMain, MultiBufferSource.BufferSource renderTypeBuffers, MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers) {
        this.preRender(new MinimapElementRenderInfo(MinimapElementRenderLocation.fromIndex(location), renderEntity, player, new Vec3(renderX, renderY, renderZ), false, 1.0f, null, Minecraft.m_91087_().f_91073_.m_6042_().f_63859_(), (ResourceKey<Level>)Minecraft.m_91087_().f_91073_.m_46472_()), renderTypeBuffers, multiTextureRenderTypeRenderers);
    }

    @Override
    @Deprecated
    public void postRender(int location, Entity renderEntity, Player player, double renderX, double renderY, double renderZ, IXaeroMinimap modMain, MultiBufferSource.BufferSource renderTypeBuffers, MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers) {
        this.postRender(this.compatibleRenderInfo, renderTypeBuffers, multiTextureRenderTypeRenderers);
        this.compatibleRenderInfo = null;
    }

    @Override
    @Deprecated
    public boolean shouldRender(int location) {
        return this.shouldRender(MinimapElementRenderLocation.fromIndex(location));
    }

    public static final class Builder {
        private IXaeroMinimap modMain;
        private EntityIconManager entityIconManager;
        private Minimap minimap;

        private Builder() {
        }

        private Builder setDefault() {
            this.setEntityIconManager(null);
            return this;
        }

        public Builder setModMain(IXaeroMinimap modMain) {
            this.modMain = modMain;
            return this;
        }

        public Builder setEntityIconManager(EntityIconManager entityIconManager) {
            this.entityIconManager = entityIconManager;
            return this;
        }

        public Builder setMinimap(Minimap minimap) {
            this.minimap = minimap;
            return this;
        }

        public RadarRenderer build() {
            if (this.modMain == null || this.entityIconManager == null || this.minimap == null) {
                throw new IllegalStateException();
            }
            RadarElementReader elementReader = new RadarElementReader();
            RadarRenderProvider provider = new RadarRenderProvider();
            RadarRenderContext context = new RadarRenderContext();
            return new RadarRenderer(this.modMain, this.entityIconManager, this.minimap, elementReader, provider, context);
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

