/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.world;

import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.event.VampirismVillageEvent;
import de.teamlapen.werewolves.api.WReference;
import de.teamlapen.werewolves.api.entities.werewolf.IVillagerTransformable;
import de.teamlapen.werewolves.api.entities.werewolf.TransformType;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfTransformable;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ModWorldEventHandler {
    @SubscribeEvent
    public void onVillageCaptureFinish(VampirismVillageEvent.VillagerCaptureFinish.Pre event) {
        Level world = ((BlockEntity)event.getTotem()).m_58904_();
        List werewolves = world.m_6443_(Mob.class, event.getVillageArea(), entity -> entity instanceof WerewolfTransformable);
        if (WReference.WEREWOLF_FACTION.equals((Object)event.getControllingFaction())) {
            werewolves.forEach(e -> {
                if (((WerewolfTransformable)e).canTransform()) {
                    ((WerewolfTransformable)e).transformBack();
                } else if (event.isForced() && event.getCapturingFaction() != null) {
                    this.getCaptureEntity(event.getCapturingFaction(), world).ifPresent(mob -> this.spawnEntity(world, (Mob)mob, (Mob)e, true));
                }
            });
        } else {
            for (Mob werewolf : werewolves) {
                if (!(werewolf instanceof IVillagerTransformable)) continue;
                ((IVillagerTransformable)werewolf).transformBack();
                ((IVillagerTransformable)werewolf).setWerewolfFaction(false);
            }
        }
    }

    @SubscribeEvent
    public void onVillageSpawnNewVillager(VampirismVillageEvent.SpawnNewVillager event) {
        if (event.getControllingFaction() == WReference.WEREWOLF_FACTION && event.getNewVillager().m_217043_().m_188503_(6) == 0) {
            ((IVillagerTransformable)event.getNewVillager()).setWerewolfFaction(true);
        }
    }

    @SubscribeEvent
    public void onVillageMakeAggressive(VampirismVillageEvent.MakeAggressive event) {
        if (event.getControllingFaction() == WReference.WEREWOLF_FACTION && ((IVillagerTransformable)event.getOldVillager()).canTransform()) {
            event.setCanceled(true);
            ((IVillagerTransformable)event.getOldVillager()).transformToWerewolf(TransformType.RAID);
        }
    }

    private void spawnEntity(Level world, Mob newEntity, Mob oldEntity, boolean replaceOld) {
        newEntity.m_20361_((Entity)oldEntity);
        newEntity.m_20084_(Mth.m_14002_());
        if (replaceOld) {
            oldEntity.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        world.m_7967_((Entity)newEntity);
    }

    private Optional<Mob> getCaptureEntity(IFaction<?> faction, Level world) {
        List entries = faction.getVillageData().getCaptureEntries();
        return WeightedRandom.m_216822_((RandomSource)world.m_213780_(), (List)entries).map(entry -> (Mob)entry.getEntity().m_20615_(world));
    }
}

