/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.gui;

import de.teamlapen.vampirism.client.gui.screens.MinionStatsScreen;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import de.teamlapen.werewolves.entities.minion.WerewolfMinionEntity;
import java.text.DecimalFormat;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class WerewolfMinionStatsScreen
extends MinionStatsScreen<WerewolfMinionEntity.WerewolfMinionData, WerewolfMinionEntity> {
    private final MutableComponent inventoryLevel = Component.m_237115_((String)"text.vampirism.minion.stats.inventory_level");
    private final MutableComponent healthLevel = Component.m_237115_((String)Attributes.f_22276_.m_22087_());
    private final MutableComponent strengthLevel = Component.m_237115_((String)Attributes.f_22281_.m_22087_());
    private final MutableComponent resourceLevel = Component.m_237115_((String)"text.vampirism.minion.stats.resource_level");

    public WerewolfMinionStatsScreen(WerewolfMinionEntity entity, @Nullable Screen backScreen) {
        super((MinionEntity)entity, 4, backScreen);
    }

    protected boolean areButtonsVisible(WerewolfMinionEntity.WerewolfMinionData data) {
        return data.getRemainingStatPoints() > 0 || data.getLevel() < 6;
    }

    protected int getRemainingStatPoints(WerewolfMinionEntity.WerewolfMinionData data) {
        return data.getRemainingStatPoints();
    }

    protected boolean isActive(WerewolfMinionEntity.WerewolfMinionData data, int i) {
        return switch (i) {
            case 0 -> {
                if (data.getRemainingStatPoints() > 0 && data.getInventoryLevel() < 2) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (data.getRemainingStatPoints() > 0 && data.getHealthLevel() < 3) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (data.getRemainingStatPoints() > 0 && data.getStrengthLevel() < 3) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (data.getRemainingStatPoints() > 0 && data.getResourceEfficiencyLevel() < 2) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    protected void renderStats(GuiGraphics graphics, WerewolfMinionEntity.WerewolfMinionData data) {
        DecimalFormat df = new DecimalFormat("0.##");
        this.renderLevelRow(graphics, data.getLevel() + 1, 7);
        this.renderStatRow(graphics, 0, this.inventoryLevel, (Component)Component.m_237113_((String)String.valueOf(data.getInventorySize())), data.getInventoryLevel() + 1, 3);
        this.renderStatRow(graphics, 1, this.healthLevel, (Component)Component.m_237113_((String)df.format(((WerewolfMinionEntity)this.entity).m_21051_(Attributes.f_22276_).m_22115_())), data.getHealthLevel() + 1, 4);
        this.renderStatRow(graphics, 2, this.strengthLevel, (Component)Component.m_237113_((String)df.format(((WerewolfMinionEntity)this.entity).m_21051_(Attributes.f_22281_).m_22115_())), data.getStrengthLevel() + 1, 4);
        this.renderStatRow(graphics, 3, this.resourceLevel, (Component)Component.m_237113_((String)String.format("%d%%", (int)Math.ceil((float)(data.getResourceEfficiencyLevel() + 1) / 3.0f * 100.0f))), data.getResourceEfficiencyLevel() + 1, 3);
    }
}

