/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.blocks;

import de.teamlapen.werewolves.blocks.entity.StoneAltarBlockEntity;
import de.teamlapen.werewolves.core.ModTiles;
import de.teamlapen.werewolves.util.WUtils;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class StoneAltarBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    protected static final VoxelShape SHAPE = StoneAltarBlock.makeShape();
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty SOUL_FIRE = WUtils.SOUL_FIRE;
    public static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.f_61374_;
    public static final String REG_NAME = "stone_altar";

    public StoneAltarBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60955_().m_60953_(state -> (Boolean)state.m_61143_((Property)LIT) != false ? 14 : 0));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUL_FIRE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH)).m_61124_((Property)BlockStateProperties.f_61450_, (Comparable)Boolean.valueOf(false)));
    }

    protected static VoxelShape makeShape() {
        VoxelShape a = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)7.0, (double)13.0);
        VoxelShape b = Block.m_49796_((double)1.0, (double)7.0, (double)1.0, (double)15.0, (double)10.0, (double)15.0);
        return Shapes.m_83110_((VoxelShape)a, (VoxelShape)b);
    }

    @Nonnull
    public RenderShape m_7514_(@Nonnull BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_6810_(BlockState state, @Nonnull Level worldIn, @Nonnull BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            this.dropItems(worldIn, pos);
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    public boolean isBurning(BlockState state, BlockGetter world, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)LIT);
    }

    public boolean m_7361_(@Nonnull LevelAccessor world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull FluidState fluid) {
        if (super.m_7361_(world, pos, state, fluid)) {
            if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
                if (world.m_5776_()) {
                    for (int i = 0; i < 20; ++i) {
                        CampfireBlock.m_51251_((Level)((Level)world), (BlockPos)pos.m_6630_(1), (boolean)false, (boolean)true);
                    }
                } else {
                    ((StoneAltarBlockEntity)world.m_7702_(pos)).aboardRitual();
                }
            }
            return true;
        }
        return false;
    }

    public void m_6807_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState state2, boolean p_220082_5_) {
        super.m_6807_(state, world, pos, state2, p_220082_5_);
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue() && state2.m_60734_() == this && !((Boolean)state2.m_61143_((Property)LIT)).booleanValue()) {
            ((StoneAltarBlockEntity)world.m_7702_(pos)).startRitual(state);
        }
    }

    @Nonnull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, Level worldIn, @Nonnull BlockPos pos, Player player, @Nonnull InteractionHand handIn, @Nonnull BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(handIn);
        StoneAltarBlockEntity te = (StoneAltarBlockEntity)worldIn.m_7702_(pos);
        if (!worldIn.f_46443_ && te != null) {
            StoneAltarBlockEntity.Result result = te.canActivate(player);
            if (!((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
                switch (result) {
                    case OTHER_FACTION: {
                        player.m_5661_((Component)Component.m_237115_((String)"text.werewolves.stone_altar.wrong_faction"), true);
                        return InteractionResult.CONSUME;
                    }
                    case IS_RUNNING: {
                        player.m_5661_((Component)Component.m_237115_((String)"text.werewolves.stone_altar.ritual_still_running"), true);
                        return InteractionResult.CONSUME;
                    }
                }
                switch (result) {
                    case NIGHT_ONLY: {
                        player.m_5661_((Component)Component.m_237115_((String)"text.werewolves.stone_altar.ritual_night_only"), true);
                        return InteractionResult.CONSUME;
                    }
                    case WRONG_LEVEL: {
                        player.m_5661_((Component)Component.m_237115_((String)"text.werewolves.stone_altar.ritual_wrong_level"), true);
                        return InteractionResult.CONSUME;
                    }
                    case STRUCTURE_LESS: {
                        player.m_5661_((Component)Component.m_237115_((String)"text.werewolves.stone_altar.ritual_structures_missing"), true);
                        return InteractionResult.CONSUME;
                    }
                    case STRUCTURE_LIT: {
                        player.m_5661_((Component)Component.m_237115_((String)"text.werewolves.stone_altar.ritual_less_lit_structures"), true);
                        return InteractionResult.CONSUME;
                    }
                    case TO_LESS_BLOOD: {
                        player.m_5661_((Component)Component.m_237115_((String)"text.werewolves.stone_altar.ritual_to_less_prey"), true);
                        return InteractionResult.CONSUME;
                    }
                    case INV_MISSING: {
                        Map<Item, Integer> missing = te.getMissingItems();
                        MutableComponent s = Component.m_237115_((String)"text.werewolves.stone_altar.ritual_missing_items");
                        missing.forEach((item, integer) -> s.m_130946_(" ").m_7220_((Component)Component.m_237115_((String)item.m_5524_()).m_130938_(style -> style.m_131140_(ChatFormatting.AQUA).m_131144_(new HoverEvent(HoverEvent.Action.f_130832_, (Object)new HoverEvent.ItemStackInfo(new ItemStack((ItemLike)item, integer.intValue())))))).m_130946_(" " + integer));
                        player.m_5661_((Component)s, true);
                        player.m_5893_((MenuProvider)te);
                        break;
                    }
                    case OK: {
                        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
                            player.m_5661_((Component)Component.m_237115_((String)"text.werewolves.stone_altar.can_not_burn"), true);
                            player.m_5893_((MenuProvider)te);
                            return InteractionResult.CONSUME;
                        }
                        te.setPlayer(player);
                        if (heldItem.m_41720_() == Items.f_42000_ || heldItem.m_41720_() == Items.f_42053_) {
                            worldIn.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true))).m_61124_((Property)SOUL_FIRE, (Comparable)Boolean.valueOf(heldItem.m_41720_() == Items.f_42053_)), 5);
                            return InteractionResult.CONSUME;
                        }
                        if (heldItem.m_41619_()) {
                            player.m_5893_((MenuProvider)te);
                            return InteractionResult.CONSUME;
                        }
                        player.m_5661_((Component)Component.m_237115_((String)"text.werewolves.stone_altar.empty_hand"), true);
                        return InteractionResult.PASS;
                    }
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return ((BlockEntityType)ModTiles.STONE_ALTAR.get()).m_155264_(pos, state);
    }

    private void dropItems(Level world, BlockPos pos) {
        Random rand = new Random();
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity instanceof Container) {
            Container inventory = (Container)tileEntity;
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                ItemStack item = inventory.m_8020_(i);
                if (item.m_41619_()) continue;
                float rx = rand.nextFloat() * 0.8f + 0.1f;
                float ry = rand.nextFloat() * 0.8f + 0.1f;
                float rz = rand.nextFloat() * 0.8f + 0.1f;
                ItemEntity entityItem = new ItemEntity(world, (double)((float)pos.m_123341_() + rx), (double)((float)pos.m_123342_() + ry), (double)((float)pos.m_123343_() + rz), item.m_41777_());
                if (item.m_41782_()) {
                    entityItem.m_32055_().m_41751_(item.m_41783_().m_6426_());
                }
                float factor = 0.05f;
                entityItem.m_20334_(rand.nextGaussian() * (double)factor, rand.nextGaussian() * (double)factor + (double)0.2f, rand.nextGaussian() * (double)factor);
                world.m_7967_((Entity)entityItem);
                inventory.m_6836_(i, ItemStack.f_41583_);
            }
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIT}).m_61104_(new Property[]{WATERLOGGED}).m_61104_(new Property[]{SOUL_FIRE}).m_61104_(new Property[]{HORIZONTAL_FACING}).m_61104_(new Property[]{BlockStateProperties.f_61450_});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)HORIZONTAL_FACING, (Comparable)context.m_8125_());
    }

    @Nonnull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)HORIZONTAL_FACING)));
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)HORIZONTAL_FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)HORIZONTAL_FACING)));
    }

    public void m_214162_(BlockState stateIn, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull RandomSource rand) {
        if (((Boolean)stateIn.m_61143_((Property)LIT)).booleanValue()) {
            Vector3f offset = this.getTorchOffset(stateIn);
            worldIn.m_7106_((ParticleOptions)((Boolean)stateIn.m_61143_((Property)SOUL_FIRE) != false ? ParticleTypes.f_123745_ : ParticleTypes.f_123744_), (double)((float)pos.m_123341_() + offset.x()), (double)((float)pos.m_123342_() + offset.y()), (double)((float)pos.m_123343_() + offset.z()), 0.0, 0.0, 0.0);
        }
    }

    private Vector3f getTorchOffset(BlockState stateIn) {
        Vector3f vec = new Vector3f(0.5f, 0.9625f, 0.5f);
        switch ((Direction)stateIn.m_61143_((Property)HORIZONTAL_FACING)) {
            case EAST: {
                vec.add((Vector3fc)new Vector3f(0.28125f, 0.0f, 0.28125f));
                break;
            }
            case SOUTH: {
                vec.add((Vector3fc)new Vector3f(-0.28125f, 0.0f, 0.28125f));
                break;
            }
            case WEST: {
                vec.add((Vector3fc)new Vector3f(-0.28125f, 0.0f, -0.28125f));
                break;
            }
            default: {
                vec.add((Vector3fc)new Vector3f(0.28125f, 0.0f, -0.28125f));
            }
        }
        return vec;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        return StoneAltarBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModTiles.STONE_ALTAR.get()), StoneAltarBlockEntity::tick);
    }
}

