/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.api.entities.werewolf;

import de.teamlapen.vampirism.api.entity.EntityClassType;
import de.teamlapen.vampirism.api.entity.actions.EntityActionTier;
import de.teamlapen.werewolves.api.entities.werewolf.IWerewolfDataholder;
import de.teamlapen.werewolves.api.entities.werewolf.TransformType;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;

public interface WerewolfTransformable
extends IWerewolfDataholder {
    public static final int TYPES = 126;

    public static <T extends Mob> T copyData(EntityType<T> newEntity, Mob oldEntity) {
        return (T)WerewolfTransformable.copyData((Mob)newEntity.m_20615_(oldEntity.m_20193_()), oldEntity);
    }

    public static <T extends Mob> T copyData(T entity, Mob oldEntity) {
        UUID uuid = entity.m_20148_();
        entity.m_20359_((Entity)oldEntity);
        entity.m_20361_((Entity)oldEntity);
        entity.m_20084_(uuid);
        entity.m_20193_().m_7967_(entity);
        oldEntity.m_142687_(Entity.RemovalReason.DISCARDED);
        entity.m_21153_(oldEntity.m_21223_() / oldEntity.m_21233_() * entity.m_21233_());
        return entity;
    }

    default public WerewolfTransformable transformBack() {
        WerewolfTransformable transformable = this._transformBack();
        transformable.reset();
        return transformable;
    }

    default public WerewolfTransformable transformToWerewolf(TransformType type) {
        WerewolfTransformable transformable = this._transformToWerewolf();
        transformable.start(type);
        return transformable;
    }

    public boolean canTransform();

    @Override
    @Nonnull
    public WerewolfForm getForm();

    public EntityClassType getEntityClass();

    public EntityActionTier getEntityTier();

    default public void reset() {
    }

    default public void start(TransformType type) {
    }

    public WerewolfTransformable _transformToWerewolf();

    public WerewolfTransformable _transformBack();
}

