/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.entity.youkai;

import dev.xkmc.fastprojectileapi.entity.SimplifiedProjectile;
import dev.xkmc.fastprojectileapi.spellcircle.SpellCircleHolder;
import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.l2serial.serialization.codec.TagCodec;
import dev.xkmc.l2serial.util.Wrappers;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.IYHDanmaku;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.ItemDanmakuEntity;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.ItemLaserEntity;
import dev.xkmc.youkaishomecoming.content.entity.youkai.SyncedData;
import dev.xkmc.youkaishomecoming.content.entity.youkai.YoukaiTargetContainer;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.CardHolder;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.SpellCardWrapper;
import dev.xkmc.youkaishomecoming.events.YoukaiFightEvent;
import dev.xkmc.youkaishomecoming.init.data.YHDamageTypes;
import dev.xkmc.youkaishomecoming.init.data.YHModConfig;
import dev.xkmc.youkaishomecoming.init.data.YHTagGen;
import dev.xkmc.youkaishomecoming.init.registrate.YHDanmaku;
import dev.xkmc.youkaishomecoming.init.registrate.YHEffects;
import dev.xkmc.youkaishomecoming.init.registrate.YHEntities;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;

@SerialClass
public abstract class YoukaiEntity
extends PathfinderMob
implements SpellCircleHolder,
CardHolder {
    private static final int GROUND_HEIGHT = 5;
    private static final int ATTEMPT_ABOVE = 3;
    protected static final SyncedData YOUKAI_DATA = new SyncedData(YoukaiEntity::defineId);
    protected static final EntityDataAccessor<Integer> DATA_FLAGS_ID = YOUKAI_DATA.define(SyncedData.INT, 0, "youkai_flags");
    public final MoveControl walkCtrl;
    public final MoveControl flyCtrl;
    public final PathNavigation walkNav;
    public final PathNavigation fltNav;
    @SerialClass.SerialField
    public final YoukaiTargetContainer targets;
    @SerialClass.SerialField
    public SpellCardWrapper spellCard;

    private static <T> EntityDataAccessor<T> defineId(EntityDataSerializer<T> ser) {
        return SynchedEntityData.m_135353_(YoukaiEntity.class, ser);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22280_, 0.4).m_22268_(Attributes.f_22277_, 48.0);
    }

    public YoukaiEntity(EntityType<? extends YoukaiEntity> pEntityType, Level pLevel) {
        this(pEntityType, pLevel, 10);
    }

    public YoukaiEntity(EntityType<? extends YoukaiEntity> pEntityType, Level pLevel, int maxSize) {
        super(pEntityType, pLevel);
        this.walkCtrl = this.f_21342_;
        this.walkNav = this.f_21344_;
        this.flyCtrl = new FlyingMoveControl((Mob)this, 10, false);
        this.fltNav = new FlyingPathNavigation((Mob)this, this.m_9236_());
        this.targets = new YoukaiTargetContainer(this, maxSize);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_271165_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_271165_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_271165_;
    }

    public boolean m_6573_(Player pPlayer) {
        return false;
    }

    protected SyncedData data() {
        return YOUKAI_DATA;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.data().register(this.f_19804_);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Age", this.f_19797_);
        tag.m_128365_("auto-serial", (Tag)Objects.requireNonNull(TagCodec.toTag((CompoundTag)new CompoundTag(), (Object)this)));
        this.data().write(tag, this.f_19804_);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19797_ = tag.m_128451_("Age");
        if (tag.m_128441_("auto-serial")) {
            Wrappers.run(() -> TagCodec.fromTag((CompoundTag)tag.m_128469_("auto-serial"), this.getClass(), (Object)this, f -> true));
        }
        this.data().read(tag, this.f_19804_);
        if (this.m_5448_() == null) {
            this.setWalking();
        }
    }

    public boolean getFlag(int flag) {
        return ((Integer)this.f_19804_.m_135370_(DATA_FLAGS_ID) & flag) != 0;
    }

    public void setFlag(int flag, boolean enable) {
        int b0 = (Integer)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        b0 = enable ? (int)((byte)(b0 | flag)) : (int)((byte)(b0 & -1 - flag));
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)b0);
    }

    public boolean shouldIgnore(LivingEntity e) {
        if (e.m_6095_().m_204039_(YHTagGen.YOUKAI_IGNORE)) {
            return true;
        }
        YoukaiFightEvent event = new YoukaiFightEvent(this, e);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public boolean m_6673_(DamageSource pSource) {
        LivingEntity le;
        Entity entity = pSource.m_7639_();
        if (entity instanceof LivingEntity && this.shouldIgnore(le = (LivingEntity)entity)) {
            return true;
        }
        return pSource.m_269533_(DamageTypeTags.f_268549_);
    }

    protected boolean m_7341_(Entity pVehicle) {
        return false;
    }

    protected boolean m_8028_() {
        return false;
    }

    @Override
    public Vec3 center() {
        return this.m_20182_().m_82520_(0.0, (double)(this.m_20206_() / 2.0f), 0.0);
    }

    @Override
    public Vec3 forward() {
        Vec3 target = this.target();
        if (target != null) {
            return target.m_82546_(this.center()).m_82541_();
        }
        return this.m_20156_();
    }

    @Override
    @Nullable
    public Vec3 target() {
        LivingEntity le = this.m_5448_();
        if (le == null) {
            return null;
        }
        return le.m_20182_().m_82520_(0.0, (double)(le.m_20206_() / 2.0f), 0.0);
    }

    @Override
    @Nullable
    public Vec3 targetVelocity() {
        LivingEntity le = this.m_5448_();
        if (le == null) {
            return null;
        }
        return le.m_20184_();
    }

    @Override
    public RandomSource random() {
        return this.f_19796_;
    }

    @Override
    public ItemDanmakuEntity prepareDanmaku(int life, Vec3 vec, YHDanmaku.Bullet type, DyeColor color) {
        ItemDanmakuEntity danmaku = new ItemDanmakuEntity((EntityType<? extends ItemDanmakuEntity>)((EntityType)YHEntities.ITEM_DANMAKU.get()), (LivingEntity)this, this.m_9236_());
        danmaku.m_146884_(this.center());
        danmaku.setItem(type.get(color).asStack());
        danmaku.setup((float)this.m_21133_(Attributes.f_22281_), life, true, true, vec);
        return danmaku;
    }

    @Override
    public ItemLaserEntity prepareLaser(int life, Vec3 pos, Vec3 vec, int len, YHDanmaku.Laser type, DyeColor color) {
        ItemLaserEntity danmaku = new ItemLaserEntity((EntityType<? extends ItemLaserEntity>)((EntityType)YHEntities.ITEM_LASER.get()), (LivingEntity)this, this.m_9236_());
        danmaku.setItem(type.get(color).asStack());
        danmaku.setup((float)this.m_21133_(Attributes.f_22281_), life, len, true, vec);
        danmaku.m_146884_(pos);
        return danmaku;
    }

    @Override
    public void shoot(SimplifiedProjectile danmaku) {
        this.m_9236_().m_7967_((Entity)danmaku);
    }

    public void shoot(float dmg, int life, Vec3 vec, DyeColor color) {
        ItemDanmakuEntity danmaku = new ItemDanmakuEntity((EntityType<? extends ItemDanmakuEntity>)((EntityType)YHEntities.ITEM_DANMAKU.get()), (LivingEntity)this, this.m_9236_());
        danmaku.setItem(YHDanmaku.Bullet.CIRCLE.get(color).asStack());
        danmaku.setup(dmg, life, true, true, vec);
        this.m_9236_().m_7967_((Entity)danmaku);
    }

    public void onDanmakuHit(LivingEntity e, IYHDanmaku danmaku) {
        if (e instanceof YoukaiEntity || e.m_21023_((MobEffect)YHEffects.YOUKAIFIED.get())) {
            return;
        }
        if (this.targets.contains(e)) {
            double heal = (Double)YHModConfig.COMMON.danmakuHealOnHitTarget.get();
            this.m_5634_(this.m_21233_() * (float)heal);
        }
    }

    public final void setFlying() {
        this.m_20242_(true);
        if (this.f_21342_ == this.flyCtrl) {
            return;
        }
        this.m_21573_().m_26573_();
        this.f_21342_ = this.flyCtrl;
        this.f_21344_ = this.fltNav;
    }

    public final void setWalking() {
        this.m_20242_(false);
        if (this.f_21342_ == this.walkCtrl) {
            return;
        }
        this.m_21573_().m_26573_();
        this.m_21567_(0.0f);
        this.m_21570_(0.0f);
        this.m_21564_(0.0f);
        this.f_21342_ = this.walkCtrl;
        this.f_21344_ = this.walkNav;
    }

    public final boolean isFlying() {
        return this.f_21342_ == this.flyCtrl;
    }

    public void m_8107_() {
        if (!this.m_9236_().m_5776_()) {
            if (!this.m_20096_() && this.m_20184_().f_82480_ < 0.0) {
                double fall = this.m_5912_() ? 0.6 : 0.8;
                this.m_20256_(this.m_20184_().m_82542_(1.0, fall, 1.0));
            }
            this.targets.tick();
            if (this.spellCard != null) {
                if (this.m_5912_() && this.shouldShowSpellCircle()) {
                    this.spellCard.tick(this);
                } else {
                    this.spellCard.reset();
                }
            }
        }
        super.m_8107_();
    }

    protected void m_6475_(DamageSource source, float amount) {
        if (this.spellCard != null) {
            this.spellCard.hurt(this, source, amount);
        }
        this.actuallyHurtImpl(source, amount);
    }

    protected final void actuallyHurtImpl(DamageSource source, float amount) {
        if (!this.m_6673_(source)) {
            if ((amount = ForgeHooks.onLivingHurt((LivingEntity)this, (DamageSource)source, (float)amount)) <= 0.0f) {
                return;
            }
            amount = this.m_21161_(source, amount);
            amount = this.m_6515_(source, amount);
            amount = ForgeHooks.onLivingDamage((LivingEntity)this, (DamageSource)source, (float)amount);
            this.hurtFinal(source, amount);
        }
    }

    protected void hurtFinal(DamageSource source, float amount) {
        Entity entity;
        float f1 = Math.max(amount - this.m_6103_(), 0.0f);
        float f = amount - f1;
        this.m_7911_(this.m_6103_() - f);
        if (f > 0.0f && f < 3.4028235E37f && (entity = source.m_7639_()) instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)entity;
            serverplayer.m_36222_(Stats.f_12929_, Math.round(f * 10.0f));
        }
        if (f1 != 0.0f) {
            this.m_21231_().m_289194_(source, f1);
            this.hurtFinalImpl(source, this.m_21223_() - f1);
            this.m_7911_(this.m_6103_() - f1);
            this.m_146850_(GameEvent.f_223706_);
        }
    }

    protected void hurtFinalImpl(DamageSource source, float amount) {
        super.m_21153_(amount);
    }

    protected void m_8024_() {
        LivingEntity target = this.m_5448_();
        if (target != null && this.m_6779_(target) && this.f_21342_ == this.flyCtrl) {
            boolean tooHigh = this.tooHigh();
            int expectedHeight = tooHigh ? 0 : 3;
            double low = -0.5;
            double high = tooHigh ? 0.0 : 0.5;
            double diff = target.m_20188_() + (double)expectedHeight - this.m_20188_();
            Vec3 vec3 = this.m_20184_();
            double moveY = vec3.f_82480_ * 0.5 + diff * 0.02;
            if (this.m_20188_() < target.m_20188_() + (double)expectedHeight + low) {
                this.setY(Math.max(vec3.f_82480_, moveY));
            }
            if (this.m_20188_() > target.m_20188_() + (double)expectedHeight + high) {
                if (diff < -1.0) {
                    this.setY(Math.min(vec3.f_82480_, moveY));
                } else if (tooHigh) {
                    this.setY(Math.min(vec3.f_82480_, -0.01));
                }
            }
        }
        super.m_8024_();
    }

    private void setY(double vy) {
        Vec3 vec3 = this.m_20184_();
        this.m_20334_(vec3.f_82479_, vy, vec3.f_82481_);
        if (vy > 0.0 && this.m_20096_()) {
            this.f_19812_ = true;
        }
    }

    private boolean tooHigh() {
        BlockPos pos = this.m_20097_();
        for (int i = 0; i < 5; ++i) {
            BlockPos off = pos.m_7918_(0, -i, 0);
            if (this.m_9236_().m_8055_(off).m_60795_()) continue;
            return false;
        }
        return true;
    }

    public boolean shouldHurt(LivingEntity le) {
        return this.targets.contains(le);
    }

    @Override
    public LivingEntity self() {
        return super.self();
    }

    @Override
    public DamageSource getDanmakuDamageSource(IYHDanmaku danmaku) {
        if (this.spellCard != null) {
            return this.spellCard.card.getDanmakuDamageSource(danmaku);
        }
        return YHDamageTypes.danmaku(danmaku);
    }
}

