/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.entity.danmaku;

import dev.xkmc.fastprojectileapi.collision.LaserHitHelper;
import dev.xkmc.fastprojectileapi.entity.BaseLaser;
import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.l2serial.serialization.codec.PacketCodec;
import dev.xkmc.l2serial.serialization.codec.TagCodec;
import dev.xkmc.l2serial.util.Wrappers;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.IYHDanmaku;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;

@SerialClass
public class YHBaseLaserEntity
extends BaseLaser
implements IEntityAdditionalSpawnData,
IYHDanmaku {
    @SerialClass.SerialField
    private int life = 0;
    @SerialClass.SerialField
    private int prepare;
    @SerialClass.SerialField
    private int start;
    @SerialClass.SerialField
    private int end;
    @SerialClass.SerialField
    private boolean bypassWall = false;
    @SerialClass.SerialField
    public float damage = 0.0f;
    @SerialClass.SerialField
    public float length = 0.0f;
    public double earlyTerminate = -1.0;

    protected YHBaseLaserEntity(EntityType<? extends YHBaseLaserEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected YHBaseLaserEntity(EntityType<? extends YHBaseLaserEntity> pEntityType, double pX, double pY, double pZ, Level pLevel) {
        this(pEntityType, pLevel);
        this.m_6034_(pX, pY, pZ);
    }

    protected YHBaseLaserEntity(EntityType<? extends YHBaseLaserEntity> pEntityType, LivingEntity pShooter, Level pLevel) {
        this(pEntityType, pShooter.m_20185_(), pShooter.m_20188_() - (double)0.1f, pShooter.m_20189_(), pLevel);
        this.setOwner((Entity)pShooter);
    }

    public void setup(float damage, int life, float length, boolean bypassWall, Vec3 vec3) {
        double d0 = vec3.m_165924_();
        this.setup(damage, life, length, bypassWall, (float)(-Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875), (float)(-Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.2957763671875));
    }

    public void setupTime(int prepare, int start, int life, int end) {
        this.prepare = prepare;
        this.start = this.prepare + start;
        this.end = this.start + life;
        this.life = this.end + end;
    }

    public void setup(float damage, int life, float length, boolean bypassWall, float rY, float rX) {
        this.damage = damage;
        this.bypassWall = bypassWall;
        this.length = length;
        this.setupTime(20, 20, life, 20);
        this.m_146922_(rY);
        this.m_146926_(rX);
    }

    @Override
    public double getLength() {
        return this.length;
    }

    @Override
    public boolean checkBlockHit() {
        return !this.bypassWall;
    }

    @Override
    public float getEffectiveHitRadius() {
        return this.m_20205_() / 4.0f;
    }

    @Override
    public boolean checkEntityHit() {
        return this.f_19797_ > this.start && this.f_19797_ < this.end;
    }

    @Override
    public float damage(Entity target) {
        return this.damage;
    }

    public float percentOpen(float pTick) {
        if ((pTick += (float)this.f_19797_) < (float)this.prepare) {
            return 0.1f;
        }
        if (pTick < (float)this.start) {
            return (pTick - (float)this.prepare) / (float)(this.start - this.prepare) * 0.9f + 0.1f;
        }
        if (pTick < (float)this.end) {
            return 1.0f;
        }
        if (pTick < (float)this.life) {
            return (pTick - (float)this.end) / (float)(this.life - this.end) * -0.9f + 1.0f;
        }
        return 0.0f;
    }

    public float effectiveLength() {
        return (float)(this.earlyTerminate >= 0.0 ? this.earlyTerminate : (double)this.length);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.danmakuMove();
        if (!this.m_9236_().m_5776_() && this.f_19797_ > this.life) {
            this.m_146870_();
        }
    }

    protected void danmakuMove() {
    }

    @Override
    public boolean canHitEntity(Entity target) {
        return super.canHitEntity(target) && this.shouldHurt(this.m_19749_(), target);
    }

    @Override
    protected void onHit(LaserHitHelper.LaserHitResult hit) {
        if (this.m_9236_().m_5776_()) {
            this.earlyTerminate = hit.bhit() != null && hit.bhit().m_6662_() != HitResult.Type.MISS ? this.m_20182_().m_82520_(0.0, (double)(this.m_20206_() / 2.0f), 0.0).m_82554_(hit.bhit().m_82450_()) : -1.0;
        }
        for (EntityHitResult e : hit.ehit()) {
            this.hurtTarget(e);
        }
    }

    public AABB m_6921_() {
        Vec3 src = this.m_20182_().m_82520_(0.0, (double)(this.m_20206_() / 2.0f), 0.0);
        return new AABB(src, src.m_82549_(this.m_20156_().m_82490_((double)this.length))).m_82400_((double)(this.m_20205_() / 2.0f));
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128365_("auto-serial", (Tag)Objects.requireNonNull(TagCodec.toTag((CompoundTag)new CompoundTag(), (Object)this)));
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("auto-serial")) {
            Wrappers.run(() -> TagCodec.fromTag((CompoundTag)nbt.m_128469_("auto-serial"), this.getClass(), (Object)this, f -> true));
        }
    }

    @Override
    public void writeSpawnData(FriendlyByteBuf buffer) {
        super.writeSpawnData(buffer);
        PacketCodec.to((FriendlyByteBuf)buffer, (Object)this);
    }

    @Override
    public void readSpawnData(FriendlyByteBuf additionalData) {
        super.readSpawnData(additionalData);
        PacketCodec.from((FriendlyByteBuf)additionalData, this.getClass(), (Object)((YHBaseLaserEntity)Wrappers.cast((Object)this)));
    }
}

