/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.entity.boss;

import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.entity.youkai.GeneralYoukaiEntity;
import dev.xkmc.youkaishomecoming.content.entity.youkai.YoukaiEntity;
import dev.xkmc.youkaishomecoming.init.data.YHDamageTypes;
import dev.xkmc.youkaishomecoming.init.data.YHModConfig;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

@SerialClass
public class BossYoukaiEntity
extends GeneralYoukaiEntity {
    protected final ServerBossEvent bossEvent = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.NOTCHED_20);
    private int hurtCD = 0;
    private boolean hurtCall = false;
    @SerialClass.SerialField
    protected int noTargetTime;

    public static AttributeSupplier.Builder createAttributes() {
        return YoukaiEntity.createAttributes().m_22268_(Attributes.f_22276_, 200.0).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22277_, 128.0);
    }

    public BossYoukaiEntity(EntityType<? extends BossYoukaiEntity> pEntityType, Level pLevel) {
        super((EntityType<? extends GeneralYoukaiEntity>)pEntityType, pLevel);
    }

    public boolean m_7301_(MobEffectInstance ins) {
        return false;
    }

    @Override
    public void m_8107_() {
        if (this.hurtCD < 1000) {
            ++this.hurtCD;
        }
        super.m_8107_();
        if (!this.m_21221_().isEmpty()) {
            this.m_21219_();
        }
    }

    private int getCD(DamageSource source) {
        if (!((Boolean)YHModConfig.COMMON.reimuExtraDamageCoolDown.get()).booleanValue()) {
            return 10;
        }
        if (source.m_269533_(DamageTypeTags.f_268738_)) {
            return 10;
        }
        if (source.m_276093_(YHDamageTypes.DANMAKU)) {
            return 20;
        }
        if (source.m_269533_(DamageTypeTags.f_273918_)) {
            return 40;
        }
        return 80;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!source.m_276093_(DamageTypes.f_286979_) || source.m_7639_() != null) {
            LivingEntity le;
            if (!source.m_269533_(DamageTypeTags.f_268738_) && !(source.m_7639_() instanceof LivingEntity)) {
                return false;
            }
            Entity entity = source.m_7639_();
            if (entity instanceof LivingEntity && this.shouldIgnore(le = (LivingEntity)entity)) {
                return false;
            }
            int cd = this.getCD(source);
            if (this.hurtCD < cd) {
                return false;
            }
        }
        this.hurtCD = 0;
        this.hurtCall = true;
        boolean ans = super.m_6469_(source, amount);
        this.hurtCall = false;
        return ans;
    }

    public boolean canSwimInFluidType(FluidType type) {
        return true;
    }

    public boolean m_5825_() {
        return true;
    }

    protected float clampDamage(DamageSource source, float amount) {
        if (!this.hurtCall) {
            return 0.0f;
        }
        if (source.m_269533_(DamageTypeTags.f_268738_)) {
            Entity entity = source.m_7639_();
            if (entity instanceof LivingEntity) {
                ServerPlayer sp;
                LivingEntity le = (LivingEntity)entity;
                if (le instanceof ServerPlayer && (sp = (ServerPlayer)le).m_7500_()) {
                    return amount;
                }
            } else {
                if (source.m_276093_(DamageTypes.f_268724_)) {
                    return Math.min(4.0f, amount);
                }
                if (source.m_276093_(DamageTypes.f_286979_)) {
                    return amount;
                }
            }
        }
        int reduction = 20;
        amount = Math.min(this.m_21233_() / (float)reduction, amount);
        if (((Boolean)YHModConfig.COMMON.reimuDamageReduction.get()).booleanValue() && !source.m_269533_(YHDamageTypes.DANMAKU_TYPE)) {
            amount /= 5.0f;
        }
        return amount;
    }

    @Override
    protected final void m_6475_(DamageSource source, float amount) {
        if (!this.hurtCall) {
            return;
        }
        super.m_6475_(source, amount);
    }

    @Override
    protected void hurtFinal(DamageSource source, float amount) {
        amount = this.clampDamage(source, amount);
        super.hurtFinal(source, amount);
    }

    public void m_21153_(float val) {
        if (this.m_9236_().m_5776_()) {
            super.m_21153_(val);
        }
        float health = this.m_21223_();
        if (this.f_19797_ > 5 && val <= health) {
            return;
        }
        super.m_21153_(val);
    }

    public void m_5634_(float original) {
        float heal = ForgeEventFactory.onLivingHeal((LivingEntity)this, (float)original);
        if ((heal = Math.max(original, heal)) <= 0.0f) {
            return;
        }
        float f = this.m_21223_();
        if (f > 0.0f) {
            this.m_21153_(f + heal);
        }
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
    }

    public void m_6593_(@Nullable Component pName) {
        super.m_6593_(pName);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        if (this.m_5448_() == null || !this.m_5448_().m_6084_()) {
            ++this.noTargetTime;
            if (this.noTargetTime >= 20 && this.f_19797_ % 20 == 0 && this.m_21223_() < this.m_21233_()) {
                this.m_21153_(this.m_21233_());
            }
        } else {
            this.noTargetTime = 0;
        }
    }

    public void m_6457_(ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        this.bossEvent.m_6543_(pPlayer);
    }

    public void m_6452_(ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        this.bossEvent.m_6539_(pPlayer);
    }
}

