/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.capability;

import dev.xkmc.l2library.capability.player.PlayerCapabilityHolder;
import dev.xkmc.l2library.capability.player.PlayerCapabilityNetworkHandler;
import dev.xkmc.l2library.capability.player.PlayerCapabilityTemplate;
import dev.xkmc.l2library.util.raytrace.RayTraceUtil;
import dev.xkmc.l2serial.network.SimplePacketBase;
import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.capability.ClientCapHandler;
import dev.xkmc.youkaishomecoming.content.capability.KoishiStartPacket;
import dev.xkmc.youkaishomecoming.init.YoukaisHomecoming;
import dev.xkmc.youkaishomecoming.init.data.YHAdvGen;
import dev.xkmc.youkaishomecoming.init.data.YHDamageTypes;
import dev.xkmc.youkaishomecoming.init.data.YHModConfig;
import dev.xkmc.youkaishomecoming.init.registrate.YHCriteriaTriggers;
import dev.xkmc.youkaishomecoming.init.registrate.YHEffects;
import dev.xkmc.youkaishomecoming.init.registrate.YHItems;
import net.minecraft.advancements.Advancement;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;

@SerialClass
public class KoishiAttackCapability
extends PlayerCapabilityTemplate<KoishiAttackCapability> {
    public static final Capability<KoishiAttackCapability> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<KoishiAttackCapability>(){});
    public static final PlayerCapabilityHolder<KoishiAttackCapability> HOLDER = new PlayerCapabilityHolder(YoukaisHomecoming.loc("koishi_attack"), CAPABILITY, KoishiAttackCapability.class, KoishiAttackCapability::new, PlayerCapabilityNetworkHandler::new);
    private static final int DELAY = 360;
    private static final int MARK_POS = 300;
    @SerialClass.SerialField
    private int tickRemain = 0;
    @SerialClass.SerialField
    private int attackCooldown = 0;
    @SerialClass.SerialField
    private int blockCount = 0;
    @SerialClass.SerialField
    private Vec3 source = null;

    public void onClone(boolean isWasDeath) {
        this.blockCount = 0;
        this.tickRemain = 0;
    }

    protected void startParticle(Vec3 pos) {
        this.tickRemain = 60;
        this.source = pos;
    }

    private boolean notValid() {
        return !this.player.m_9236_().m_46472_().equals((Object)Level.f_46429_) || !this.player.m_142066_() || this.player.m_21023_((MobEffect)YHEffects.UNCONSCIOUS.get()) || this.player.m_21023_((MobEffect)YHEffects.YOUKAIFIED.get()) || !this.player.m_21023_((MobEffect)YHEffects.YOUKAIFYING.get());
    }

    public void tick() {
        if (!((Boolean)YHModConfig.COMMON.koishiAttackEnable.get()).booleanValue()) {
            return;
        }
        Player player = this.player;
        if (!(player instanceof ServerPlayer)) {
            if (this.source != null && this.tickRemain > 0 && this.tickRemain <= 60) {
                ClientCapHandler.showParticle(this.player, this.source);
                --this.tickRemain;
                if (this.tickRemain == 0) {
                    this.source = null;
                }
            }
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        if (this.tickRemain > 0) {
            --this.tickRemain;
            if (this.tickRemain == 60) {
                this.source = RayTraceUtil.rayTraceBlock((Level)this.player.m_9236_(), (Player)this.player, (double)-2.0).m_82450_();
                YoukaisHomecoming.HANDLER.toClientPlayer((SimplePacketBase)new KoishiStartPacket(KoishiStartPacket.Type.PARTICLE, this.source), sp);
            }
            if (this.tickRemain == 0 && this.source != null) {
                this.attackCooldown = (Integer)YHModConfig.COMMON.koishiAttackCoolDown.get();
                if (!this.notValid()) {
                    float dmg = ((Integer)YHModConfig.COMMON.koishiAttackDamage.get()).intValue();
                    Advancement adv = sp.f_8924_.m_129889_().m_136041_(YHAdvGen.KOISHI_FIRST);
                    if (adv != null && !sp.m_8960_().m_135996_(adv).m_8193_()) {
                        YHCriteriaTriggers.KOISHI_FIRST.m_222618_(sp);
                        dmg = Math.min(dmg, this.player.m_21233_() - 1.0f);
                    }
                    if (this.player.m_6469_(YHDamageTypes.koishi((LivingEntity)this.player, this.source), dmg)) {
                        this.blockCount = 0;
                    }
                }
                this.source = null;
            }
            return;
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
            return;
        }
        if (this.notValid()) {
            return;
        }
        if (this.player.m_217043_().m_188500_() < (Double)YHModConfig.COMMON.koishiAttackChance.get()) {
            this.tickRemain = 360;
            YHCriteriaTriggers.KOISHI_RING.m_222618_(sp);
            YoukaisHomecoming.HANDLER.toClientPlayer((SimplePacketBase)new KoishiStartPacket(KoishiStartPacket.Type.START, this.player.m_20182_()), sp);
        }
    }

    public void onBlock() {
        this.player.m_36335_().m_41524_(this.player.m_21211_().m_41720_(), 100);
        ++this.blockCount;
        if (this.blockCount >= (Integer)YHModConfig.COMMON.koishiAttackBlockCount.get()) {
            this.blockCount = 0;
            this.player.m_19998_((ItemLike)YHItems.KOISHI_HAT.get());
        }
    }

    public static void register() {
    }
}

