/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.machines.oil_processing.pumpjack.hammer;

import com.drmangotea.tfmg.blocks.machines.oil_processing.pumpjack.base.PumpjackBaseBlockEntity;
import com.drmangotea.tfmg.blocks.machines.oil_processing.pumpjack.crank.PumpjackCrankBlockEntity;
import com.drmangotea.tfmg.blocks.machines.oil_processing.pumpjack.hammer.PumpjackBlock;
import com.drmangotea.tfmg.blocks.machines.oil_processing.pumpjack.hammer.PumpjackContraption;
import com.drmangotea.tfmg.blocks.machines.oil_processing.pumpjack.hammer.parts.PumpjackHammerConnectorBlock;
import com.drmangotea.tfmg.blocks.machines.oil_processing.pumpjack.hammer.parts.PumpjackHammerHeadBlock;
import com.drmangotea.tfmg.blocks.machines.oil_processing.pumpjack.hammer.parts.PumpjackHammerPartBlock;
import com.drmangotea.tfmg.blocks.machines.oil_processing.pumpjack.hammer.parts.large.LargePumpjackHammerConnectorBlock;
import com.drmangotea.tfmg.blocks.machines.oil_processing.pumpjack.hammer.parts.large.LargePumpjackHammerHeadBlock;
import com.drmangotea.tfmg.blocks.machines.oil_processing.pumpjack.hammer.parts.large.LargePumpjackHammerPartBlock;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.IControlContraption;
import com.simibubi.create.content.contraptions.IDisplayAssemblyExceptions;
import com.simibubi.create.content.contraptions.bearing.BearingBlock;
import com.simibubi.create.content.contraptions.bearing.IBearingBlockEntity;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.transmission.sequencer.SequencerInstructions;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;

public class PumpjackBlockEntity
extends GeneratingKineticBlockEntity
implements IBearingBlockEntity,
IDisplayAssemblyExceptions {
    protected ScrollOptionBehaviour<IControlContraption.RotationMode> movementMode;
    protected ControlledContraptionEntity movedContraption;
    protected float angle;
    protected boolean running;
    protected boolean assembleNextTick;
    protected float clientAngleDiff;
    protected AssemblyException lastException;
    protected double sequencedAngleLimit;
    private float prevAngle;
    public BlockPos headPosition = null;
    public BlockPos connectorPosition = null;
    public PumpjackCrankBlockEntity crank = null;
    public PumpjackBaseBlockEntity base = null;
    public int connectorDistance = 0;
    public int headDistance = 0;
    public boolean connectorAtFront = false;
    public boolean headAtFront = false;
    public int crankConnectorDistance = 0;
    public int headBaseDistance = 0;

    public PumpjackBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(3);
        this.sequencedAngleLimit = -1.0;
    }

    public boolean isWoodenTop() {
        return false;
    }

    protected boolean syncSequenceContext() {
        return true;
    }

    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().m_82400_(7.0);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.registerAwardables(behaviours, new CreateAdvancement[]{AllAdvancements.CONTRAPTION_ACTORS});
    }

    public void remove() {
        if (!this.f_58857_.f_46443_) {
            this.disassemble();
        }
        super.remove();
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        if (this.connectorPosition != null) {
            compound.m_128405_("connectorX", this.connectorPosition.m_123341_());
            compound.m_128405_("connectorY", this.connectorPosition.m_123342_());
            compound.m_128405_("connectorZ", this.connectorPosition.m_123343_());
        }
        if (this.headPosition != null) {
            compound.m_128405_("headX", this.headPosition.m_123341_());
            compound.m_128405_("headY", this.headPosition.m_123342_());
            compound.m_128405_("headZ", this.headPosition.m_123343_());
        }
        compound.m_128379_("connectorAtFront", this.connectorAtFront);
        compound.m_128379_("headAtFront", this.headAtFront);
        compound.m_128379_("Running", this.running);
        compound.m_128350_("Angle", this.angle);
        if (this.sequencedAngleLimit >= 0.0) {
            compound.m_128347_("SequencedAngleLimit", this.sequencedAngleLimit);
        }
        AssemblyException.write((CompoundTag)compound, (AssemblyException)this.lastException);
        super.write(compound, clientPacket);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        if (this.wasMoved) {
            super.read(compound, clientPacket);
            return;
        }
        this.connectorPosition = new BlockPos(compound.m_128451_("connectorX"), compound.m_128451_("connectorY"), compound.m_128451_("connectorZ"));
        this.headPosition = new BlockPos(compound.m_128451_("headX"), compound.m_128451_("headY"), compound.m_128451_("headZ"));
        this.connectorAtFront = compound.m_128471_("connectorAtFront");
        this.headAtFront = compound.m_128471_("headAtFront");
        float angleBefore = this.angle;
        this.running = compound.m_128471_("Running");
        this.angle = compound.m_128457_("Angle");
        this.sequencedAngleLimit = compound.m_128441_("SequencedAngleLimit") ? compound.m_128459_("SequencedAngleLimit") : -1.0;
        this.lastException = AssemblyException.read((CompoundTag)compound);
        super.read(compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (this.running) {
            if (this.movedContraption == null || !this.movedContraption.isStalled()) {
                this.clientAngleDiff = AngleHelper.getShortestAngleDiff((double)angleBefore, (double)this.angle);
                this.angle = angleBefore;
            }
        } else {
            this.movedContraption = null;
        }
    }

    public float getInterpolatedAngle(float partialTicks) {
        if (this.isVirtual()) {
            return Mth.m_14179_((float)(partialTicks + 0.5f), (float)this.prevAngle, (float)this.angle);
        }
        if (this.movedContraption == null || this.movedContraption.isStalled() || !this.running) {
            partialTicks = 0.0f;
        }
        float angularSpeed = this.getAngularSpeed();
        if (this.sequencedAngleLimit >= 0.0) {
            angularSpeed = (float)Mth.m_14008_((double)angularSpeed, (double)(-this.sequencedAngleLimit), (double)this.sequencedAngleLimit);
        }
        return Mth.m_14179_((float)partialTicks, (float)this.angle, (float)(this.angle + angularSpeed));
    }

    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        this.assembleNextTick = true;
        this.sequencedAngleLimit = -1.0;
        if (this.movedContraption != null && Math.signum(prevSpeed) != Math.signum(this.getSpeed()) && prevSpeed != 0.0f) {
            if (!this.movedContraption.isStalled()) {
                this.angle = Math.round(this.angle);
                this.applyRotation();
            }
            this.movedContraption.getContraption().stop(this.f_58857_);
        }
        if (this.sequenceContext != null && this.sequenceContext.instruction() == SequencerInstructions.TURN_ANGLE) {
            this.sequencedAngleLimit = this.sequenceContext.getEffectiveValue((double)this.getTheoreticalSpeed());
        }
    }

    public float getAngularSpeed() {
        float speed = PumpjackBlockEntity.convertToAngular((float)this.getSpeed());
        if (this.getSpeed() == 0.0f) {
            speed = 0.0f;
        }
        if (this.f_58857_.f_46443_) {
            speed *= ServerSpeedProvider.get();
            speed += this.clientAngleDiff / 3.0f;
        }
        return speed;
    }

    public AssemblyException getLastAssemblyException() {
        return this.lastException;
    }

    public BlockPos getBlockPosition() {
        return this.f_58858_;
    }

    public void assemble() {
        if (!(this.f_58857_.m_8055_(this.f_58858_).m_60734_() instanceof BearingBlock)) {
            return;
        }
        Direction direction = (Direction)this.m_58900_().m_61143_((Property)BearingBlock.FACING);
        PumpjackContraption contraption = new PumpjackContraption(direction);
        try {
            if (!contraption.assemble(this.f_58857_, this.f_58858_)) {
                return;
            }
            if (this.connectorPosition == null || this.headPosition == null) {
                return;
            }
            this.lastException = null;
        }
        catch (AssemblyException e) {
            this.lastException = e;
            this.sendData();
            return;
        }
        int q = 1;
        if (direction.m_122434_() == Direction.Axis.X) {
            q = -1;
        }
        boolean canAssemble = true;
        boolean foundHead = false;
        boolean foundConnector = false;
        BlockPos headLocalPos = this.headPosition.m_121996_((Vec3i)this.m_58899_().m_7494_());
        for (Object block : contraption.getBlocks().values()) {
            if (!(block.f_74676_().m_60734_() instanceof PumpjackHammerHeadBlock) && !(block.f_74676_().m_60734_() instanceof LargePumpjackHammerHeadBlock)) continue;
            foundHead = true;
            if (block.f_74675_().m_123341_() == headLocalPos.m_123341_() && block.f_74675_().m_123342_() == q * headLocalPos.m_123342_() && block.f_74675_().m_123343_() == q * headLocalPos.m_123343_()) continue;
            canAssemble = false;
        }
        BlockPos connectorLocalPos = this.connectorPosition.m_121996_((Vec3i)this.m_58899_().m_7494_());
        for (StructureTemplate.StructureBlockInfo block : contraption.getBlocks().values()) {
            if (!(block.f_74676_().m_60734_() instanceof PumpjackHammerConnectorBlock) && !(block.f_74676_().m_60734_() instanceof LargePumpjackHammerConnectorBlock)) continue;
            foundConnector = true;
            if (block.f_74675_().m_123341_() == connectorLocalPos.m_123341_() && block.f_74675_().m_123342_() == q * connectorLocalPos.m_123342_() && block.f_74675_().m_123343_() == q * connectorLocalPos.m_123343_()) continue;
            canAssemble = false;
        }
        if (!(canAssemble && foundHead && foundConnector)) {
            return;
        }
        if (this.base.controllerHammer != this && this.base.controllerHammer != null) {
            return;
        }
        contraption.removeBlocksFromWorld(this.f_58857_, BlockPos.f_121853_);
        this.movedContraption = ControlledContraptionEntity.create((Level)this.f_58857_, (IControlContraption)this, (Contraption)contraption);
        BlockPos anchor = this.f_58858_.m_7494_();
        this.movedContraption.m_6034_((double)anchor.m_123341_(), (double)anchor.m_123342_(), (double)anchor.m_123343_());
        this.movedContraption.setRotationAxis(direction.m_122427_().m_122434_());
        this.f_58857_.m_7967_((Entity)this.movedContraption);
        AllSoundEvents.MECHANICAL_PRESS_ACTIVATION.playOnServer(this.f_58857_, (Vec3i)this.f_58858_);
        if (contraption.containsBlockBreakers()) {
            this.award(AllAdvancements.CONTRAPTION_ACTORS);
        }
        this.running = true;
        this.angle = 0.0f;
        this.sendData();
        this.updateGeneratedRotation();
    }

    private boolean findHeadAndConnector() {
        int i;
        Direction direction = (Direction)this.m_58900_().m_61143_((Property)DirectionalBlock.f_52588_);
        BlockPos checkedPos = this.m_58899_().m_7494_();
        this.connectorPosition = null;
        this.headPosition = null;
        for (i = 0; i < 7; ++i) {
            if (this.connectorPosition != null && this.headPosition != null) {
                this.sendData();
                return true;
            }
            if (i != 0 && (this.f_58857_.m_8055_(checkedPos).m_60734_() instanceof PumpjackHammerHeadBlock || this.f_58857_.m_8055_(checkedPos).m_60734_() instanceof LargePumpjackHammerHeadBlock)) {
                this.headPosition = checkedPos;
                this.headAtFront = true;
                checkedPos = checkedPos.m_121945_(direction);
                this.sendData();
                continue;
            }
            if (i != 0 && (this.f_58857_.m_8055_(checkedPos).m_60734_() instanceof PumpjackHammerConnectorBlock || this.f_58857_.m_8055_(checkedPos).m_60734_() instanceof LargePumpjackHammerConnectorBlock) && ((Direction)this.f_58857_.m_8055_(checkedPos).m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122434_() == ((Direction)this.m_58900_().m_61143_((Property)DirectionalBlock.f_52588_)).m_122434_()) {
                this.connectorPosition = checkedPos;
                this.connectorAtFront = true;
                checkedPos = checkedPos.m_121945_(direction);
                this.sendData();
                continue;
            }
            if (!(this.f_58857_.m_8055_(checkedPos).m_60734_() instanceof PumpjackHammerPartBlock) && !(this.f_58857_.m_8055_(checkedPos).m_60734_() instanceof LargePumpjackHammerPartBlock) || ((Direction)this.f_58857_.m_8055_(checkedPos).m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122434_() != ((Direction)this.m_58900_().m_61143_((Property)DirectionalBlock.f_52588_)).m_122434_()) break;
            checkedPos = checkedPos.m_121945_(direction);
        }
        checkedPos = this.m_58899_().m_7494_();
        for (i = 0; i < 7; ++i) {
            if (this.connectorPosition != null && this.headPosition != null) {
                this.sendData();
                return true;
            }
            if (i != 0 && (this.f_58857_.m_8055_(checkedPos).m_60734_() instanceof PumpjackHammerHeadBlock || this.f_58857_.m_8055_(checkedPos).m_60734_() instanceof LargePumpjackHammerHeadBlock)) {
                this.headPosition = checkedPos;
                this.headAtFront = false;
                checkedPos = checkedPos.m_121945_(direction.m_122424_());
                this.sendData();
                continue;
            }
            if (i != 0 && (this.f_58857_.m_8055_(checkedPos).m_60734_() instanceof PumpjackHammerConnectorBlock || this.f_58857_.m_8055_(checkedPos).m_60734_() instanceof LargePumpjackHammerConnectorBlock) && ((Direction)this.f_58857_.m_8055_(checkedPos).m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122434_() == ((Direction)this.m_58900_().m_61143_((Property)DirectionalBlock.f_52588_)).m_122434_()) {
                this.connectorPosition = checkedPos;
                this.connectorAtFront = false;
                checkedPos = checkedPos.m_121945_(direction.m_122424_());
                this.sendData();
                continue;
            }
            if (!(this.f_58857_.m_8055_(checkedPos).m_60734_() instanceof PumpjackHammerPartBlock) && !(this.f_58857_.m_8055_(checkedPos).m_60734_() instanceof LargePumpjackHammerPartBlock) || ((Direction)this.f_58857_.m_8055_(checkedPos).m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122434_() != ((Direction)this.m_58900_().m_61143_((Property)DirectionalBlock.f_52588_)).m_122434_()) break;
            checkedPos = checkedPos.m_121945_(direction.m_122424_());
        }
        this.sendData();
        return false;
    }

    public void disassemble() {
        if (!this.running && this.movedContraption == null) {
            return;
        }
        this.connectorDistance = 0;
        this.headDistance = 0;
        this.angle = 0.0f;
        this.sequencedAngleLimit = -1.0;
        if (this.movedContraption != null) {
            this.movedContraption.disassemble();
            AllSoundEvents.MECHANICAL_PRESS_ACTIVATION.playOnServer(this.f_58857_, (Vec3i)this.f_58858_);
        }
        this.movedContraption = null;
        this.running = false;
        this.updateGeneratedRotation();
        this.assembleNextTick = false;
        this.sendData();
    }

    public void tick() {
        super.tick();
        if (!this.isRunning()) {
            this.findHeadAndConnector();
        }
        if (!this.isRunning() && this.base != null && this.crank != null && !this.f_58857_.f_46443_) {
            this.assemble();
        }
        if (this.base != null && this.base.controllerHammer == null && this.isRunning()) {
            this.base.setControllerHammer(this);
        }
        if (!(this.base != null && this.crank != null || this.f_58857_.f_46443_)) {
            this.disassemble();
        }
        if (this.f_58857_.m_8055_(this.m_58899_().m_7494_()).m_60713_((Block)TFMGBlocks.LARGE_PUMPJACK_HAMMER_PART.get()) && !((Boolean)this.m_58900_().m_61143_((Property)PumpjackBlock.WIDE)).booleanValue()) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)PumpjackBlock.WIDE, (Comparable)Boolean.valueOf(true)), 2);
        }
        if (!this.isRunning() && !this.f_58857_.m_8055_(this.m_58899_().m_7494_()).m_60713_((Block)TFMGBlocks.LARGE_PUMPJACK_HAMMER_PART.get()) && ((Boolean)this.m_58900_().m_61143_((Property)PumpjackBlock.WIDE)).booleanValue()) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)PumpjackBlock.WIDE, (Comparable)Boolean.valueOf(false)), 2);
        }
        Direction direction = (Direction)this.m_58900_().m_61143_((Property)BearingBlock.FACING);
        if (this.connectorPosition != null) {
            if (direction.m_122434_() == Direction.Axis.Z) {
                this.connectorDistance = Math.abs(this.m_58899_().m_123343_() - this.connectorPosition.m_123343_());
            }
            if (direction.m_122434_() == Direction.Axis.X) {
                this.connectorDistance = Math.abs(this.m_58899_().m_123341_() - this.connectorPosition.m_123341_());
            }
            if (this.crank != null) {
                this.crankConnectorDistance = Math.abs(this.crank.m_58899_().m_123342_() - this.connectorPosition.m_123342_());
                this.crank.crankRadius = (float)this.connectorDistance / 5.0f;
            }
        }
        if (this.headPosition != null) {
            if (direction.m_122434_() == Direction.Axis.Z) {
                this.headDistance = Math.abs(this.m_58899_().m_123343_() - this.headPosition.m_123343_());
            }
            if (direction.m_122434_() == Direction.Axis.X) {
                this.headDistance = Math.abs(this.m_58899_().m_123341_() - this.headPosition.m_123341_());
            }
            if (this.base != null) {
                this.headBaseDistance = Math.abs(this.base.m_58899_().m_123342_() - this.headPosition.m_123342_());
            }
        }
        if (this.connectorPosition != null) {
            this.crank = this.findCrank();
        }
        if (this.crank != null && !(this.f_58857_.m_7702_(this.crank.m_58899_()) instanceof PumpjackCrankBlockEntity)) {
            this.crank = null;
        }
        if (this.headPosition != null) {
            this.base = this.findBase();
        }
        if (this.base != null && !(this.f_58857_.m_7702_(this.base.m_58899_()) instanceof PumpjackBaseBlockEntity)) {
            this.base = null;
        }
        this.prevAngle = this.angle;
        if (this.f_58857_.f_46443_) {
            this.clientAngleDiff /= 2.0f;
        }
        if (!this.f_58857_.f_46443_ && this.assembleNextTick) {
            this.assembleNextTick = false;
            if (!this.running) {
                this.assemble();
            }
        }
        if (!this.running) {
            return;
        }
        if (!(this.movedContraption != null && this.movedContraption.isStalled() || this.crank == null)) {
            int x = 1;
            if (this.connectorAtFront) {
                x = -1;
            }
            this.angle = direction == Direction.SOUTH || direction == Direction.WEST ? (float)Math.toDegrees(Math.atan(this.crank.heightModifier * (float)x / (float)this.connectorDistance)) : (float)Math.toDegrees(Math.atan(-this.crank.heightModifier * (float)x / (float)this.connectorDistance));
        }
        this.applyRotation();
    }

    private PumpjackCrankBlockEntity findCrank() {
        BlockPos checkedPos = this.connectorPosition.m_7495_();
        for (int i = 0; i < 7; ++i) {
            if (this.f_58857_.m_7702_(checkedPos) instanceof PumpjackCrankBlockEntity && ((Direction)this.f_58857_.m_8055_(checkedPos).m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122434_() == ((Direction)this.m_58900_().m_61143_((Property)DirectionalBlock.f_52588_)).m_122434_()) {
                return (PumpjackCrankBlockEntity)this.f_58857_.m_7702_(checkedPos);
            }
            checkedPos = checkedPos.m_7495_();
        }
        return null;
    }

    private PumpjackBaseBlockEntity findBase() {
        BlockPos checkedPos = this.headPosition.m_7495_();
        for (int i = 0; i < 8; ++i) {
            if (this.f_58857_.m_7702_(checkedPos) instanceof PumpjackBaseBlockEntity) {
                return (PumpjackBaseBlockEntity)this.f_58857_.m_7702_(checkedPos);
            }
            checkedPos = checkedPos.m_7495_();
        }
        return null;
    }

    public boolean isNearInitialAngle() {
        return (double)Math.abs(this.angle) < 22.5 || (double)Math.abs(this.angle) > 337.5;
    }

    public void lazyTick() {
        super.lazyTick();
        if (this.movedContraption != null && !this.f_58857_.f_46443_) {
            this.sendData();
        }
    }

    protected void applyRotation() {
        if (this.movedContraption == null) {
            return;
        }
        this.movedContraption.setAngle(this.angle);
        BlockState blockState = this.m_58900_();
        if (blockState.m_61138_((Property)BlockStateProperties.f_61372_)) {
            this.movedContraption.setRotationAxis(((Direction)blockState.m_61143_((Property)BlockStateProperties.f_61372_)).m_122427_().m_122434_());
        }
    }

    public void attach(ControlledContraptionEntity contraption) {
        BlockState blockState = this.m_58900_();
        if (!(contraption.getContraption() instanceof PumpjackContraption)) {
            return;
        }
        if (!blockState.m_61138_((Property)BearingBlock.FACING)) {
            return;
        }
        this.movedContraption = contraption;
        this.m_6596_();
        BlockPos anchor = this.f_58858_.m_7494_();
        this.movedContraption.m_6034_((double)anchor.m_123341_(), (double)anchor.m_123342_(), (double)anchor.m_123343_());
        if (!this.f_58857_.f_46443_) {
            this.running = true;
            this.sendData();
        }
    }

    public void onStall() {
        if (!this.f_58857_.f_46443_) {
            this.sendData();
        }
    }

    public boolean isValid() {
        return !this.m_58901_();
    }

    public boolean isAttachedTo(AbstractContraptionEntity contraption) {
        return this.movedContraption == contraption;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setAngle(float forcedAngle) {
        this.angle = forcedAngle;
    }

    public ControlledContraptionEntity getMovedContraption() {
        return this.movedContraption;
    }
}

