/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.util;

import com.google.common.collect.ImmutableMap;
import com.railwayteam.railways.util.forge.BlockStateUtilsImpl;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackShape;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockStateUtils {
    private static final Map<Block, DyeColor> WOOL_MAP = ImmutableMap.builder().putAll((Map)ImmutableMap.of((Object)Blocks.f_50108_, (Object)DyeColor.RED, (Object)Blocks.f_50042_, (Object)DyeColor.ORANGE, (Object)Blocks.f_50098_, (Object)DyeColor.YELLOW, (Object)Blocks.f_50099_, (Object)DyeColor.LIME, (Object)Blocks.f_50107_, (Object)DyeColor.GREEN, (Object)Blocks.f_50097_, (Object)DyeColor.LIGHT_BLUE, (Object)Blocks.f_50103_, (Object)DyeColor.CYAN, (Object)Blocks.f_50105_, (Object)DyeColor.BLUE)).putAll((Map)ImmutableMap.of((Object)Blocks.f_50104_, (Object)DyeColor.PURPLE, (Object)Blocks.f_50096_, (Object)DyeColor.MAGENTA, (Object)Blocks.f_50100_, (Object)DyeColor.PINK, (Object)Blocks.f_50106_, (Object)DyeColor.BROWN, (Object)Blocks.f_50109_, (Object)DyeColor.BLACK, (Object)Blocks.f_50101_, (Object)DyeColor.GRAY, (Object)Blocks.f_50102_, (Object)DyeColor.LIGHT_GRAY, (Object)Blocks.f_50041_, (Object)DyeColor.WHITE)).build();
    private static final Map<DyeColor, Block> WOOL_MAP_REVERSE = new HashMap<DyeColor, Block>();

    public static BlockState trackWith(TrackBlock block, BlockState state) {
        return (BlockState)((BlockState)((BlockState)block.m_49966_().m_61124_((Property)TrackBlock.SHAPE, (Comparable)((TrackShape)state.m_61143_((Property)TrackBlock.SHAPE)))).m_61124_((Property)TrackBlock.HAS_BE, (Comparable)((Boolean)state.m_61143_((Property)TrackBlock.HAS_BE)))).m_61124_((Property)ProperWaterloggedBlock.WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)ProperWaterloggedBlock.WATERLOGGED)));
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, Entity entity) {
        void var3_3;
        void var2_2;
        void var1_1;
        return BlockStateUtilsImpl.getSoundType(state, (LevelReader)var1_1, (BlockPos)var2_2, (Entity)var3_3);
    }

    public static DyeColor getWoolColor(Block block) {
        return WOOL_MAP.getOrDefault(block, DyeColor.WHITE);
    }

    public static Block getWoolBlock(DyeColor color) {
        return WOOL_MAP_REVERSE.getOrDefault(color, Blocks.f_50041_);
    }

    static {
        for (Map.Entry<Block, DyeColor> entry : WOOL_MAP.entrySet()) {
            WOOL_MAP_REVERSE.put(entry.getValue(), entry.getKey());
        }
    }
}

