/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities.werewolf;

import de.teamlapen.vampirism.api.entity.EntityClassType;
import de.teamlapen.vampirism.api.entity.actions.EntityActionTier;
import de.teamlapen.vampirism.entity.ai.goals.LookAtClosestVisibleGoal;
import de.teamlapen.vampirism.entity.hunter.HunterBaseEntity;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import de.teamlapen.werewolves.api.entities.werewolf.TransformType;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfTransformable;
import de.teamlapen.werewolves.core.ModEntities;
import de.teamlapen.werewolves.entities.werewolf.BasicWerewolfEntity;
import de.teamlapen.werewolves.util.FormHelper;
import de.teamlapen.werewolves.util.Helper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;

public class HumanWerewolfEntity
extends PathfinderMob
implements WerewolfTransformable {
    private static final EntityDataAccessor<Integer> FORM = SynchedEntityData.m_135353_(HumanWerewolfEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SKIN_TYPE = SynchedEntityData.m_135353_(HumanWerewolfEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> EYE_TYPE = SynchedEntityData.m_135353_(HumanWerewolfEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> GLOWING_EYES = SynchedEntityData.m_135353_(HumanWerewolfEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final EntityClassType classType = EntityClassType.getRandomClass((RandomSource)this.m_217043_());
    private final EntityActionTier actionTier = EntityActionTier.Medium;
    protected int rage;

    public HumanWerewolfEntity(EntityType<? extends PathfinderMob> type, Level worldIn) {
        super(type, worldIn);
    }

    public static boolean spawnPredicateHumanWerewolf(EntityType<? extends PathfinderMob> entityType, ServerLevelAccessor world, MobSpawnType spawnReason, BlockPos blockPos, RandomSource random) {
        if (world.m_46791_() == Difficulty.PEACEFUL) {
            return false;
        }
        if (spawnReason == MobSpawnType.EVENT) {
            return true;
        }
        if (!Monster.m_219009_((ServerLevelAccessor)world, (BlockPos)blockPos, (RandomSource)random) && !FormHelper.isInWerewolfBiome((LevelAccessor)world, blockPos)) {
            return false;
        }
        return Mob.m_217057_(entityType, (LevelAccessor)world, (MobSpawnType)spawnReason, (BlockPos)blockPos, (RandomSource)random);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(FORM, (Object)-1);
        this.m_20088_().m_135372_(SKIN_TYPE, (Object)-1);
        this.m_20088_().m_135372_(EYE_TYPE, (Object)-1);
        this.m_20088_().m_135372_(GLOWING_EYES, (Object)false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(2, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(9, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.7));
        this.f_21345_.m_25352_(10, (Goal)new LookAtClosestVisibleGoal((Mob)this, Player.class, 20.0f, 0.6f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, HunterBaseEntity.class, 17.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, VampireBaseEntity.class, 17.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public boolean m_6469_(@Nonnull DamageSource source, float amount) {
        if (super.m_6469_(source, amount)) {
            this.rage = (int)((float)this.rage + amount * 10.0f);
            return true;
        }
        return false;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.rage > 150) {
            WerewolfTransformable werewolf = this.transformToWerewolf(TransformType.TIME_LIMITED);
            ((Mob)werewolf).m_6703_(this.m_5448_());
        }
        if (this.m_9236_().m_46467_() % 400L == 10L) {
            if (Helper.isFullMoon(this.m_9236_())) {
                this.transformToWerewolf(TransformType.FULL_MOON);
            }
            this.rage -= 2;
        }
    }

    @Override
    public void reset() {
        this.rage = 0;
    }

    public static AttributeSupplier.Builder getAttributeBuilder() {
        return PathfinderMob.m_21552_().m_22268_(Attributes.f_22279_, 0.36).m_22268_(Attributes.f_22277_, 48.0).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22276_, 30.0);
    }

    public void m_7378_(@Nonnull CompoundTag compound) {
        int t;
        super.m_7378_(compound);
        if (compound.m_128441_("form")) {
            t = compound.m_128451_("form");
            this.m_20088_().m_135381_(FORM, (Object)(t < 2 && t >= 0 ? t : -1));
        }
        if (compound.m_128441_("type")) {
            t = compound.m_128451_("type");
            this.m_20088_().m_135381_(SKIN_TYPE, (Object)(t < 126 && t >= 0 ? t : -1));
        }
        if (compound.m_128441_("eye_type")) {
            t = compound.m_128451_("eye_type");
            this.m_20088_().m_135381_(EYE_TYPE, (Object)(t < 126 && t >= 0 ? t : -1));
        }
        if (compound.m_128441_("glowing_eye")) {
            this.m_20088_().m_135381_(GLOWING_EYES, (Object)compound.m_128471_("glowing_eye"));
        }
    }

    public void m_7380_(@Nonnull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("form", ((Integer)this.m_20088_().m_135370_(FORM)).intValue());
        compound.m_128405_("type", ((Integer)this.m_20088_().m_135370_(SKIN_TYPE)).intValue());
        compound.m_128405_("eye_type", ((Integer)this.m_20088_().m_135370_(EYE_TYPE)).intValue());
        compound.m_128379_("glowing_eye", ((Boolean)this.m_20088_().m_135370_(GLOWING_EYES)).booleanValue());
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if ((Integer)this.m_20088_().m_135370_(FORM) == -1) {
            this.m_20088_().m_135381_(FORM, (Object)this.m_217043_().m_188503_(2));
        }
        if ((Integer)this.m_20088_().m_135370_(SKIN_TYPE) == -1) {
            this.m_20088_().m_135381_(SKIN_TYPE, (Object)this.m_217043_().m_188503_(126));
        }
        if ((Integer)this.m_20088_().m_135370_(EYE_TYPE) == -1) {
            this.m_20088_().m_135381_(EYE_TYPE, (Object)this.m_217043_().m_188503_(126));
        }
        this.m_20088_().m_135381_(GLOWING_EYES, (Object)this.m_217043_().m_188499_());
    }

    @Override
    public int getSkinType(@Nullable WerewolfForm form) {
        int i = (Integer)this.m_20088_().m_135370_(SKIN_TYPE);
        return Math.max(i, 0);
    }

    @Override
    public int getEyeType(@Nullable WerewolfForm form) {
        int i = (Integer)this.m_20088_().m_135370_(EYE_TYPE);
        return Math.max(i, 0);
    }

    @Override
    public boolean hasGlowingEyes(WerewolfForm form) {
        return (Boolean)this.m_20088_().m_135370_(GLOWING_EYES);
    }

    @Override
    public BasicWerewolfEntity _transformToWerewolf() {
        EntityType type = (Integer)this.m_20088_().m_135370_(FORM) == 0 ? (EntityType)ModEntities.WEREWOLF_BEAST.get() : (EntityType)ModEntities.WEREWOLF_SURVIVALIST.get();
        BasicWerewolfEntity werewolf = (BasicWerewolfEntity)WerewolfTransformable.copyData(type, (Mob)this);
        werewolf.setSourceEntity(this);
        return werewolf;
    }

    @Override
    public EntityActionTier getEntityTier() {
        return this.actionTier;
    }

    @Override
    public EntityClassType getEntityClass() {
        return this.classType;
    }

    @Override
    public WerewolfTransformable _transformBack() {
        return this;
    }

    @Override
    public boolean canTransform() {
        return !this.m_9236_().f_46443_ && Helper.isNight(this.m_9236_()) && this.rage > 0;
    }

    @Override
    @Nonnull
    public WerewolfForm getForm() {
        return switch ((Integer)this.m_20088_().m_135370_(FORM)) {
            case 0 -> WerewolfForm.BEAST;
            case 1 -> WerewolfForm.SURVIVALIST;
            default -> WerewolfForm.HUMAN;
        };
    }
}

