/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.init.food;

import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.xkmc.youkaishomecoming.content.block.plant.CoffeaCropBlock;
import dev.xkmc.youkaishomecoming.content.block.plant.MandrakeGen;
import dev.xkmc.youkaishomecoming.content.block.plant.TeaCropBlock;
import dev.xkmc.youkaishomecoming.content.block.plant.UdumbaraBlock;
import dev.xkmc.youkaishomecoming.content.block.plant.WildCoffeaBlock;
import dev.xkmc.youkaishomecoming.content.block.plant.YHBushBlock;
import dev.xkmc.youkaishomecoming.content.block.plant.YHCropBlock;
import dev.xkmc.youkaishomecoming.init.YoukaisHomecoming;
import dev.xkmc.youkaishomecoming.init.registrate.YHItems;
import java.util.Locale;
import java.util.function.BiFunction;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.tag.ModTags;

public enum YHCrops {
    SOYBEAN(PlantType.CROSS, 16, null, "pods"),
    REDBEAN(PlantType.CROP, 16, null, null),
    COFFEA(PlantType.COFFEA, 8, "green_coffee_bean", "coffee_berries"),
    TEA(PlantType.TEA, 8, "tea_seeds", "tea_leaves"),
    UDUMBARA(PlantType.UDUMBARA, 8, "udumbara_seeds", "udumbara_flower"),
    MANDRAKE(PlantType.MANDRAKE, 8, "mandrake_root", "mandrake_flower");

    private final BlockEntry<? extends BushBlock> PLANT;
    private final BlockEntry<? extends BushBlock> WILD;
    public final ItemEntry<ItemNameBlockItem> seed;
    public final ItemEntry<? extends Item> fruits;
    public final ResourceKey<ConfiguredFeature<?, ?>> configKey;
    public final ResourceKey<PlacedFeature> placementKey;
    private final int rarity;

    private YHCrops(@Nullable PlantType type, @Nullable int rarity, String seedName, String fruit) {
        String name = this.name().toLowerCase(Locale.ROOT);
        this.rarity = rarity;
        if (seedName == null) {
            seedName = name;
        }
        this.configKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)YoukaisHomecoming.loc(name));
        this.placementKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)YoukaisHomecoming.loc(name));
        this.PLANT = type.plant(name, this);
        this.WILD = type.wild(name, this);
        this.seed = YHItems.seed(seedName, p -> new ItemNameBlockItem(this.getPlant(), p));
        this.fruits = fruit == null ? this.seed : YHItems.crop(fruit, Item::new);
    }

    public Block getPlant() {
        return (Block)this.PLANT.get();
    }

    public Block getWildPlant() {
        return (Block)this.WILD.get();
    }

    public Item getSeed() {
        return (Item)this.seed.get();
    }

    public Item getFruits() {
        return (Item)this.fruits.get();
    }

    public void registerComposter() {
        ComposterBlock.f_51914_.put((Object)this.getSeed(), 0.3f);
        if (this.getSeed() != this.getFruits()) {
            ComposterBlock.f_51914_.put((Object)this.getFruits(), 0.5f);
        }
        ComposterBlock.f_51914_.put((Object)this.getWildPlant().m_5456_(), 0.65f);
    }

    public void registerConfigs(BootstapContext<ConfiguredFeature<?, ?>> ctx) {
        FeatureUtils.m_254977_(ctx, this.configKey, (Feature)Feature.f_65763_, (FeatureConfiguration)new RandomPatchConfiguration(12, 5, 3, PlacementUtils.m_206498_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)this.getWildPlant())), (BlockPredicate)BlockPredicate.m_190417_((BlockPredicate[])new BlockPredicate[]{BlockPredicate.m_190419_(), BlockPredicate.m_246848_(), BlockPredicate.m_224774_((Vec3i)Direction.DOWN.m_122436_(), (Block[])new Block[]{Blocks.f_50440_})}))));
    }

    public void registerPlacements(BootstapContext<PlacedFeature> ctx) {
        PlacementUtils.m_255206_(ctx, this.placementKey, (Holder)ctx.m_255420_(Registries.f_256911_).m_255043_(this.configKey), (PlacementModifier[])new PlacementModifier[]{RarityFilter.m_191900_((int)this.rarity), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
    }

    public BlockEntry<Block> createBag() {
        return YHCrops.createBag(this.getName());
    }

    public String getName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public ResourceKey<PlacedFeature> getPlacementKey() {
        return this.placementKey;
    }

    public static BlockEntry<Block> createBag(String id) {
        return YoukaisHomecoming.REGISTRATE.block(id + "_bag", p -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50106_))).blockstate((ctx, pvd) -> pvd.simpleBlock((Block)ctx.get(), (ModelFile)((BlockModelBuilder)pvd.models().cube(ctx.getName(), pvd.modLoc("block/" + ctx.getName() + "_bottom"), pvd.modLoc("block/" + ctx.getName() + "_top"), pvd.modLoc("block/" + ctx.getName() + "_side"), pvd.modLoc("block/" + ctx.getName() + "_side"), pvd.modLoc("block/" + ctx.getName() + "_side_tied"), pvd.modLoc("block/" + ctx.getName() + "_side_tied"))).texture("particle", pvd.modLoc("block/" + ctx.getName() + "_top")))).simpleItem().register();
    }

    public static void register() {
    }

    public static enum PlantType {
        CROP((name, crop) -> YoukaisHomecoming.REGISTRATE.block(name, p -> new YHCropBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_), crop::getSeed)).blockstate((ctx, pvd) -> YHCropBlock.buildCropModel((DataGenContext<Block, ? extends YHCropBlock>)ctx, pvd, name)).loot((pvd, block) -> YHCropBlock.buildPlantLoot(pvd, block, crop)).register(), (name, crop) -> ((BlockBuilder)YoukaisHomecoming.REGISTRATE.block("wild_" + name, p -> new BushBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50111_))).blockstate((ctx, pvd) -> YHCropBlock.buildWildModel((DataGenContext<Block, ? extends BushBlock>)ctx, pvd, crop)).loot((ctx, pvd) -> YHCropBlock.buildWildLoot(ctx, pvd, crop)).item().tag(new TagKey[]{ModTags.WILD_CROPS_ITEM}).model((ctx, pvd) -> pvd.generated((NonNullSupplier)ctx, new ResourceLocation[]{pvd.modLoc("block/wild_" + name)})).build()).tag(new TagKey[]{ModTags.WILD_CROPS}).register()),
        CROSS((name, crop) -> YoukaisHomecoming.REGISTRATE.block(name, p -> new YHCropBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_), crop::getSeed)).blockstate((ctx, pvd) -> YHCropBlock.buildCrossModel((DataGenContext<Block, ? extends YHCropBlock>)ctx, pvd, name)).loot((pvd, block) -> YHCropBlock.buildPlantLoot(pvd, block, crop)).register(), (name, crop) -> ((BlockBuilder)YoukaisHomecoming.REGISTRATE.block("wild_" + name, p -> new BushBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50111_))).blockstate((ctx, pvd) -> YHCropBlock.buildWildModel((DataGenContext<Block, ? extends BushBlock>)ctx, pvd, crop)).loot((ctx, pvd) -> YHCropBlock.buildWildLoot(ctx, pvd, crop)).item().tag(new TagKey[]{ModTags.WILD_CROPS_ITEM}).model((ctx, pvd) -> pvd.generated((NonNullSupplier)ctx, new ResourceLocation[]{pvd.modLoc("block/wild_" + name)})).build()).tag(new TagKey[]{ModTags.WILD_CROPS}).register()),
        COFFEA((name, crop) -> YoukaisHomecoming.REGISTRATE.block(name, p -> new CoffeaCropBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_), crop::getSeed)).blockstate((ctx, pvd) -> CoffeaCropBlock.buildPlantModel((DataGenContext<Block, CoffeaCropBlock>)ctx, pvd, name)).loot((pvd, block) -> CoffeaCropBlock.buildPlantLoot(pvd, block, crop)).register(), (name, crop) -> ((BlockBuilder)YoukaisHomecoming.REGISTRATE.block("wild_" + name, p -> new WildCoffeaBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50111_))).blockstate((ctx, pvd) -> WildCoffeaBlock.buildWildModel((DataGenContext<Block, WildCoffeaBlock>)ctx, pvd, crop)).loot((ctx, pvd) -> WildCoffeaBlock.buildWildLoot(ctx, pvd, crop)).item().tag(new TagKey[]{ModTags.WILD_CROPS_ITEM}).model((ctx, pvd) -> pvd.generated((NonNullSupplier)ctx, new ResourceLocation[]{pvd.modLoc("block/wild_" + name + "_top")})).build()).tag(new TagKey[]{ModTags.WILD_CROPS}).register()),
        TEA((name, crop) -> YoukaisHomecoming.REGISTRATE.block(name, p -> new TeaCropBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60955_().m_280574_().m_60977_().m_60966_().m_60918_(SoundType.f_56758_).m_278166_(PushReaction.DESTROY), crop::getSeed)).blockstate((ctx, pvd) -> TeaCropBlock.buildPlantModel((DataGenContext<Block, TeaCropBlock>)ctx, pvd, name)).loot((pvd, block) -> TeaCropBlock.buildPlantLoot(pvd, block, crop)).register(), (name, crop) -> ((BlockBuilder)YoukaisHomecoming.REGISTRATE.block("wild_" + name, p -> new BushBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50111_))).blockstate((ctx, pvd) -> YHCropBlock.buildWildModel((DataGenContext<Block, ? extends BushBlock>)ctx, pvd, crop)).loot((ctx, pvd) -> TeaCropBlock.buildWildLoot(ctx, pvd, crop)).item().tag(new TagKey[]{ModTags.WILD_CROPS_ITEM}).model((ctx, pvd) -> pvd.generated((NonNullSupplier)ctx, new ResourceLocation[]{pvd.modLoc("block/wild_" + name)})).build()).tag(new TagKey[]{ModTags.WILD_CROPS}).register()),
        UDUMBARA((name, crop) -> YoukaisHomecoming.REGISTRATE.block(name, p -> new UdumbaraBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_).m_60953_(s -> 2), crop::getSeed, crop::getFruits)).blockstate((ctx, pvd) -> YHCropBlock.buildCrossModel((DataGenContext<Block, ? extends YHCropBlock>)ctx, pvd, name)).loot((pvd, block) -> UdumbaraBlock.buildPlantLoot(pvd, block, crop)).register(), (name, crop) -> ((BlockBuilder)YoukaisHomecoming.REGISTRATE.block("wild_" + name, p -> new YHBushBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50111_).m_60953_(s -> 2), crop::getFruits)).blockstate((ctx, pvd) -> YHCropBlock.buildWildModel((DataGenContext<Block, ? extends BushBlock>)ctx, pvd, crop)).loot((pvd, b) -> pvd.m_246125_((Block)b, (ItemLike)crop.getSeed())).item().tag(new TagKey[]{ModTags.WILD_CROPS_ITEM}).model((ctx, pvd) -> pvd.generated((NonNullSupplier)ctx, new ResourceLocation[]{pvd.modLoc("block/wild_" + name)})).build()).tag(new TagKey[]{ModTags.WILD_CROPS}).register()),
        MANDRAKE((name, crop) -> YoukaisHomecoming.REGISTRATE.block(name, p -> new YHCropBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_), crop::getSeed)).blockstate((ctx, pvd) -> YHCropBlock.buildCrossModel((DataGenContext<Block, ? extends YHCropBlock>)ctx, pvd, name)).loot((pvd, block) -> MandrakeGen.buildPlantLoot(pvd, block, crop)).register(), (name, crop) -> ((BlockBuilder)YoukaisHomecoming.REGISTRATE.block("wild_" + name, p -> new BushBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50111_))).blockstate((ctx, pvd) -> YHCropBlock.buildWildModel((DataGenContext<Block, ? extends BushBlock>)ctx, pvd, crop)).loot((ctx, pvd) -> MandrakeGen.buildWildLoot(ctx, pvd, crop)).item().tag(new TagKey[]{ModTags.WILD_CROPS_ITEM}).model((ctx, pvd) -> pvd.generated((NonNullSupplier)ctx, new ResourceLocation[]{pvd.modLoc("block/wild_" + name)})).build()).tag(new TagKey[]{ModTags.WILD_CROPS}).register());

        private final BiFunction<String, YHCrops, BlockEntry<? extends BushBlock>> plant;
        private final BiFunction<String, YHCrops, BlockEntry<? extends BushBlock>> wild;

        private PlantType(BiFunction<String, YHCrops, BlockEntry<? extends BushBlock>> plant, BiFunction<String, YHCrops, BlockEntry<? extends BushBlock>> wild) {
            this.plant = plant;
            this.wild = wild;
        }

        public BlockEntry<? extends BushBlock> plant(String name, YHCrops crop) {
            return this.plant.apply(name, crop);
        }

        public BlockEntry<? extends BushBlock> wild(String name, YHCrops crop) {
            return this.wild.apply(name, crop);
        }
    }
}

