/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.init.food;

import com.tterrag.registrate.util.entry.ItemEntry;
import dev.xkmc.youkaishomecoming.init.food.EffectEntry;
import dev.xkmc.youkaishomecoming.init.food.FoodType;
import dev.xkmc.youkaishomecoming.init.registrate.YHEffects;
import java.util.ArrayList;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import vectorwing.farmersdelight.common.registry.ModEffects;

public enum YHCoffee {
    ESPRESSO(2, 0, 0, new TagKey[0]),
    AMERICANO(1, 0, 0, new TagKey[0]),
    RISTRETTO(3, 0, 0, new TagKey[0]),
    LATTE(1, 4, 0, new TagKey[0]),
    AFFOGATO(1, 2, 1, new TagKey[0]),
    CON_PANNA(2, 2, 1, new TagKey[0]),
    CAPPUCCINO(1, 5, 1, new TagKey[0]),
    MACCHIATO(1, 5, 1, new TagKey[0]),
    MOCHA(1, 6, 1, new TagKey[0]);

    public final ItemEntry<Item> item;

    @SafeVarargs
    private YHCoffee(int coffee, int food, int cream, TagKey<Item> ... tags) {
        FoodType type = coffee > 0 && food >= coffee ? FoodType.BOTTLE_FAST : FoodType.BOTTLE;
        int nutrition = coffee == 0 ? 0 : food;
        float sat = 0.6f;
        ArrayList<EffectEntry> list = new ArrayList<EffectEntry>();
        if (cream > 0) {
            list.add(new EffectEntry((Supplier<MobEffect>)ModEffects.COMFORT, 3600, 0, 1.0f));
        }
        if (coffee > 0) {
            list.add(new EffectEntry(() -> YHEffects.CAFFEINATED.get(), 1200, coffee - 1, 1.0f));
            list.add(new EffectEntry(() -> YHEffects.SOBER.get(), 1200 * coffee, 0, 1.0f));
        }
        String name = this.name().toLowerCase(Locale.ROOT);
        this.item = type.build("coffee/", name, nutrition, sat, tags, list);
    }

    public static void register() {
    }
}

