/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.init.data;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class YHModConfig {
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    public static void init() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON_SPEC);
    }

    static {
        Pair client = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)client.getRight();
        CLIENT = (Client)client.getLeft();
        Pair common = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)common.getRight();
        COMMON = (Common)common.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue laserRenderAdditive;
        public final ForgeConfigSpec.BooleanValue laserRenderInverted;
        public final ForgeConfigSpec.DoubleValue laserTransparency;

        Client(ForgeConfigSpec.Builder builder) {
            this.laserRenderAdditive = builder.define("laserRenderAdditive", true);
            this.laserRenderInverted = builder.define("laserRenderInverted", true);
            this.laserTransparency = builder.defineInRange("laserTransparency", 0.5, 0.0, 1.0);
        }
    }

    public static class Common {
        public final ForgeConfigSpec.IntValue youkaifyingTime;
        public final ForgeConfigSpec.DoubleValue youkaifyingChance;
        public final ForgeConfigSpec.IntValue youkaifyingConfusionTime;
        public final ForgeConfigSpec.IntValue youkaifyingThreshold;
        public final ForgeConfigSpec.IntValue youkaifiedDuration;
        public final ForgeConfigSpec.IntValue youkaifiedProlongation;
        public final ForgeConfigSpec.DoubleValue smoothingHealingFactor;
        public final ForgeConfigSpec.IntValue teaHealingPeriod;
        public final ForgeConfigSpec.IntValue udumbaraDuration;
        public final ForgeConfigSpec.IntValue udumbaraHealingPeriod;
        public final ForgeConfigSpec.IntValue udumbaraFullMoonReduction;
        public final ForgeConfigSpec.IntValue higiHealingPeriod;
        public final ForgeConfigSpec.DoubleValue fairyHealingFactor;
        public final ForgeConfigSpec.IntValue frogEatCountForHat;
        public final ForgeConfigSpec.IntValue frogEatRaiderVillagerSightRange;
        public final ForgeConfigSpec.IntValue frogEatRaiderVillagerNoSightRange;
        public final ForgeConfigSpec.BooleanValue koishiAttackEnable;
        public final ForgeConfigSpec.IntValue koishiAttackCoolDown;
        public final ForgeConfigSpec.DoubleValue koishiAttackChance;
        public final ForgeConfigSpec.IntValue koishiAttackDamage;
        public final ForgeConfigSpec.IntValue koishiAttackBlockCount;
        public final ForgeConfigSpec.DoubleValue danmakuMinPHPDamage;
        public final ForgeConfigSpec.DoubleValue danmakuPlayerPHPDamage;
        public final ForgeConfigSpec.DoubleValue danmakuHealOnHitTarget;
        public final ForgeConfigSpec.IntValue playerDanmakuCooldown;
        public final ForgeConfigSpec.IntValue playerLaserCooldown;
        public final ForgeConfigSpec.IntValue playerSpellCooldown;
        public final ForgeConfigSpec.IntValue playerLaserDuration;
        public final ForgeConfigSpec.BooleanValue rumiaNaturalSpawn;
        public final ForgeConfigSpec.BooleanValue exRumiaConversion;
        public final ForgeConfigSpec.BooleanValue rumiaDamageCap;
        public final ForgeConfigSpec.BooleanValue rumiaNoTargetHealing;
        public final ForgeConfigSpec.BooleanValue rumiaHairbandDrop;
        public final ForgeConfigSpec.BooleanValue reimuSummonFlesh;
        public final ForgeConfigSpec.BooleanValue reimuSummonKill;
        public final ForgeConfigSpec.BooleanValue reimuSummonMoney;
        public final ForgeConfigSpec.IntValue reimuSummonCost;
        public final ForgeConfigSpec.BooleanValue reimuHairbandFlightEnable;
        public final ForgeConfigSpec.BooleanValue reimuExtraDamageCoolDown;
        public final ForgeConfigSpec.BooleanValue reimuDamageReduction;
        public final ForgeConfigSpec.BooleanValue cirnoSpawn;
        public final ForgeConfigSpec.DoubleValue cirnoFairyDrop;

        Common(ForgeConfigSpec.Builder builder) {
            builder.push("youkaifying_effect");
            this.youkaifyingChance = builder.comment("Chance for flesh food to add Youkaifying effect for the first time").defineInRange("youkaifyingChance", 0.2, 0.0, 1.0);
            this.youkaifyingConfusionTime = builder.comment("Confusion time when flesh food to add Youkaifying effect for the first time").defineInRange("youkaifyingConfusionTime", 200, 0, 1000000);
            this.youkaifyingTime = builder.comment("Time for flesh food to add Youkaifying effect").defineInRange("youkaifyingTime", 1200, 0, 1000000);
            this.youkaifyingThreshold = builder.comment("Threshold for Youkaifying effect to turn into Youkaified effect").defineInRange("youkaifyingThreshold", 6000, 0, 1000000);
            this.youkaifiedDuration = builder.comment("Youkaified duration once reached").defineInRange("youkaifiedDuration", 24000, 0, 1000000);
            this.youkaifiedProlongation = builder.comment("Time for flesh food to add Youkaified effect").defineInRange("youkaifiedProlongation", 6000, 0, 1000000);
            builder.pop();
            builder.push("food_effect");
            this.smoothingHealingFactor = builder.comment("Smoothing Healing Factor").defineInRange("smoothingHealingFactor", 1.5, 1.0, 100.0);
            this.teaHealingPeriod = builder.comment("Tea Healing Interval").defineInRange("teaHealingPeriod", 60, 0, 10000);
            this.udumbaraHealingPeriod = builder.comment("Udumbara effect Healing Interval").defineInRange("udumbaraHealingPeriod", 60, 0, 10000);
            this.udumbaraDuration = builder.comment("Udumbara flowering duration").defineInRange("udumbaraDuration", 200, 0, 100000);
            this.udumbaraFullMoonReduction = builder.comment("Udumbara full moon damage reduction").defineInRange("udumbaraFullMoonReduction", 4, 0, 100);
            this.higiHealingPeriod = builder.comment("Higi Healing Interval").defineInRange("higiHealingPeriod", 60, 0, 10000);
            this.fairyHealingFactor = builder.comment("Fairy Healing Factor").defineInRange("fairyHealingFactor", 2.0, 1.0, 100.0);
            builder.pop();
            builder.push("suwako_hat");
            this.frogEatCountForHat = builder.comment("Number of raiders with different types frogs need to eat in front of villager to drop Suwako hat").defineInRange("frogEatCountForHat", 3, 1, 10);
            this.frogEatRaiderVillagerSightRange = builder.comment("Range for villagers with direct sight when frog eat raiders").defineInRange("frogEatRaiderVillagerSightRange", 20, 1, 64);
            this.frogEatRaiderVillagerNoSightRange = builder.comment("Range for villagers without direct sight when frog eat raiders").defineInRange("frogEatRaiderVillagerNoSightRange", 10, 1, 64);
            builder.pop();
            builder.push("koishi_attack");
            this.koishiAttackEnable = builder.comment("Enable koishi attack when player has youkaifying or youkaified effect").define("koishiAttackEnable", true);
            this.koishiAttackCoolDown = builder.comment("Time in ticks for minimum time between koishi attacks").defineInRange("koishiAttackCoolDown", 6000, 1, 1000000);
            this.koishiAttackChance = builder.comment("Chance every tick to do koishi attack").defineInRange("koishiAttackChance", 0.001, 0.0, 1.0);
            this.koishiAttackDamage = builder.comment("Koishi attack damage").defineInRange("koishiAttackDamage", 100, 0, 100000000);
            this.koishiAttackBlockCount = builder.comment("Number of times player needs to consecutively block Koishi attack to get hat").defineInRange("koishiAttackBlockCount", 3, 0, 100);
            builder.pop();
            builder.push("danmaku_battle");
            this.danmakuMinPHPDamage = builder.comment("Minimum damage youkai danmaku will deal against non-player").defineInRange("danmakuMinPHPDamage", 0.02, 0.0, 1.0);
            this.danmakuPlayerPHPDamage = builder.comment("Minimum damage youkai danmaku will deal against player").defineInRange("danmakuPlayerPHPDamage", 0.1, 0.0, 1.0);
            this.danmakuHealOnHitTarget = builder.comment("When danmaku hits target, heal youkai health by percentage of max health").defineInRange("danmakuHealOnHitTarget", 0.2, 0.0, 1.0);
            this.playerDanmakuCooldown = builder.comment("Player item cooldown for using danmaku").defineInRange("playerDanmakuCooldown", 20, 5, 1000);
            this.playerLaserCooldown = builder.comment("Player item cooldown for using laser").defineInRange("playerLaserCooldown", 80, 5, 1000);
            this.playerSpellCooldown = builder.comment("Player item cooldown for using spellcard").defineInRange("playerSpellCooldown", 40, 5, 1000);
            this.playerLaserDuration = builder.comment("Player laser duration").defineInRange("playerLaserDuration", 100, 5, 1000);
            builder.pop();
            builder.push("rumia");
            this.rumiaNaturalSpawn = builder.comment("If Rumia would spawn naturally around her nest if the first one goes too far. Does not affect structure spawn").define("rumiaNaturalSpawn", true);
            this.exRumiaConversion = builder.comment("Enable Ex Rumia conversion when Rumia takes too high damage in one hit").define("exRumiaConversion", true);
            this.rumiaDamageCap = builder.comment("Allow Rumia to cap incoming damage at a factor of max health").define("rumiaDamageCap", true);
            this.rumiaNoTargetHealing = builder.comment("Enable Rumia healing when having no target").define("rumiaNoTargetHealing", true);
            this.rumiaHairbandDrop = builder.comment("Enable Ex Rumia hairband drop").define("rumiaHairbandDrop", true);
            builder.pop();
            builder.push("reimu");
            this.reimuSummonFlesh = builder.comment("Summon Reimu when player eats flesh in front of villagers").define("reimuSummonFlesh", true);
            this.reimuSummonKill = builder.comment("Summon Reimu when player with youkaified/fying effect kills villager in front of other villagers").define("reimuSummonKill", true);
            this.reimuSummonMoney = builder.comment("Summon Reimu when player throws emerald or gold into donation box").define("reimuSummonMoney", true);
            this.reimuSummonCost = builder.comment("Cost of emerald/gold to summon Reimu").defineInRange("reimuSummonCost", 8, 1, 100000);
            this.reimuHairbandFlightEnable = builder.comment("Enable creative flight on Reimu hairband").define("reimuHairbandFlightEnable", true);
            this.reimuExtraDamageCoolDown = builder.comment("Enable non-danmaku extra damage cooldown on Reimu").define("reimuExtraDamageCoolDown", true);
            this.reimuDamageReduction = builder.comment("Enable non-danmaku damage reduction on Reimu").define("reimuDamageReduction", true);
            builder.pop();
            builder.push("cirno");
            this.cirnoSpawn = builder.comment("Toggle for Cirno natural spawns").define("cirnoSpawn", true);
            this.cirnoFairyDrop = builder.comment("Chance for fairy ice crystal to drop").defineInRange("cirnoFairyDrop", 0.03, 0.0, 1.0);
            builder.pop();
        }
    }
}

