/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.spell.game.youmu;

import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.DanmakuHelper;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.ItemDanmakuEntity;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.ActualSpellCard;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.CardHolder;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.Ticker;
import dev.xkmc.youkaishomecoming.init.registrate.YHDanmaku;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.phys.Vec3;

@SerialClass
public class YoumuSlash
extends ActualSpellCard {
    @Override
    public void tick(CardHolder holder) {
        super.tick(holder);
        int interval = 40;
        Vec3 target = holder.target();
        if (this.tick % interval == 0 && target != null) {
            int index = this.tick / interval;
            boolean first = index % 2 == 0;
            double angle = holder.random().m_188500_();
            Vec3 start = DanmakuHelper.getOrientation(target).asNormal().rotateDegrees(angle * 30.0 - 15.0 + 90.0);
            this.addTicker(new Slash(first ? 3 : 4, first ? DyeColor.BLUE : DyeColor.RED, holder.center(), start, target));
        }
    }

    @SerialClass
    public static class Slash
    extends Ticker<YoumuSlash> {
        @SerialClass.SerialField
        public int points;
        @SerialClass.SerialField
        public DyeColor color;
        @SerialClass.SerialField
        public Vec3 ori;
        @SerialClass.SerialField
        public Vec3 start;
        @SerialClass.SerialField
        public Vec3 target;

        public Slash() {
        }

        public Slash(int points, DyeColor color, Vec3 ori, Vec3 start, Vec3 target) {
            this.points = points;
            this.color = color;
            this.ori = ori;
            this.start = start;
            this.target = target;
        }

        @Override
        public boolean tick(CardHolder holder, YoumuSlash card) {
            int length = 8;
            int dur = 8;
            int dist = 60;
            int dl = 10;
            int space = 4;
            double speed = 0.6;
            double dv = 0.1;
            int n = 3;
            RandomSource r = holder.random();
            for (int i = 0; i < this.points; ++i) {
                double dt = 1.0 * (double)i / (double)this.points;
                double len = (((double)this.tick - dt) / (double)dur * 2.0 - 1.0) * (double)length;
                Vec3 pos = this.ori.m_82549_(this.target.m_82546_(this.ori).m_82541_().m_82490_(-1.0)).m_82549_(this.start.m_82490_(len));
                double offset = (double)space * ((double)i - (double)(this.points - 1) * 0.5);
                Vec3 tar = this.target.m_82549_(this.start.m_82490_(offset));
                for (int j = 0; j < n; ++j) {
                    double sp = speed + (double)j * dv;
                    Vec3 vel = tar.m_82546_(pos).m_82541_().m_82490_(sp);
                    Vec3 actPos = pos.m_82549_(vel.m_82490_(dt));
                    int lf = (int)Math.round((double)dist / sp) + r.m_188503_(dl);
                    ItemDanmakuEntity bullet = holder.prepareDanmaku(lf, vel, YHDanmaku.Bullet.CIRCLE, this.color);
                    bullet.m_146884_(actPos);
                    holder.shoot(bullet);
                }
            }
            super.tick(holder, card);
            return this.tick > dur;
        }
    }
}

