/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.spell.game.sanae;

import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.DanmakuHelper;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.ItemDanmakuEntity;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.ItemLaserEntity;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.ActualSpellCard;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.CardHolder;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.Ticker;
import dev.xkmc.youkaishomecoming.init.registrate.YHDanmaku;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.phys.Vec3;

@SerialClass
public class Sugiruyoru
extends ActualSpellCard {
    @SerialClass.SerialField
    private int selection = 0;
    @SerialClass.SerialField
    private int groundTime = 0;

    @Override
    public void tick(CardHolder holder) {
        Mob mob;
        LivingEntity e;
        super.tick(holder);
        Vec3 le = holder.target();
        if (le == null) {
            return;
        }
        LivingEntity livingEntity = holder.self();
        if (livingEntity instanceof Mob && (e = (mob = (Mob)livingEntity).m_5448_()) != null) {
            this.groundTime = e.m_20096_() ? 0 : ++this.groundTime;
        }
        if (this.tick % 20 == 0) {
            this.selection = this.groundTime < 40 && le.m_82554_(holder.center()) < 25.0 ? 0 : 1;
        }
        if (this.selection == 0) {
            this.near(holder, le);
        } else {
            this.far(holder, le);
        }
    }

    private void near(CardHolder holder, Vec3 le) {
        Vec3 dir;
        if (this.tick % 10 == 0) {
            dir = holder.forward().m_82490_(0.6);
            holder.shoot(holder.prepareDanmaku(80, dir, YHDanmaku.Bullet.CIRCLE, DyeColor.RED));
        }
        if (this.tick % 40 == 0) {
            dir = holder.forward().m_82542_(1.0, 0.0, 1.0).m_82541_();
            if (dir.m_82553_() < 0.1) {
                return;
            }
            Vec3 pos = holder.center();
            pos = new Vec3(pos.f_82479_, le.f_82480_, pos.f_82481_);
            DanmakuHelper.Orientation o0 = DanmakuHelper.getOrientation(dir);
            for (int i = -1; i <= 1; i += 2) {
                RotatingStar ans = new RotatingStar();
                ans.pos = o0.rotateDegrees(i * 45).m_82490_(8.0).m_82549_(pos);
                ans.init = dir;
                ans.start = (i + 1) * 90;
                this.addTicker(ans);
            }
        }
    }

    private void far(CardHolder holder, Vec3 le) {
        if (this.tick % 20 == 0) {
            ExplosiveGrains ans = new ExplosiveGrains();
            ans.pos = holder.center();
            ans.dir = holder.forward();
            ans.target = le;
            double speed = Math.max(1.0, le.m_82554_(ans.pos) / 30.0);
            Vec3 vel = holder.targetVelocity();
            if (vel != null) {
                speed += vel.m_82553_() * 1.5;
            }
            ans.speed = speed;
            this.addTicker(ans);
        }
    }

    @SerialClass
    public static class RotatingStar
    extends Ticker<Sugiruyoru> {
        @SerialClass.SerialField
        private Vec3 pos;
        @SerialClass.SerialField
        private Vec3 init;
        @SerialClass.SerialField
        private double start;

        @Override
        public boolean tick(CardHolder holder, Sugiruyoru card) {
            this.step(holder);
            super.tick(holder, card);
            return this.tick > 40;
        }

        private void step(CardHolder holder) {
            if (this.pos == null) {
                this.pos = holder.center();
            }
            if (this.init == null) {
                this.init = holder.forward();
            }
            if (this.tick % 2 != 0) {
                return;
            }
            Vec3 dir = DanmakuHelper.getOrientation(this.init).rotateDegrees((double)(9 * this.tick) + this.start);
            ItemLaserEntity e = holder.prepareLaser(40, this.pos, dir, 40, YHDanmaku.Laser.LASER, DyeColor.LIGHT_BLUE);
            e.setupTime(10, 4, 12, 4);
            holder.shoot(e);
        }
    }

    @SerialClass
    public static class ExplosiveGrains
    extends Ticker<Sugiruyoru> {
        private static final DyeColor[] COLORS = new DyeColor[]{DyeColor.LIGHT_BLUE, DyeColor.CYAN, DyeColor.LIME, DyeColor.YELLOW, DyeColor.LIGHT_GRAY};
        @SerialClass.SerialField
        private Vec3 pos;
        @SerialClass.SerialField
        private Vec3 dir;
        @SerialClass.SerialField
        private Vec3 target;
        @SerialClass.SerialField
        private double speed;

        @Override
        public boolean tick(CardHolder holder, Sugiruyoru card) {
            this.step(holder);
            super.tick(holder, card);
            return this.tick >= 50;
        }

        private void step(CardHolder holder) {
            if (this.target == null) {
                this.pos = holder.center();
                this.dir = holder.forward();
                this.target = holder.target();
            }
            int ver = 72;
            int off = 18;
            int dis = 12;
            int dur = 25;
            double spf = this.speed;
            if (this.tick < 10 && this.tick % 2 == 0) {
                DanmakuHelper.Orientation o0 = DanmakuHelper.getOrientation(this.dir).asNormal();
                for (int i = 0; i < 5; ++i) {
                    Vec3 p0 = this.pos.m_82549_(o0.rotateDegrees(i * 72).m_82490_((double)dis));
                    Vec3 d0 = this.target.m_82546_(p0).m_82541_();
                    DanmakuHelper.Orientation o1 = DanmakuHelper.getOrientation(d0).asNormal();
                    for (int j = 0; j < 5; ++j) {
                        Vec3 d1 = o1.rotateDegrees(j * 72 + i * off, ver).m_82490_(spf);
                        ItemDanmakuEntity e = holder.prepareDanmaku(dur, d1, YHDanmaku.Bullet.CIRCLE, DyeColor.RED);
                        e.m_146884_(p0);
                        holder.shoot(e);
                    }
                    Vec3 d1 = d0.m_82490_(this.speed);
                    ItemDanmakuEntity e = holder.prepareDanmaku(60, d1, YHDanmaku.Bullet.CIRCLE, DyeColor.RED);
                    e.m_146884_(p0);
                    holder.shoot(e);
                }
            }
            if (this.tick - dur >= 0 && this.tick - dur < 10 && this.tick % 2 == 0) {
                RandomSource r = holder.random();
                DanmakuHelper.Orientation o0 = DanmakuHelper.getOrientation(this.dir).asNormal();
                for (int i = 0; i < 5; ++i) {
                    Vec3 p0 = this.pos.m_82549_(o0.rotateDegrees(i * 72).m_82490_((double)dis));
                    Vec3 d0 = this.target.m_82546_(p0).m_82541_();
                    DanmakuHelper.Orientation o1 = DanmakuHelper.getOrientation(d0).asNormal();
                    for (int j = 0; j < 5; ++j) {
                        Vec3 d1 = o1.rotateDegrees(j * 72 + i * off, ver);
                        Vec3 p1 = p0.m_82549_(d1.m_82490_(spf * (double)dur));
                        for (int k = 0; k < 3; ++k) {
                            Vec3 d2 = new Vec3(r.m_188583_(), r.m_188583_(), r.m_188583_()).m_82541_().m_82490_(0.7);
                            int life = 60 + r.m_188503_(40);
                            ItemDanmakuEntity e = holder.prepareDanmaku(life, d2, YHDanmaku.Bullet.BALL, COLORS[j]);
                            e.m_146884_(p1);
                            holder.shoot(e);
                        }
                    }
                }
            }
        }
    }
}

