/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.spell.game.reimu;

import dev.xkmc.fastprojectileapi.entity.ProjectileMovement;
import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.DanmakuHelper;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.IYHDanmaku;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.ItemDanmakuEntity;
import dev.xkmc.youkaishomecoming.content.item.danmaku.DanmakuItem;
import dev.xkmc.youkaishomecoming.content.spell.mover.RectMover;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.ActualSpellCard;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.CardHolder;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.Ticker;
import dev.xkmc.youkaishomecoming.init.data.YHDamageTypes;
import dev.xkmc.youkaishomecoming.init.registrate.YHDanmaku;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

@SerialClass
public class StagedHoming
extends ActualSpellCard {
    @SerialClass.SerialField
    private boolean border;
    @SerialClass.SerialField
    private boolean abyss;

    @Override
    public void tick(CardHolder holder) {
        boolean far;
        super.tick(holder);
        int interval = 10;
        Vec3 target = holder.target();
        double dist = target == null ? 0.0 : holder.center().m_82554_(target);
        boolean bl = far = dist > 40.0;
        if (this.tick % interval == 0) {
            int step = this.tick / interval % 5;
            if (step < 3) {
                this.shoot(far);
            } else if (dist > 40.0) {
                this.intercept(holder, target);
            }
        }
        if (target != null && this.border) {
            this.border(holder, dist);
        }
    }

    private void shoot(boolean far) {
        StateChange ans = new StateChange();
        ans.r0 = far ? 32 : 8;
        ans.r1 = far ? 32 : 6;
        ans.t0 = far ? 10 : 20;
        ans.t1 = far ? 10 : 20;
        double d = ans.termSpeed = far ? 3.0 : 1.0;
        if (this.abyss) {
            ans.color = DyeColor.BLUE;
        }
        this.addTicker(ans);
    }

    private void intercept(CardHolder holder, Vec3 target) {
        Vec3 dir = holder.targetVelocity();
        if (dir == null) {
            return;
        }
        double speed = dir.m_82553_();
        if ((dir = dir.m_82541_()).m_82553_() < 0.1) {
            return;
        }
        double dist = Math.max(24.0, speed * 20.0);
        Vec3 dst = target.m_82549_(dir.m_82490_(dist));
        if (dst.f_82480_ < (double)holder.self().m_9236_().m_141937_()) {
            dst = new Vec3(dst.f_82479_, target.f_82480_, dst.f_82481_);
        }
        if (!StagedHoming.teleport(holder.self(), dst)) {
            return;
        }
        if (speed < 0.5) {
            return;
        }
        Intercept ans = new Intercept();
        ans.vec = target;
        ans.dir = dir;
        this.addTicker(ans);
    }

    private void border(CardHolder holder, double dist) {
        Vec3 forward = holder.forward();
        DanmakuHelper.Orientation ori = DanmakuHelper.getOrientation(forward);
        double angle = ProjectileMovement.of((Vec3)forward).rot().f_82480_ * 57.2957763671875;
        double speed = Mth.m_14008_((double)(dist / 30.0), (double)1.5, (double)3.0);
        for (int i = 0; i < 8; ++i) {
            Vec3 dir = ori.rotateDegrees(45.0 * (double)i - angle);
            ItemDanmakuEntity e = holder.prepareDanmaku(40, dir.m_82490_(speed), YHDanmaku.Bullet.BALL, DyeColor.YELLOW);
            holder.shoot(e);
        }
    }

    @Override
    public DamageSource getDanmakuDamageSource(IYHDanmaku danmaku) {
        ItemDanmakuEntity e;
        Item item;
        if (danmaku instanceof ItemDanmakuEntity && (item = (e = (ItemDanmakuEntity)danmaku).m_7846_().m_41720_()) instanceof DanmakuItem) {
            DanmakuItem i = (DanmakuItem)item;
            if (i.color == DyeColor.BLUE || i.color == DyeColor.YELLOW) {
                return YHDamageTypes.abyssal(danmaku);
            }
        }
        return super.getDanmakuDamageSource(danmaku);
    }

    @Override
    public void hurt(CardHolder holder, DamageSource source, float amount) {
        Vec3 target;
        float mhp;
        float hp;
        super.hurt(holder, source, amount);
        if (source.m_7639_() != null) {
            this.border = true;
        }
        if ((hp = holder.self().m_21223_()) < (mhp = holder.self().m_21233_()) / 2.0f) {
            this.abyss = true;
        }
        double dist = (target = holder.target()) == null ? 0.0 : holder.center().m_82554_(target);
        this.homingReact(holder, dist > 40.0);
    }

    private void homingReact(CardHolder holder, boolean far) {
        Vec3 le = holder.target();
        if (le == null) {
            return;
        }
        RandomSource r = holder.random();
        Vec3 dir = le.m_82546_(holder.center()).m_82541_();
        if (r.m_188500_() < 0.5) {
            dir = new Vec3(1.0, 0.0, 0.0);
        }
        Vec3 ori = DanmakuHelper.getOrientation(dir).rotateDegrees(90.0, 60.0 * r.m_188500_() - 30.0);
        Vec3 normal = dir.m_82537_(ori);
        int n = 8;
        int s = r.m_188500_() < 0.5 ? -1 : 1;
        for (int i = 0; i <= 5; ++i) {
            StateChange ans = new StateChange();
            ans.r0 = far ? 32 : 24;
            ans.r1 = far ? 32 : 18;
            ans.t0 = far ? 10 : 20;
            ans.t1 = far ? 10 : 20;
            ans.termSpeed = far ? 3.0 : 1.0;
            ans.n = n;
            ans.bullet = YHDanmaku.Bullet.BUBBLE;
            ans.pos = holder.center();
            ans.init = DanmakuHelper.getOrientation(ori, normal).rotateDegrees((double)(s * (i - 2)) * 360.0 / (double)n / 4.0);
            ans.normal = normal;
            ans.tick = -i * 2;
            if (this.abyss) {
                ans.color = DyeColor.BLUE;
            }
            this.addTicker(ans);
        }
    }

    private static boolean teleport(LivingEntity mob, Vec3 target) {
        Vec3 old = mob.m_20182_();
        mob.m_6021_(target.m_7096_(), target.m_7098_(), target.m_7094_());
        if (!mob.m_9236_().m_45786_((Entity)mob)) {
            mob.m_6021_(old.m_7096_(), old.m_7098_(), old.m_7094_());
            return false;
        }
        mob.m_9236_().m_7605_((Entity)mob, (byte)46);
        mob.m_9236_().m_214171_(GameEvent.f_238175_, mob.m_20182_(), GameEvent.Context.m_223717_((Entity)mob));
        if (!mob.m_20067_()) {
            mob.m_9236_().m_6263_(null, mob.f_19854_, mob.f_19855_, mob.f_19856_, SoundEvents.f_11852_, mob.m_5720_(), 1.0f, 1.0f);
            mob.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
        }
        return true;
    }

    @SerialClass
    public static class StateChange
    extends Ticker<StagedHoming> {
        @SerialClass.SerialField
        private Vec3 pos;
        @SerialClass.SerialField
        private Vec3 init;
        @SerialClass.SerialField
        private Vec3 normal;
        @SerialClass.SerialField
        private Vec3 target1;
        @SerialClass.SerialField
        private int r0 = 8;
        @SerialClass.SerialField
        private int r1 = 6;
        @SerialClass.SerialField
        private int n = 20;
        @SerialClass.SerialField
        private int t0 = 20;
        @SerialClass.SerialField
        private int t1 = 20;
        @SerialClass.SerialField
        private int t2 = 40;
        @SerialClass.SerialField
        private int dt = 20;
        @SerialClass.SerialField
        private double termSpeed = 1.0;
        @SerialClass.SerialField
        private YHDanmaku.Bullet bullet = YHDanmaku.Bullet.CIRCLE;
        @SerialClass.SerialField
        private DyeColor color = DyeColor.RED;

        @Override
        public boolean tick(CardHolder holder, StagedHoming card) {
            this.step(holder);
            super.tick(holder, card);
            return this.tick > this.t0 + this.t1 || holder.target() == null;
        }

        private void step(CardHolder holder) {
            Vec3 vec;
            int i;
            double acc;
            DanmakuHelper.Orientation o0;
            Vec3 le = holder.target();
            if (le == null) {
                return;
            }
            RandomSource r = holder.random();
            if (this.init == null) {
                this.pos = holder.center();
                Vec3 dir = le.m_82546_(holder.center()).m_82541_();
                this.init = DanmakuHelper.getOrientation(dir).rotateDegrees(90.0, 60.0 * r.m_188500_() - 30.0);
                this.normal = dir.m_82537_(this.init);
            }
            if (this.tick < 0) {
                return;
            }
            if (this.tick == 0) {
                o0 = DanmakuHelper.getOrientation(this.init, this.normal);
                acc = (double)this.r0 * 2.0 / (double)this.t0 / (double)this.t0;
                for (i = 0; i < this.n; ++i) {
                    Vec3 front = o0.rotateDegrees(360.0 / (double)this.n * (double)i);
                    Vec3 vec2 = front.m_82490_(acc * (double)this.t0);
                    ItemDanmakuEntity e = holder.prepareDanmaku(this.t0, vec2, this.bullet, DyeColor.LIGHT_GRAY);
                    e.mover = new RectMover(this.pos, vec2, front.m_82490_(-acc));
                    holder.shoot(e);
                }
            }
            if (this.tick == this.t0) {
                this.target1 = le;
                o0 = DanmakuHelper.getOrientation(this.init, this.normal);
                acc = (double)this.r1 * 2.0 / (double)this.t1 / (double)this.t1;
                for (i = 0; i < this.n; ++i) {
                    Vec3 f0 = o0.rotateDegrees(360.0 / (double)this.n * (double)i);
                    Vec3 p0 = this.pos.m_82549_(f0.m_82490_((double)this.r0));
                    Vec3 f1 = this.target1.m_82546_(p0).m_82541_();
                    vec = f1.m_82490_(acc * (double)this.t1);
                    ItemDanmakuEntity e = holder.prepareDanmaku(this.t1, vec, this.bullet, DyeColor.PURPLE);
                    e.m_146884_(p0);
                    e.mover = new RectMover(p0, vec, f1.m_82490_(-acc));
                    holder.shoot(e);
                }
            }
            if (this.tick == this.t0 + this.t1 && this.target1 != null) {
                o0 = DanmakuHelper.getOrientation(this.init, this.normal);
                for (int i2 = 0; i2 < this.n; ++i2) {
                    Vec3 f0 = o0.rotateDegrees(360.0 / (double)this.n * (double)i2);
                    Vec3 p0 = this.pos.m_82549_(f0.m_82490_((double)this.r0));
                    Vec3 f1 = this.target1.m_82546_(p0).m_82541_();
                    Vec3 p1 = p0.m_82549_(f1.m_82490_((double)this.r1));
                    Vec3 f2 = le.m_82546_(p1).m_82541_();
                    vec = f2.m_82490_(this.termSpeed);
                    int t = this.t2 + r.m_188503_(this.dt);
                    ItemDanmakuEntity e = holder.prepareDanmaku(t, vec, this.bullet, this.color);
                    e.m_146884_(p1);
                    e.mover = new RectMover(p1, vec, Vec3.f_82478_);
                    holder.shoot(e);
                }
            }
        }
    }

    @SerialClass
    public static class Intercept
    extends Ticker<StagedHoming> {
        @SerialClass.SerialField
        private Vec3 vec = Vec3.f_82478_;
        @SerialClass.SerialField
        private Vec3 dir = new Vec3(1.0, 0.0, 0.0);
        @SerialClass.SerialField
        private double dist = 32.0;
        @SerialClass.SerialField
        private double w = 18.0;
        @SerialClass.SerialField
        private double speed = 2.0;
        @SerialClass.SerialField
        private double duration = 80.0;

        @Override
        public boolean tick(CardHolder holder, StagedHoming card) {
            Vec3 target = holder.target();
            if (target != null) {
                this.vec = this.vec.m_82490_(0.95).m_82549_(target.m_82490_(0.05));
            }
            DanmakuHelper.Orientation ori = DanmakuHelper.getOrientation(this.dir);
            for (int i = 0; i < 8; ++i) {
                Vec3 off = ori.rotateDegrees(45.0 * (double)i);
                Vec3 pos = this.vec.m_82549_(this.dir.m_82549_(off.m_82490_(this.dist)));
                DanmakuHelper.Orientation nor = DanmakuHelper.getOrientation(off).asNormal();
                for (int j = 0; j < 8; ++j) {
                    Vec3 vel = nor.rotateDegrees(45.0 * (double)j + (double)this.tick * this.w).m_82490_(this.speed).m_82549_(off.m_82490_(-1.0));
                    int life = (int)Math.min(this.duration - (double)this.tick, 40.0) + holder.random().m_188503_(10);
                    ItemDanmakuEntity e = holder.prepareDanmaku(life, vel, YHDanmaku.Bullet.BUBBLE, DyeColor.YELLOW);
                    e.m_146884_(pos);
                    holder.shoot(e);
                }
            }
            super.tick(holder, card);
            return (double)this.tick > this.duration;
        }
    }
}

