/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.entity.rumia;

import dev.xkmc.l2library.util.math.MathHelper;
import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.l2serial.serialization.codec.TagCodec;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.IYHDanmaku;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.ItemDanmakuEntity;
import dev.xkmc.youkaishomecoming.content.entity.rumia.MoveAroundNestGoal;
import dev.xkmc.youkaishomecoming.content.entity.rumia.MoveRandomlyGoal;
import dev.xkmc.youkaishomecoming.content.entity.rumia.RestrictData;
import dev.xkmc.youkaishomecoming.content.entity.rumia.RumiaAttackGoal;
import dev.xkmc.youkaishomecoming.content.entity.rumia.RumiaParalyzeGoal;
import dev.xkmc.youkaishomecoming.content.entity.rumia.RumiaStateMachine;
import dev.xkmc.youkaishomecoming.content.entity.rumia.RumiaTemptGoal;
import dev.xkmc.youkaishomecoming.content.entity.youkai.MultiHurtByTargetGoal;
import dev.xkmc.youkaishomecoming.content.entity.youkai.YoukaiEntity;
import dev.xkmc.youkaishomecoming.content.item.danmaku.DanmakuItem;
import dev.xkmc.youkaishomecoming.init.YoukaisHomecoming;
import dev.xkmc.youkaishomecoming.init.data.YHDamageTypes;
import dev.xkmc.youkaishomecoming.init.data.YHModConfig;
import dev.xkmc.youkaishomecoming.init.food.YHFood;
import dev.xkmc.youkaishomecoming.init.registrate.YHCriteriaTriggers;
import dev.xkmc.youkaishomecoming.init.registrate.YHDanmaku;
import dev.xkmc.youkaishomecoming.init.registrate.YHEffects;
import dev.xkmc.youkaishomecoming.init.registrate.YHItems;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

@SerialClass
public class RumiaEntity
extends YoukaiEntity
implements Merchant {
    private static final EntityDimensions FALL = EntityDimensions.m_20395_((float)1.7f, (float)0.4f);
    private static final UUID EXRUMIA = MathHelper.getUUIDFromString((String)"ex_rumia");
    private static final ResourceLocation SPELL_RUMIA = YoukaisHomecoming.loc("rumia");
    private static final ResourceLocation SPELL_EX_RUMIA = YoukaisHomecoming.loc("ex_rumia");
    @SerialClass.SerialField
    public final RumiaStateMachine state = new RumiaStateMachine(this);
    private int tickAggressive;
    int noTargetTime;
    private boolean dropHairband = false;
    private MerchantOffers tradingOffers;
    private Player tradingPlayer;

    public RumiaEntity(EntityType<? extends RumiaEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21530_();
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (this.m_5912_()) {
            return InteractionResult.PASS;
        }
        if (!player.m_21023_((MobEffect)YHEffects.YOUKAIFIED.get())) {
            return InteractionResult.PASS;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            this.openMenu(this, (Player)sp);
        }
        return InteractionResult.SUCCESS;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(3, (Goal)new RumiaParalyzeGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new RumiaAttackGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new RumiaTemptGoal(this, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)YHFood.FLESH_CHOCOLATE_MOUSSE.item.get()})));
        this.f_21345_.m_25352_(6, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new MoveAroundNestGoal(this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new MoveRandomlyGoal(this, 0.8));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 24.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new MultiHurtByTargetGoal(this, RumiaEntity.class));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, this::wouldAttack));
    }

    private boolean wouldAttack(LivingEntity entity) {
        if (this.shouldIgnore(entity)) {
            return false;
        }
        return entity.m_21023_((MobEffect)YHEffects.YOUKAIFYING.get());
    }

    public static AttributeSupplier.Builder createAttributes() {
        return YoukaiEntity.createAttributes().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22281_, 6.0);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        Tag data;
        super.m_7380_(tag);
        if (this.m_21536_() && (data = TagCodec.valueToTag((Object)new RestrictData(this.m_21534_(), this.m_21535_()))) != null) {
            tag.m_128365_("Restrict", data);
        }
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        RestrictData res;
        super.m_7378_(tag);
        Tag data = tag.m_128423_("Restrict");
        if (data != null && (res = (RestrictData)TagCodec.valueFromTag((Tag)data, RestrictData.class)) != null) {
            this.m_21446_(res.center(), (int)res.radius());
        }
    }

    @Override
    public boolean m_6673_(DamageSource source) {
        if (this.isEx() && !source.m_269533_(DamageTypeTags.f_268738_) && !(source.m_7639_() instanceof LivingEntity)) {
            return true;
        }
        return super.m_6673_(source) || source.m_7639_() instanceof RumiaEntity;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            if (this.m_5912_() && !this.isBlocked() && !this.isCharged()) {
                if (this.tickAggressive < 20) {
                    ++this.tickAggressive;
                }
            } else if (this.tickAggressive > 0) {
                --this.tickAggressive;
            }
        }
    }

    @Override
    public boolean shouldShowSpellCircle() {
        return !this.isBlocked() && !this.isCharged() && this.tickAggressive != 0;
    }

    @Override
    @Nullable
    public ResourceLocation getSpellCircle() {
        if (!this.shouldShowSpellCircle()) {
            return null;
        }
        return this.isEx() ? SPELL_EX_RUMIA : SPELL_RUMIA;
    }

    @Override
    public float getCircleSize(float pTick) {
        return this.isBlocked() || this.isCharged() || this.tickAggressive == 0 ? 0.0f : Math.min(1.0f, ((float)this.tickAggressive + pTick) / 20.0f);
    }

    public boolean m_7301_(MobEffectInstance ins) {
        return !this.isEx() && super.m_7301_(ins);
    }

    public boolean canSwimInFluidType(FluidType type) {
        return this.isEx() || super.canSwimInFluidType(type);
    }

    public boolean m_5825_() {
        return this.isEx();
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        this.state.tick();
        if (this.isEx() && !this.m_21221_().isEmpty()) {
            this.m_21219_();
        }
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        if (this.isEx() && (this.m_5448_() == null || !this.m_5448_().m_6084_())) {
            ++this.noTargetTime;
            if (this.noTargetTime >= 20 && this.f_19797_ % 20 == 0 && ((Boolean)YHModConfig.COMMON.rumiaNoTargetHealing.get()).booleanValue() && this.m_21223_() < this.m_21233_()) {
                this.m_21153_(this.m_21233_());
            }
        }
    }

    public boolean isCharged() {
        return this.state != null && this.m_6084_() && this.state.isCharged();
    }

    public boolean isBlocked() {
        return this.state != null && this.m_6084_() && this.state.isBlocked();
    }

    public boolean isEx() {
        return this.getFlag(4);
    }

    public void setEx(boolean ex) {
        AttributeInstance hp = this.m_21051_(Attributes.f_22276_);
        AttributeInstance atk = this.m_21051_(Attributes.f_22281_);
        assert (hp != null && atk != null);
        if (ex) {
            hp.m_22125_(new AttributeModifier(EXRUMIA, "ex_rumia", 4.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
            atk.m_22125_(new AttributeModifier(EXRUMIA, "ex_rumia", 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
        } else {
            hp.m_22120_(EXRUMIA);
            atk.m_22120_(EXRUMIA);
        }
        this.m_21153_(this.m_21233_());
        this.setFlag(4, ex);
    }

    public void m_147240_(double pStrength, double pX, double pZ) {
        if (this.isCharged()) {
            return;
        }
        super.m_147240_(pStrength, pX, pZ);
    }

    public boolean m_7327_(Entity target) {
        if (this.isCharged()) {
            boolean success;
            int fire;
            float atk = (float)this.m_21133_(Attributes.f_22281_);
            if (target instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)target;
                atk += EnchantmentHelper.m_44833_((ItemStack)this.m_21205_(), (MobType)le.m_6336_());
            }
            if ((fire = EnchantmentHelper.m_44914_((LivingEntity)this)) > 0) {
                target.m_20254_(fire * 4);
            }
            if (success = target.m_6469_(YHDamageTypes.rumia((LivingEntity)this), atk)) {
                this.m_19970_((LivingEntity)this, target);
                this.m_21335_(target);
            }
            return success;
        }
        return super.m_7327_(target);
    }

    @Override
    protected void m_6475_(DamageSource source, float amount) {
        Entity entity;
        boolean isVoid = source.m_269533_(DamageTypeTags.f_268738_);
        if (!isVoid && !this.isEx() && amount >= this.m_21233_() && ((Boolean)YHModConfig.COMMON.exRumiaConversion.get()).booleanValue()) {
            this.setEx(true);
        }
        if ((entity = source.m_7639_()) instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            this.state.onHurt(le, amount);
        }
        if (!isVoid && ((Boolean)YHModConfig.COMMON.rumiaDamageCap.get()).booleanValue()) {
            int reduction = this.isEx() ? 20 : 5;
            amount = Math.min(this.m_21233_() / (float)reduction, amount);
        }
        super.m_6475_(source, amount);
    }

    protected float m_6431_(Pose pose, EntityDimensions dim) {
        return this.isBlocked() ? dim.f_20378_ / 2.0f : super.m_6431_(pose, dim);
    }

    public EntityDimensions m_6972_(Pose pPose) {
        return this.isBlocked() ? FALL.m_20388_(this.m_6134_()) : super.m_6972_(pPose);
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (DATA_FLAGS_ID.equals(pKey)) {
            this.m_6210_();
        }
    }

    @Override
    public void onDanmakuHit(LivingEntity e, IYHDanmaku danmaku) {
        ItemDanmakuEntity d;
        Item item;
        if (e instanceof YoukaiEntity || e.m_21023_((MobEffect)YHEffects.YOUKAIFIED.get())) {
            return;
        }
        if (danmaku instanceof ItemDanmakuEntity && (item = (d = (ItemDanmakuEntity)danmaku).m_7846_().m_41720_()) instanceof DanmakuItem) {
            DanmakuItem item2 = (DanmakuItem)item;
            if (item2.color == DyeColor.BLACK) {
                e.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 100, 1));
                if (!this.isEx()) {
                    return;
                }
            }
        }
        super.onDanmakuHit(e, danmaku);
    }

    public void m_6667_(DamageSource source) {
        this.dropHairband = this.isEx() && source.m_269533_(YHDamageTypes.DANMAKU_TYPE) && source.m_7639_() instanceof Player;
        super.m_6667_(source);
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.dropHairband && ((Boolean)YHModConfig.COMMON.rumiaHairbandDrop.get()).booleanValue()) {
            ItemStack stack = YHItems.RUMIA_HAIRBAND.asStack();
            stack.m_41721_(stack.m_41776_());
            this.m_19983_(stack);
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance diff, MobSpawnType reason, @Nullable SpawnGroupData data, @Nullable CompoundTag nbt) {
        if (reason == MobSpawnType.NATURAL || reason == MobSpawnType.STRUCTURE) {
            this.m_21446_(this.m_20183_(), 8);
        }
        return super.m_6518_(level, diff, reason, data, nbt);
    }

    public static boolean checkRumiaSpawnRules(EntityType<RumiaEntity> e, ServerLevelAccessor level, MobSpawnType type, BlockPos pos, RandomSource rand) {
        return RumiaEntity.m_217057_(e, (LevelAccessor)level, (MobSpawnType)type, (BlockPos)pos, (RandomSource)rand) && (Boolean)YHModConfig.COMMON.rumiaNaturalSpawn.get() != false && level.m_45976_(RumiaEntity.class, AABB.m_165882_((Vec3)pos.m_252807_(), (double)48.0, (double)24.0, (double)48.0)).isEmpty();
    }

    public void openMenu(RumiaEntity rumia, Player player) {
        if (this.tradingPlayer != null && this.tradingPlayer.m_6084_()) {
            return;
        }
        this.init(player);
        this.m_45301_(player, rumia.m_7755_(), 0);
    }

    private static MerchantOffers getOfferList() {
        MerchantOffers ans = new MerchantOffers();
        ans.add((Object)new MerchantOffer(YHFood.COOKED_FLESH.item.asStack(1), YHFood.FLESH.item.asStack(), 64, 0, 0.0f));
        ans.add((Object)RumiaEntity.offer(4, YHDanmaku.Bullet.CIRCLE.get(DyeColor.RED).asStack(8)));
        ans.add((Object)RumiaEntity.offer(4, YHDanmaku.Bullet.BALL.get(DyeColor.RED).asStack(8)));
        ans.add((Object)RumiaEntity.offer(4, YHDanmaku.Bullet.BUTTERFLY.get(DyeColor.RED).asStack(8)));
        ans.add((Object)RumiaEntity.offer(8, YHDanmaku.Bullet.MENTOS.get(DyeColor.RED).asStack(8)));
        ans.add((Object)RumiaEntity.offer(16, YHDanmaku.Bullet.BUBBLE.get(DyeColor.RED).asStack(8)));
        ans.add((Object)RumiaEntity.offer(32, YHDanmaku.Laser.LASER.get(DyeColor.RED).asStack(8)));
        return ans;
    }

    private static MerchantOffer offer(int a, ItemStack b) {
        return new MerchantOffer(YHFood.FLESH_CHOCOLATE_MOUSSE.item.asStack(a), b, 64, 0, 0.0f);
    }

    public void init(Player player) {
        this.tradingPlayer = player;
    }

    public void m_7189_(@Nullable Player player) {
        this.tradingPlayer = player;
    }

    @Nullable
    public Player m_7962_() {
        return this.tradingPlayer;
    }

    public MerchantOffers m_6616_() {
        if (this.tradingOffers == null) {
            this.tradingOffers = RumiaEntity.getOfferList();
        }
        return this.tradingOffers;
    }

    public void m_6255_(MerchantOffers offers) {
        this.tradingOffers = offers;
    }

    public void m_6996_(MerchantOffer offer) {
        Player player = this.tradingPlayer;
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            if (offer.m_45358_().m_150930_((Item)YHFood.FLESH_CHOCOLATE_MOUSSE.item.get())) {
                YHCriteriaTriggers.TRADE.m_222618_(sp);
            }
        }
    }

    public void m_7713_(ItemStack pStack) {
    }

    public int m_7809_() {
        return 0;
    }

    public void m_6621_(int pXp) {
    }

    public boolean m_7826_() {
        return false;
    }

    public SoundEvent m_7596_() {
        return SoundEvents.f_11785_;
    }

    public boolean m_183595_() {
        return false;
    }
}

