/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.entity.danmaku;

import dev.xkmc.fastprojectileapi.entity.ProjectileMovement;
import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.YHBaseLaserEntity;
import dev.xkmc.youkaishomecoming.content.item.danmaku.LaserItem;
import dev.xkmc.youkaishomecoming.content.spell.mover.DanmakuMover;
import dev.xkmc.youkaishomecoming.content.spell.mover.MoverInfo;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

@SerialClass
public class ItemLaserEntity
extends YHBaseLaserEntity
implements ItemSupplier {
    private static final EntityDataAccessor<ItemStack> DATA_ITEM_STACK = SynchedEntityData.m_135353_(ItemLaserEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    @SerialClass.SerialField
    public DanmakuMover mover;
    private Float sizeCache = null;

    public ItemLaserEntity(EntityType<? extends ItemLaserEntity> pEntityType, Level pLevel) {
        super((EntityType<? extends YHBaseLaserEntity>)pEntityType, pLevel);
    }

    public ItemLaserEntity(EntityType<? extends ItemLaserEntity> pEntityType, double pX, double pY, double pZ, Level pLevel) {
        super(pEntityType, pX, pY, pZ, pLevel);
    }

    public ItemLaserEntity(EntityType<? extends ItemLaserEntity> pEntityType, LivingEntity pShooter, Level pLevel) {
        super(pEntityType, pShooter, pLevel);
    }

    @Override
    protected void danmakuMove() {
        ProjectileMovement movement = this.updateVelocity(this.m_20184_(), this.m_20182_());
        this.m_20256_(movement.vec());
        this.updateRotation(movement.rot());
        double d2 = this.m_20185_() + movement.vec().f_82479_;
        double d0 = this.m_20186_() + movement.vec().f_82480_;
        double d1 = this.m_20189_() + movement.vec().f_82481_;
        this.m_6034_(d2, d0, d1);
    }

    protected ProjectileMovement updateVelocity(Vec3 vec, Vec3 pos) {
        if (this.mover != null) {
            return this.mover.move(new MoverInfo(this.f_19797_, pos, vec, this));
        }
        return new ProjectileMovement(vec, this.rot());
    }

    public void setItem(ItemStack pStack) {
        this.m_20088_().m_135381_(DATA_ITEM_STACK, (Object)pStack.m_255036_(1));
        this.m_6210_();
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (DATA_ITEM_STACK == key) {
            this.m_6210_();
        }
    }

    protected ItemStack getItemRaw() {
        return (ItemStack)this.m_20088_().m_135370_(DATA_ITEM_STACK);
    }

    public ItemStack m_7846_() {
        return this.getItemRaw();
    }

    @Override
    protected void m_8097_() {
        this.m_20088_().m_135372_(DATA_ITEM_STACK, (Object)ItemStack.f_41583_);
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        ItemStack itemstack = this.getItemRaw();
        if (!itemstack.m_41619_()) {
            nbt.m_128365_("Item", (Tag)itemstack.m_41739_(new CompoundTag()));
        }
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        ItemStack itemstack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Item"));
        this.setItem(itemstack);
    }

    public EntityDimensions m_6972_(Pose pPose) {
        return super.m_6972_(pPose).m_20388_(this.scale());
    }

    public boolean fullBright() {
        return true;
    }

    public float scale() {
        Item item;
        if (this.sizeCache == null && (item = this.m_7846_().m_41720_()) instanceof LaserItem) {
            LaserItem item2 = (LaserItem)item;
            this.sizeCache = Float.valueOf(item2.size);
        }
        return this.sizeCache == null ? 1.0f : this.sizeCache.floatValue();
    }
}

