/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.block.plant;

import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.loot.RegistrateBlockLootTables;
import dev.xkmc.youkaishomecoming.content.block.plant.DoubleCropBlock;
import dev.xkmc.youkaishomecoming.init.food.YHCrops;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;

public class TeaCropBlock
extends DoubleCropBlock {
    private static final VoxelShape SMALL = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)11.0, (double)13.0);
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0)};
    public static final IntegerProperty AGE = IntegerProperty.m_61631_((String)"age", (int)0, (int)6);
    private final Supplier<Item> seed;

    public TeaCropBlock(BlockBehaviour.Properties prop, Supplier<Item> seed) {
        super(prop);
        this.seed = seed;
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE, HALF});
    }

    protected IntegerProperty m_7959_() {
        return AGE;
    }

    public int m_7419_() {
        return 6;
    }

    @Deprecated
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (((Integer)state.m_61143_((Property)AGE)).intValue() != this.m_7419_() && player.m_21120_(hand).m_150930_(Items.f_42499_)) {
            return InteractionResult.PASS;
        }
        if (state.m_61143_((Property)HALF) == DoubleBlockHalf.UPPER) {
            state = level.m_8055_(pos.m_7495_());
            pos = pos.m_7495_();
        }
        if (state.m_60713_((Block)this) && state.m_61143_((Property)HALF) == DoubleBlockHalf.LOWER && ((Integer)state.m_61143_((Property)AGE)).intValue() == this.m_7419_()) {
            if (!level.m_5776_()) {
                int j = 1 + level.f_46441_.m_188503_(2);
                TeaCropBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)YHCrops.TEA.getFruits(), j));
                if (level.f_46441_.m_188503_(8) == 0) {
                    TeaCropBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)YHCrops.TEA.getSeed(), j));
                }
                level.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
                BlockState blockstate = (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(5));
                this.setGrowth(level, pos, 5, 2);
                level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)blockstate));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, hand, result);
    }

    protected boolean m_6266_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return super.m_6266_(pState, pLevel, pPos);
    }

    protected ItemLike m_6404_() {
        return (ItemLike)this.seed.get();
    }

    @Override
    public int getDoubleBlockStart() {
        return 6;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        int age = this.m_52305_(pState);
        if (age <= 4) {
            return SHAPE_BY_AGE[age];
        }
        if (age == 5) {
            return SMALL;
        }
        if (age == 6 && pState.m_61143_((Property)HALF) == DoubleBlockHalf.UPPER) {
            return SHAPE_BY_AGE[5];
        }
        return Shapes.m_83144_();
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        int age = this.m_52305_(state);
        if (state.m_61143_((Property)HALF) == DoubleBlockHalf.LOWER) {
            if (age == 5) {
                return SMALL;
            }
            if (age == 6) {
                return Shapes.m_83144_();
            }
        }
        return Shapes.m_83040_();
    }

    public static void buildPlantModel(DataGenContext<Block, TeaCropBlock> ctx, RegistrateBlockstateProvider pvd, String name) {
        pvd.getVariantBuilder((Block)ctx.get()).forAllStates(state -> {
            int age = (Integer)state.m_61143_((Property)AGE);
            String tex = name + "_stage" + age;
            if (state.m_61143_((Property)HALF) == DoubleBlockHalf.UPPER) {
                return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)pvd.models().withExistingParent(tex + "_upper", pvd.mcLoc("block/air"))).texture("particle", pvd.modLoc("block/" + name + "_bush_leaves"))).build();
            }
            if (age <= 4) {
                return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)pvd.models().cross(tex, pvd.modLoc("block/" + tex))).renderType("cutout")).build();
            }
            BlockModelBuilder file = (BlockModelBuilder)((BlockModelBuilder)pvd.models().getBuilder("block/" + tex)).parent((ModelFile)new ModelFile.UncheckedModelFile(pvd.modLoc("custom/" + tex)));
            file.ao(false);
            file.renderType("cutout");
            if (age == 5) {
                file.texture("base", pvd.modLoc("block/" + name + "_stage5"));
            } else {
                file.texture("leaves", pvd.modLoc("block/" + name + "_bush_leaves"));
                file.texture("trunk", pvd.modLoc("block/" + name + "_bush_trunk"));
            }
            file.texture("top", pvd.modLoc("block/" + name + "_bush_top"));
            file.texture("side", pvd.modLoc("block/" + name + "_bush_side"));
            return ConfiguredModel.builder().modelFile((ModelFile)file).build();
        });
    }

    public static void buildPlantLoot(RegistrateBlockLootTables pvd, TeaCropBlock block, YHCrops crop) {
        pvd.m_247577_((Block)block, (LootTable.Builder)pvd.m_246108_((ItemLike)block, (FunctionUserBuilder)LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)crop.getSeed())).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)HALF, (Comparable)DoubleBlockHalf.LOWER)))).m_79161_(LootPool.m_79043_().m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CropBlock.f_52244_, 6))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)crop.getFruits()).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.5714286f, (int)3))).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)HALF, (Comparable)DoubleBlockHalf.LOWER))))));
    }

    public static void buildWildLoot(RegistrateBlockLootTables pvd, BushBlock block, YHCrops crop) {
        pvd.m_247577_((Block)block, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)block.m_5456_()).m_79080_(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1)))))).m_7170_((LootPoolEntryContainer.Builder)pvd.m_246108_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)crop.getSeed()).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.5714286f, (int)3)))))));
    }
}

