/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fastprojectileapi.entity;

import dev.xkmc.fastprojectileapi.entity.SimplifiedEntity;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;

public abstract class SimplifiedProjectile
extends SimplifiedEntity
implements TraceableEntity,
IEntityAdditionalSpawnData {
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private Entity cachedOwner;

    public SimplifiedProjectile(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public boolean canHitEntity(Entity target) {
        if (!target.m_271807_()) {
            return false;
        }
        Entity entity = this.m_19749_();
        if (entity == null || entity == target) {
            return false;
        }
        if ((entity.m_20159_() || target.m_20159_()) && entity.m_20365_(target)) {
            return false;
        }
        return !entity.m_7307_(target);
    }

    public void m_6001_(double pX, double pY, double pZ) {
        this.m_20334_(pX, pY, pZ);
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            double d0 = Math.sqrt(pX * pX + pZ * pZ);
            this.m_146926_((float)(-(Mth.m_14136_((double)pY, (double)d0) * 57.2957763671875)));
            this.m_146922_((float)(-(Mth.m_14136_((double)pX, (double)pZ) * 57.2957763671875)));
            this.f_19860_ = this.m_146909_();
            this.f_19859_ = this.m_146908_();
            this.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
        }
    }

    public Vec3 rot() {
        return new Vec3((double)(this.m_146909_() * ((float)Math.PI / 180)), (double)(this.m_146908_() * ((float)Math.PI / 180)), 0.0);
    }

    protected void updateRotation(Vec3 rot) {
        this.m_146926_(SimplifiedProjectile.lerpRotation(this.f_19860_, (float)(rot.f_82479_ * 57.2957763671875)));
        this.m_146922_(SimplifiedProjectile.lerpRotation(this.f_19859_, (float)(rot.f_82480_ * 57.2957763671875)));
    }

    protected static float lerpRotation(float pCurrentRotation, float pTargetRotation) {
        while (pTargetRotation - pCurrentRotation < -180.0f) {
            pCurrentRotation -= 360.0f;
        }
        while (pTargetRotation - pCurrentRotation >= 180.0f) {
            pCurrentRotation += 360.0f;
        }
        return Mth.m_14179_((float)0.2f, (float)pCurrentRotation, (float)pTargetRotation);
    }

    public void setOwner(@Nullable Entity pOwner) {
        if (pOwner != null) {
            this.ownerUUID = pOwner.m_20148_();
            this.cachedOwner = pOwner;
        }
    }

    @Nullable
    public Entity m_19749_() {
        if (this.cachedOwner != null && !this.cachedOwner.m_213877_()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null && this.m_9236_() instanceof ServerLevel) {
            this.cachedOwner = ((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    @OverridingMethodsMustInvokeSuper
    protected void m_7380_(CompoundTag nbt) {
        if (this.ownerUUID != null) {
            nbt.m_128362_("Owner", this.ownerUUID);
        }
        nbt.m_128405_("Age", this.f_19797_);
    }

    @OverridingMethodsMustInvokeSuper
    protected void m_7378_(CompoundTag nbt) {
        if (nbt.m_128403_("Owner")) {
            this.ownerUUID = nbt.m_128342_("Owner");
            this.cachedOwner = null;
        }
        this.f_19797_ = nbt.m_128451_("Age");
    }

    @OverridingMethodsMustInvokeSuper
    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeLong(this.m_9236_().m_46467_() - (long)this.f_19797_);
        Entity owner = this.m_19749_();
        buffer.writeInt(owner == null ? -1 : owner.m_19879_());
    }

    @OverridingMethodsMustInvokeSuper
    public void readSpawnData(FriendlyByteBuf additionalData) {
        Entity e;
        this.f_19797_ = (int)(this.m_9236_().m_46467_() - additionalData.readLong());
        int id = additionalData.readInt();
        if (id >= 0 && (e = this.m_9236_().m_6815_(id)) != null) {
            this.setOwner(e);
        }
    }
}

