/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fastprojectileapi.collision;

import dev.xkmc.fastprojectileapi.collision.EntityStorageCache;
import dev.xkmc.fastprojectileapi.entity.BaseLaser;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class LaserHitHelper {
    public static LaserHitResult getHitResultOnProjection(BaseLaser e, boolean checkBlock, boolean checkEntity) {
        Vec3 src = e.m_20182_().m_82520_(0.0, (double)(e.m_20206_() / 2.0f), 0.0);
        Vec3 v = e.m_20156_().m_82490_(e.getLength());
        Level level = e.m_9236_();
        Vec3 dst = src.m_82549_(v);
        BlockHitResult bhit = null;
        if (checkBlock) {
            bhit = level.m_45547_(new ClipContext(src, dst, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)e));
            if (bhit.m_6662_() != HitResult.Type.MISS) {
                dst = bhit.m_82450_();
            } else {
                bhit = null;
            }
        }
        ArrayList<EntityHitResult> ehit = new ArrayList<EntityHitResult>();
        if (checkEntity && level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            LaserHitHelper.getEntityHitResult(ehit, sl, e, src, dst, e.m_20191_().m_82369_(v), e.getEffectiveHitRadius());
        }
        return new LaserHitResult(dst, bhit, ehit);
    }

    public static void getEntityHitResult(List<EntityHitResult> ans, ServerLevel level, BaseLaser self, Vec3 src, Vec3 dst, AABB box, float radius) {
        for (Entity e : EntityStorageCache.get(level).foreach(box.m_82400_((double)(1.0f + radius)), self::canHitEntity)) {
            if (e == self) continue;
            AABB aabb = e.m_20191_().m_82400_((double)radius);
            Optional optional = aabb.m_82371_(src, dst);
            optional.ifPresent(vec3 -> ans.add(new EntityHitResult(e, vec3)));
        }
    }

    public record LaserHitResult(Vec3 dst, @Nullable BlockHitResult bhit, List<EntityHitResult> ehit) {
    }
}

