/*
 * Decompiled with CFR 0.152.
 */
package net.grid.vampiresdelight.integration.jei.category;

import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.grid.vampiresdelight.common.registry.VDItems;
import net.grid.vampiresdelight.common.utility.VDTextUtils;
import net.grid.vampiresdelight.integration.jei.VDJEIRecipeTypes;
import net.grid.vampiresdelight.integration.jei.resource.VDJEIPouringRecipe;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class VDJEIPouringRecipeCategory
implements IRecipeCategory<VDJEIPouringRecipe> {
    private final Component title = VDTextUtils.getTranslation("jei.pouring", new Object[0]);
    private final IDrawable background;
    private final IDrawable icon;

    public VDJEIPouringRecipeCategory(IGuiHelper helper) {
        ResourceLocation texture = new ResourceLocation("vampiresdelight", "textures/gui/jei/pouring.png");
        this.background = helper.createDrawable(texture, 0, 0, 117, 57);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)VDItems.BLOOD_WINE_GLASS.get()));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, VDJEIPouringRecipe recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 19, 12).addItemStack(recipe.tool())).setSlotName("Bottle");
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 83, 12).addItemStack(recipe.servingContainer())).setSlotName("ServingContainer");
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 52, 31).addItemStack(recipe.result())).setSlotName("Drink");
    }

    public RecipeType<VDJEIPouringRecipe> getRecipeType() {
        return VDJEIRecipeTypes.POURING;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }
}

