/*
 * Decompiled with CFR 0.152.
 */
package net.grid.vampiresdelight.data;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.grid.vampiresdelight.common.registry.VDItems;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import vectorwing.farmersdelight.data.ItemModels;

public class VDItemModels
extends ItemModelProvider {
    public static final String GENERATED = "item/generated";
    public static final String HANDHELD = "item/handheld";
    public static final ResourceLocation COCKTAIL = new ResourceLocation("vampiresdelight", "item/cocktail");
    public static final ResourceLocation POURING = VDItemModels.resourceItem("template_bottle_pouring");

    public VDItemModels(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "vampiresdelight", existingFileHelper);
    }

    protected void registerModels() {
        Set<Item> items = ForgeRegistries.ITEMS.getValues().stream().filter(i -> "vampiresdelight".equals(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey(i)).m_135827_())).collect(Collectors.toSet());
        HashSet specialItems = Sets.newHashSet((Object[])new Item[]{(Item)VDItems.SPIRIT_LANTERN.get()});
        ItemModels.takeAll(items, (Object[])specialItems.toArray(new Item[0])).forEach(items::remove);
        HashSet mugItems = Sets.newHashSet((Object[])new Item[]{(Item)VDItems.DAISY_TEA.get(), (Item)VDItems.ORCHID_TEA.get(), (Item)VDItems.MULLED_WINE_GLASS.get(), (Item)VDItems.DANDELION_BEER_MUG.get()});
        ItemModels.takeAll(items, (Object[])mugItems.toArray(new Item[0])).forEach(item -> this.itemMugModel((Item)item, VDItemModels.resourceItem(VDItemModels.itemName(item))));
        HashSet cocktailItems = Sets.newHashSet((Object[])new Item[]{(Item)VDItems.BLOOD_WINE_GLASS.get()});
        ItemModels.takeAll(items, (Object[])cocktailItems.toArray(new Item[0])).forEach(item -> this.itemCocktailModel((Item)item, VDItemModels.resourceItem(VDItemModels.itemName(item))));
        HashSet pouringItems = Sets.newHashSet((Object[])new Item[]{(Item)VDItems.DANDELION_BEER_BOTTLE.get(), (Item)VDItems.BLOOD_WINE_BOTTLE.get()});
        pouringItems.forEach(this::itemPouringModel);
        this.alchemicalCocktailModel((Item)VDItems.ALCHEMICAL_COCKTAIL.get());
        HashSet spriteBlockItems = Sets.newHashSet((Object[])new Item[]{(Item)VDItems.BLOOD_PIE.get(), (Item)VDItems.ORCHID_SEEDS.get(), (Item)VDItems.WEIRD_JELLY_BLOCK.get(), (Item)VDItems.ORCHID_CAKE.get()});
        ItemModels.takeAll(items, (Object[])spriteBlockItems.toArray(new Item[0])).forEach(item -> ((ItemModelBuilder)this.withExistingParent(VDItemModels.itemName(item), GENERATED)).texture("layer0", VDItemModels.resourceItem(VDItemModels.itemName(item))));
        HashSet flatBlockItems = Sets.newHashSet((Object[])new Item[]{(Item)VDItems.WILD_GARLIC.get(), (Item)VDItems.BLACK_MUSHROOM.get()});
        ItemModels.takeAll(items, (Object[])flatBlockItems.toArray(new Item[0])).forEach(item -> this.itemGeneratedModel((Item)item, VDItemModels.resourceBlock(VDItemModels.itemName(item))));
        HashSet inventoryBlockItems = Sets.newHashSet((Object[])new Item[]{(Item)VDItems.BLACK_MUSHROOM_BLOCK.get(), (Item)VDItems.BLACK_MUSHROOM_STEM.get()});
        ItemModels.takeAll(items, (Object[])inventoryBlockItems.toArray(new Item[0])).forEach(item -> this.blockBasedModel((Item)item, "_inventory"));
        ItemModels.takeAll(items, i -> i instanceof BlockItem).forEach(item -> this.blockBasedModel((Item)item, ""));
        HashSet handheldItems = Sets.newHashSet((Object[])new Item[]{(Item)VDItems.TRICOLOR_DANGO.get(), (Item)VDItems.EYES_ON_STICK.get(), (Item)VDItems.SILVER_KNIFE.get()});
        ItemModels.takeAll(items, (Object[])handheldItems.toArray(new Item[0])).forEach(item -> this.itemHandheldModel((Item)item, VDItemModels.resourceItem(VDItemModels.itemName(item))));
        items.forEach(item -> this.itemGeneratedModel((Item)item, VDItemModels.resourceItem(VDItemModels.itemName(item))));
    }

    public void blockBasedModel(Item item, String suffix) {
        this.withExistingParent(VDItemModels.itemName(item), VDItemModels.resourceBlock(VDItemModels.itemName(item) + suffix));
    }

    public void itemHandheldModel(Item item, ResourceLocation texture) {
        ((ItemModelBuilder)this.withExistingParent(VDItemModels.itemName(item), HANDHELD)).texture("layer0", texture);
    }

    public void itemGeneratedModel(Item item, ResourceLocation texture) {
        ((ItemModelBuilder)this.withExistingParent(VDItemModels.itemName(item), GENERATED)).texture("layer0", texture);
    }

    public void itemMugModel(Item item, ResourceLocation texture) {
        ((ItemModelBuilder)this.withExistingParent(VDItemModels.itemName(item), ItemModels.MUG)).texture("layer0", texture);
    }

    public void itemCocktailModel(Item item, ResourceLocation texture) {
        ((ItemModelBuilder)this.withExistingParent(VDItemModels.itemName(item), COCKTAIL)).texture("layer0", texture);
    }

    public void itemPouringModel(Item item) {
        ResourceLocation texture = VDItemModels.resourceItem(VDItemModels.itemName(item));
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(VDItemModels.itemName(item), GENERATED)).texture("layer0", texture)).override().predicate(this.modLoc("pouring"), 0.01f).model((ModelFile)((ItemModelBuilder)this.withExistingParent(VDItemModels.itemName(item) + "_pouring", POURING)).texture("layer0", texture));
    }

    public void alchemicalCocktailModel(Item item) {
        ResourceLocation texture = VDItemModels.resourceItem(VDItemModels.itemName(item));
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(VDItemModels.itemName(item), GENERATED)).texture("layer0", texture)).override().predicate(this.modLoc("metal_pipe"), 0.01f).model((ModelFile)((ItemModelBuilder)this.withExistingParent(VDItemModels.itemName(item) + "_metal_pipe", GENERATED)).texture("layer0", VDItemModels.resourceItem("metal_pipe")));
    }

    private static String itemName(Item item) {
        return Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item)).m_135815_();
    }

    private static ResourceLocation resourceBlock(String path) {
        return VDItemModels.modLocation("block/" + path);
    }

    private static ResourceLocation resourceItem(String path) {
        return VDItemModels.modLocation("item/" + path);
    }

    private static ResourceLocation modLocation(String path) {
        return new ResourceLocation("vampiresdelight", path);
    }
}

