/*
 * Decompiled with CFR 0.152.
 */
package net.grid.vampiresdelight.common.world.feature;

import com.mojang.serialization.Codec;
import java.util.function.BiPredicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.grid.vampiresdelight.common.registry.VDBlocks;
import net.grid.vampiresdelight.common.tag.VDTags;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class HugeBlackMushroomFeature
extends Feature<NoneFeatureConfiguration> {
    protected final BiPredicate<WorldGenLevel, BlockPos> replace = (worldGenLevel, blockPos) -> TreeFeature.m_67267_((LevelSimulatedReader)worldGenLevel, (BlockPos)blockPos) || worldGenLevel.m_8055_(blockPos).m_60734_() instanceof BushBlock;
    protected final BiPredicate<WorldGenLevel, BlockPos> placeOn = (worldGenLevel, blockPos) -> worldGenLevel.m_8055_(blockPos).m_204336_(VDTags.BLACK_MUSHROOM_GROW_BLOCK);

    public HugeBlackMushroomFeature(Codec<NoneFeatureConfiguration> pCodec) {
        super(pCodec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> pContext) {
        int height;
        WorldGenLevel worldLevel = pContext.m_159774_();
        RandomSource randomSource = pContext.m_225041_();
        BlockPos originPos = pContext.m_159777_();
        BlockState mushroomStem = ((HugeMushroomBlock)VDBlocks.BLACK_MUSHROOM_STEM.get()).m_49966_();
        BlockState mushroomCap = (BlockState)((HugeMushroomBlock)VDBlocks.BLACK_MUSHROOM_BLOCK.get()).m_49966_().m_61124_((Property)HugeMushroomBlock.f_54132_, (Comparable)Boolean.valueOf(false));
        int stemHeight = 2 + randomSource.m_188503_(3);
        int lowestPartHeight = randomSource.m_188503_(2);
        int middlePartHeight = 1 + randomSource.m_188503_(2);
        int topPartHeight = 2 + randomSource.m_188503_(2);
        while (originPos.m_123342_() >= worldLevel.m_141937_() + 1 && this.replace.test(worldLevel, originPos)) {
            originPos = originPos.m_7495_();
        }
        if (!this.placeOn.test(worldLevel, originPos.m_7918_(0, 0, 0)) && !this.checkSpace(worldLevel, originPos.m_7494_())) {
            return false;
        }
        BlockPos pos = originPos.m_7494_();
        for (int height2 = 0; height2 < stemHeight; ++height2) {
            this.setBlock(worldLevel, pos.m_6630_(height2), mushroomStem);
        }
        BlockPos highestPos = pos.m_7918_(0, stemHeight, 0);
        this.setBlock(worldLevel, highestPos.m_7918_(-1, -1, 2), (BlockState)mushroomCap.m_61124_((Property)HugeMushroomBlock.f_54127_, (Comparable)Boolean.valueOf(false)));
        this.setBlock(worldLevel, highestPos.m_7918_(0, -1, 2), (BlockState)mushroomCap.m_61124_((Property)HugeMushroomBlock.f_54127_, (Comparable)Boolean.valueOf(false)));
        this.setBlock(worldLevel, highestPos.m_7918_(1, -1, 2), (BlockState)mushroomCap.m_61124_((Property)HugeMushroomBlock.f_54127_, (Comparable)Boolean.valueOf(false)));
        this.setBlock(worldLevel, highestPos.m_7918_(0, 0, 2), (BlockState)mushroomCap.m_61124_((Property)HugeMushroomBlock.f_54127_, (Comparable)Boolean.valueOf(false)));
        this.setBlock(worldLevel, highestPos.m_7918_(2, -1, -1), (BlockState)mushroomCap.m_61124_((Property)HugeMushroomBlock.f_54130_, (Comparable)Boolean.valueOf(false)));
        this.setBlock(worldLevel, highestPos.m_7918_(2, -1, 0), (BlockState)mushroomCap.m_61124_((Property)HugeMushroomBlock.f_54130_, (Comparable)Boolean.valueOf(false)));
        this.setBlock(worldLevel, highestPos.m_7918_(2, -1, 1), (BlockState)mushroomCap.m_61124_((Property)HugeMushroomBlock.f_54130_, (Comparable)Boolean.valueOf(false)));
        this.setBlock(worldLevel, highestPos.m_7918_(2, 0, 0), (BlockState)mushroomCap.m_61124_((Property)HugeMushroomBlock.f_54130_, (Comparable)Boolean.valueOf(false)));
        this.setBlock(worldLevel, highestPos.m_7918_(-1, -1, -2), (BlockState)mushroomCap.m_61124_((Property)HugeMushroomBlock.f_54129_, (Comparable)Boolean.valueOf(false)));
        this.setBlock(worldLevel, highestPos.m_7918_(0, -1, -2), (BlockState)mushroomCap.m_61124_((Property)HugeMushroomBlock.f_54129_, (Comparable)Boolean.valueOf(false)));
        this.setBlock(worldLevel, highestPos.m_7918_(1, -1, -2), (BlockState)mushroomCap.m_61124_((Property)HugeMushroomBlock.f_54129_, (Comparable)Boolean.valueOf(false)));
        this.setBlock(worldLevel, highestPos.m_7918_(0, 0, -2), (BlockState)mushroomCap.m_61124_((Property)HugeMushroomBlock.f_54129_, (Comparable)Boolean.valueOf(false)));
        this.setBlock(worldLevel, highestPos.m_7918_(-2, -1, -1), (BlockState)mushroomCap.m_61124_((Property)HugeMushroomBlock.f_54128_, (Comparable)Boolean.valueOf(false)));
        this.setBlock(worldLevel, highestPos.m_7918_(-2, -1, 0), (BlockState)mushroomCap.m_61124_((Property)HugeMushroomBlock.f_54128_, (Comparable)Boolean.valueOf(false)));
        this.setBlock(worldLevel, highestPos.m_7918_(-2, -1, 1), (BlockState)mushroomCap.m_61124_((Property)HugeMushroomBlock.f_54128_, (Comparable)Boolean.valueOf(false)));
        this.setBlock(worldLevel, highestPos.m_7918_(-2, 0, 0), (BlockState)mushroomCap.m_61124_((Property)HugeMushroomBlock.f_54128_, (Comparable)Boolean.valueOf(false)));
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                for (int height3 = 0; height3 <= lowestPartHeight; ++height3) {
                    this.setBlock(worldLevel, highestPos.m_7918_(x, height3, z), mushroomCap);
                }
            }
        }
        highestPos = highestPos.m_6630_(lowestPartHeight);
        for (height = 0; height <= middlePartHeight; ++height) {
            this.setBlock(worldLevel, highestPos.m_7918_(0, height + 1, 0), mushroomCap);
            this.setBlock(worldLevel, highestPos.m_7918_(1, height + 1, 0), mushroomCap);
            this.setBlock(worldLevel, highestPos.m_7918_(-1, height + 1, 0), mushroomCap);
            this.setBlock(worldLevel, highestPos.m_7918_(0, height + 1, 1), mushroomCap);
            this.setBlock(worldLevel, highestPos.m_7918_(0, height + 1, -1), mushroomCap);
        }
        highestPos = highestPos.m_6630_(middlePartHeight);
        for (height = 1; height <= topPartHeight; ++height) {
            this.setBlock(worldLevel, highestPos.m_6630_(height), mushroomCap);
        }
        return true;
    }

    public void setBlock(WorldGenLevel world, BlockPos pos, BlockState state) {
        if (this.replace.test(world, pos)) {
            super.m_5974_((LevelWriter)world, pos, state);
        }
    }

    public boolean checkSpace(WorldGenLevel world, BlockPos pos) {
        for (int y = 0; y <= 13; ++y) {
            for (int x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 2; ++z) {
                    if (pos.m_7918_(x, y, z).m_123342_() < 255 && this.replace.test(world, pos.m_7918_(x, y, z))) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

