/*
 * Decompiled with CFR 0.152.
 */
package net.grid.vampiresdelight.common.utility;

import com.mojang.datafixers.util.Pair;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.entity.player.vampire.IDrinkBloodContext;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.entity.vampire.DrinkBloodContext;
import de.teamlapen.vampirism.util.DamageHandler;
import net.grid.vampiresdelight.common.utility.VDHelper;
import net.grid.vampiresdelight.common.utility.VDIntegrationUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class VDEntityUtils {
    public static void addFoodEffects(FoodProperties foodProperties, Level level, LivingEntity entity) {
        for (Pair pair : foodProperties.m_38749_()) {
            if (level.f_46443_ || pair.getFirst() == null || !(level.f_46441_.m_188501_() < ((Float)pair.getSecond()).floatValue())) continue;
            entity.m_7292_(new MobEffectInstance((MobEffectInstance)pair.getFirst()));
        }
    }

    public static void consumeBloodFood(ItemStack stack, Level level, LivingEntity consumer) {
        VDEntityUtils.feedVampire(stack, level, consumer);
        if (VDHelper.isVampire((Entity)consumer)) {
            Player player;
            FoodProperties foodProperties = stack.getFoodProperties(consumer);
            if (foodProperties != null) {
                VDEntityUtils.addFoodEffects(foodProperties, level, consumer);
            }
            if (consumer instanceof Player && !(player = (Player)consumer).m_7500_() || !(consumer instanceof Player)) {
                stack.m_41774_(1);
            }
        }
    }

    public static void feedVampire(ItemStack stack, Level level, LivingEntity consumer) {
        FoodProperties foodProperties = stack.getFoodProperties(consumer);
        if (foodProperties != null) {
            FoodProperties bloodFoodProperties;
            FoodProperties foodProperties2 = bloodFoodProperties = VDHelper.isVampire((Entity)consumer) ? foodProperties : new FoodProperties.Builder().m_38760_(0).m_38758_(0.0f).m_38767_();
            if (consumer instanceof Player) {
                Player player = (Player)consumer;
                VampirePlayer.getOpt((Player)player).ifPresent(v -> v.drinkBlood(bloodFoodProperties.m_38744_(), bloodFoodProperties.m_38745_(), (IDrinkBloodContext)new DrinkBloodContext(stack)));
            }
            if (consumer instanceof IVampire) {
                ((IVampire)consumer).drinkBlood(bloodFoodProperties.m_38744_(), bloodFoodProperties.m_38745_(), (IDrinkBloodContext)new DrinkBloodContext(stack));
            } else if (!VDHelper.isVampire((Entity)consumer)) {
                consumer.m_5584_(level, stack);
            }
        }
    }

    public static boolean hasPoison(FoodProperties foodProperties) {
        if (foodProperties != null) {
            for (Pair effect : foodProperties.m_38749_()) {
                if (effect.getFirst() == null) continue;
                ((MobEffectInstance)effect.getFirst()).m_19544_();
                if (((MobEffectInstance)effect.getFirst()).m_19544_() != MobEffects.f_19614_) continue;
                return true;
            }
        }
        return false;
    }

    public static void cureEffect(MobEffect mobEffect, LivingEntity entity) {
        if (entity.m_21023_(mobEffect)) {
            entity.m_21195_(mobEffect);
        }
    }

    public static void cureEffects(LivingEntity entity, MobEffect ... mobEffects) {
        for (MobEffect effect : mobEffects) {
            if (!entity.m_21023_(effect)) continue;
            entity.m_21195_(effect);
        }
    }

    public static boolean canConsumeHumanFood(LivingEntity consumer) {
        if (VDHelper.isVampire((Entity)consumer)) {
            return false;
        }
        if (VDIntegrationUtils.isWerewolf((Entity)consumer)) {
            Player player;
            return consumer instanceof Player && VDIntegrationUtils.isWerewolfVegetarian(player = (Player)consumer);
        }
        return true;
    }

    public static void affectVampireEntityWithGarlic(LivingEntity livingEntity, EnumStrength strength) {
        if (livingEntity instanceof IVampire) {
            DamageHandler.affectVampireGarlicDirect((IVampire)((IVampire)livingEntity), (EnumStrength)strength);
        } else if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            VampirePlayer.getOpt((Player)player).ifPresent(vampire -> DamageHandler.affectVampireGarlicDirect((IVampire)vampire, (EnumStrength)strength));
        }
    }

    public static void spawnParticlesAroundEntity(ParticleOptions particle, LivingEntity livingEntity, int amount, double speedMultiplier, double yOffset) {
        for (int i = 0; i <= amount; ++i) {
            double d0 = livingEntity.m_217043_().m_188583_() * speedMultiplier;
            double d1 = livingEntity.m_217043_().m_188583_() * speedMultiplier;
            double d2 = livingEntity.m_217043_().m_188583_() * speedMultiplier;
            livingEntity.m_9236_().m_7106_(particle, livingEntity.m_20208_(1.0), livingEntity.m_20187_() + yOffset, livingEntity.m_20262_(1.0), d0, d1, d2);
        }
    }

    public static void spawnParticlesAroundEntity(ParticleOptions particle, LivingEntity livingEntity, int amount) {
        for (int i = 0; i <= amount; ++i) {
            double d0 = livingEntity.m_217043_().m_188583_() * 0.02;
            double d1 = livingEntity.m_217043_().m_188583_() * 0.02;
            double d2 = livingEntity.m_217043_().m_188583_() * 0.02;
            livingEntity.m_9236_().m_7106_(particle, livingEntity.m_20208_(1.0), livingEntity.m_20187_() + 0.5, livingEntity.m_20262_(1.0), d0, d1, d2);
        }
    }

    public static void spawnBlessingParticlesAroundEntity(ParticleOptions particle, LivingEntity livingEntity, int amount) {
        for (int i = 0; i < amount; ++i) {
            double x = livingEntity.m_20185_() + (double)(2.0f * livingEntity.m_217043_().m_188501_() - 1.0f) * 0.65;
            double y = livingEntity.m_20186_() + 0.1 + (double)livingEntity.m_217043_().m_188501_() * 0.8;
            double z = livingEntity.m_20189_() + (double)(2.0f * livingEntity.m_217043_().m_188501_() - 1.0f) * 0.65;
            livingEntity.m_9236_().m_7106_(particle, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnParticlesOnItemEntityHolding(ParticleOptions particleOptions, LivingEntity livingEntity) {
        Vec3 vec3 = new Vec3(((double)livingEntity.m_217043_().m_188501_() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
        vec3 = vec3.m_82496_(-livingEntity.m_146909_() * ((float)Math.PI / 180));
        vec3 = vec3.m_82524_(-livingEntity.m_146908_() * ((float)Math.PI / 180));
        double d0 = (double)(-livingEntity.m_217043_().m_188501_()) * 0.6 - 0.3;
        Vec3 vec31 = new Vec3(((double)livingEntity.m_217043_().m_188501_() - 0.5) * 0.3, d0, 0.6);
        vec31 = vec31.m_82496_(-livingEntity.m_146909_() * ((float)Math.PI / 180));
        vec31 = vec31.m_82524_(-livingEntity.m_146908_() * ((float)Math.PI / 180));
        vec31 = vec31.m_82520_(livingEntity.m_20185_(), livingEntity.m_20188_(), livingEntity.m_20189_());
        if (livingEntity.m_9236_() instanceof ServerLevel) {
            ((ServerLevel)livingEntity.m_9236_()).m_8767_(particleOptions, vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, 1, vec3.f_82479_, vec3.f_82480_ + 0.05, vec3.f_82481_, 0.0);
        } else {
            livingEntity.m_9236_().m_7106_(particleOptions, vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, vec3.f_82479_, vec3.f_82480_ + 0.05, vec3.f_82481_);
        }
    }
}

