/*
 * Decompiled with CFR 0.152.
 */
package net.grid.vampiresdelight.common.registry;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.items.ExtendedPotionMix;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.effects.VampirismPotion;
import java.util.function.Supplier;
import net.grid.vampiresdelight.common.registry.VDEffects;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class VDPotions {
    public static final DeferredRegister<Potion> POTIONS = DeferredRegister.create((ResourceKey)Registries.f_256973_, (String)"vampiresdelight");
    public static final RegistryObject<VampirismPotion.HunterPotion> BLESSING = POTIONS.register("blessing", () -> new VampirismPotion.HunterPotion(null, new MobEffectInstance[]{new MobEffectInstance((MobEffect)VDEffects.BLESSING.get(), 7200)}));
    public static final RegistryObject<VampirismPotion.HunterPotion> LONG_BLESSING = POTIONS.register("long_blessing", () -> new VampirismPotion.HunterPotion("blessing", new MobEffectInstance[]{new MobEffectInstance((MobEffect)VDEffects.BLESSING.get(), 19200)}));
    public static final RegistryObject<VampirismPotion.HunterPotion> STRONG_BLESSING = POTIONS.register("strong_blessing", () -> new VampirismPotion.HunterPotion("blessing", new MobEffectInstance[]{new MobEffectInstance((MobEffect)VDEffects.BLESSING.get(), 1600, 1)}));
    public static final RegistryObject<VampirismPotion.HunterPotion> VERY_LONG_BLESSING = POTIONS.register("very_long_blessing", () -> new VampirismPotion.HunterPotion("blessing", new MobEffectInstance[]{new MobEffectInstance((MobEffect)VDEffects.BLESSING.get(), 192000)}));
    public static final RegistryObject<VampirismPotion.HunterPotion> LONG_STRONG_BLESSING = POTIONS.register("long_strong_blessing", () -> new VampirismPotion.HunterPotion("blessing", new MobEffectInstance[]{new MobEffectInstance((MobEffect)VDEffects.BLESSING.get(), 4800, 1)}));
    public static final RegistryObject<Potion> CLOTHES_DISSOLVING = POTIONS.register("clothes_dissolving", () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)VDEffects.CLOTHES_DISSOLVING.get(), 600)}));
    public static final RegistryObject<VampirismPotion.HunterPotion> FOG_VISION = POTIONS.register("fog_vision", () -> new VampirismPotion.HunterPotion(null, new MobEffectInstance[]{new MobEffectInstance((MobEffect)VDEffects.FOG_VISION.get(), 3600)}));
    public static final RegistryObject<VampirismPotion.HunterPotion> LONG_FOG_VISION = POTIONS.register("long_fog_vision", () -> new VampirismPotion.HunterPotion("fog_vision", new MobEffectInstance[]{new MobEffectInstance((MobEffect)VDEffects.FOG_VISION.get(), 9600)}));
    public static final RegistryObject<VampirismPotion.HunterPotion> STRONG_FOG_VISION = POTIONS.register("strong_fog_vision", () -> new VampirismPotion.HunterPotion("fog_vision", new MobEffectInstance[]{new MobEffectInstance((MobEffect)VDEffects.FOG_VISION.get(), 800, 1)}));
    public static final RegistryObject<VampirismPotion.HunterPotion> VERY_LONG_FOG_VISION = POTIONS.register("very_long_fog_vision", () -> new VampirismPotion.HunterPotion("fog_vision", new MobEffectInstance[]{new MobEffectInstance((MobEffect)VDEffects.FOG_VISION.get(), 96000)}));
    public static final RegistryObject<VampirismPotion.HunterPotion> LONG_STRONG_FOG_VISION = POTIONS.register("long_strong_fog_vision", () -> new VampirismPotion.HunterPotion("fog_vision", new MobEffectInstance[]{new MobEffectInstance((MobEffect)VDEffects.FOG_VISION.get(), 2400, 1)}));

    public static void registerPotionMixes() {
        VDPotions.master(BLESSING, (NonNullSupplier<Ingredient>)((NonNullSupplier)() -> Ingredient.m_204132_((TagKey)ModTags.Items.HOLY_WATER)), 8, 4);
        VDPotions.durable(BLESSING, LONG_BLESSING);
        VDPotions.strong(BLESSING, STRONG_BLESSING);
        VDPotions.veryDurable(LONG_BLESSING, VERY_LONG_BLESSING);
        VDPotions.veryStrong(VERY_LONG_BLESSING, LONG_STRONG_BLESSING);
        VDPotions.master(FOG_VISION, (NonNullSupplier<Ingredient>)((NonNullSupplier)() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.VAMPIRE_ORCHID.get()})), 16, 8);
        VDPotions.durable(FOG_VISION, LONG_FOG_VISION);
        VDPotions.strong(FOG_VISION, STRONG_FOG_VISION);
        VDPotions.veryDurable(LONG_FOG_VISION, VERY_LONG_FOG_VISION);
        VDPotions.veryStrong(VERY_LONG_FOG_VISION, LONG_STRONG_FOG_VISION);
    }

    private static void durable(Supplier<? extends Potion> in, Supplier<? extends Potion> out) {
        VampirismAPI.extendedBrewingRecipeRegistry().addMix(new ExtendedPotionMix.Builder(in, out).ingredient(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42451_}), 1).blood().build());
    }

    private static void strong(Supplier<? extends Potion> in, Supplier<? extends Potion> out) {
        VampirismAPI.extendedBrewingRecipeRegistry().addMix(new ExtendedPotionMix.Builder(in, out).ingredient(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42525_}), 1).blood().build());
    }

    private static void veryDurable(Supplier<? extends Potion> in, Supplier<? extends Potion> out) {
        VampirismAPI.extendedBrewingRecipeRegistry().addMix(new ExtendedPotionMix.Builder(in, out).ingredient(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42153_}), 32, 16).blood().durable().build());
    }

    private static void veryStrong(Supplier<? extends Potion> in, Supplier<? extends Potion> out) {
        VampirismAPI.extendedBrewingRecipeRegistry().addMix(new ExtendedPotionMix.Builder(in, out).ingredient(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42054_}), 64, 32).blood().concentrated().build());
    }

    private static void master(Supplier<? extends Potion> out, NonNullSupplier<Ingredient> in, int count, int countReduced) {
        VampirismAPI.extendedBrewingRecipeRegistry().addMix(new ExtendedPotionMix.Builder(() -> Potions.f_43602_, out).master().ingredient(in, count, countReduced).blood().build());
    }
}

