/*
 * Decompiled with CFR 0.152.
 */
package net.grid.vampiresdelight.common.block.entity;

import com.mojang.logging.LogUtils;
import java.util.Objects;
import java.util.function.Predicate;
import net.grid.vampiresdelight.common.block.WineShelfBlock;
import net.grid.vampiresdelight.common.registry.VDBlockEntityTypes;
import net.grid.vampiresdelight.common.tag.VDTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class WineShelfBlockEntity
extends BlockEntity
implements Container {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final NonNullList<ItemStack> items = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    private int lastInteractedSlot = -1;
    private LazyOptional<?> itemHandler = LazyOptional.of(this::createUnSidedHandler);

    public WineShelfBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)VDBlockEntityTypes.WINE_SHELF.get(), pos, blockState);
    }

    private void updateState(int slot) {
        if (slot >= 0 && slot < 4) {
            this.lastInteractedSlot = slot;
            BlockState blockstate = this.m_58900_();
            for (int i = 0; i < WineShelfBlock.SLOT_CONTENTS.size(); ++i) {
                EnumProperty<WineShelfBlock.Slot> enumProperty = WineShelfBlock.SLOT_CONTENTS.get(i);
                blockstate = (BlockState)blockstate.m_61124_(enumProperty, (Comparable)((Object)WineShelfBlock.getSlotTypeForStack(this.m_8020_(i))));
            }
            Objects.requireNonNull(this.f_58857_).m_7731_(this.f_58858_, blockstate, 3);
        } else {
            LOGGER.error("Expected slot 0-3, got {}", (Object)slot);
        }
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        this.items.clear();
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        this.lastInteractedSlot = tag.m_128451_("last_interacted_slot");
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        ContainerHelper.m_18976_((CompoundTag)tag, this.items, (boolean)true);
        tag.m_128405_("last_interacted_slot", this.lastInteractedSlot);
    }

    public int count() {
        return (int)this.items.stream().filter(Predicate.not(ItemStack::m_41619_)).count();
    }

    public void m_6211_() {
        this.items.clear();
    }

    public int m_6643_() {
        return 4;
    }

    public boolean m_7983_() {
        return this.items.stream().allMatch(ItemStack::m_41619_);
    }

    @NotNull
    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    @NotNull
    public ItemStack m_7407_(int slot, int amount) {
        ItemStack itemstack = Objects.requireNonNullElse((ItemStack)this.items.get(slot), ItemStack.f_41583_);
        this.items.set(slot, (Object)ItemStack.f_41583_);
        if (!itemstack.m_41619_()) {
            this.updateState(slot);
        }
        return itemstack;
    }

    @NotNull
    public ItemStack m_8016_(int slot) {
        return this.m_7407_(slot, 1);
    }

    public void m_6836_(int slot, ItemStack stack) {
        if (stack.m_204117_(VDTags.WINE_SHELF_BOTTLES)) {
            this.items.set(slot, (Object)stack);
            this.updateState(slot);
        }
    }

    public boolean m_271862_(Container target, int index, @NotNull ItemStack stack) {
        return target.m_216874_(matchStack -> {
            if (matchStack.m_41619_()) {
                return true;
            }
            return ItemStack.m_150942_((ItemStack)stack, (ItemStack)matchStack) && matchStack.m_41613_() + stack.m_41613_() <= Math.min(matchStack.m_41741_(), target.m_6893_());
        });
    }

    public int m_6893_() {
        return 1;
    }

    public boolean m_6542_(@NotNull Player player) {
        return Container.m_272074_((BlockEntity)this, (Player)player);
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return stack.m_204117_(VDTags.WINE_SHELF_BOTTLES) && this.m_8020_(index).m_41619_();
    }

    public int getLastInteractedSlot() {
        return this.lastInteractedSlot;
    }

    protected IItemHandler createUnSidedHandler() {
        return new InvWrapper((Container)this);
    }

    public <T> @NotNull LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (!this.f_58859_ && cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandler.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.itemHandler = LazyOptional.of(this::createUnSidedHandler);
    }
}

