/*
 * Decompiled with CFR 0.152.
 */
package net.grid.vampiresdelight.common.block;

import net.grid.vampiresdelight.common.block.BloodySoilBlock;
import net.grid.vampiresdelight.common.block.CursedFarmlandBlock;
import net.grid.vampiresdelight.common.registry.VDBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.FarmlandWaterManager;

public class BloodySoilFarmlandBlock
extends CursedFarmlandBlock {
    public BloodySoilFarmlandBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    private static boolean hasWater(LevelReader level, BlockPos pos) {
        for (BlockPos nearbyPos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-4, 0, -4), (BlockPos)pos.m_7918_(4, 1, 4))) {
            if (!level.m_6425_(nearbyPos).m_205070_(FluidTags.f_13131_)) continue;
            return true;
        }
        return FarmlandWaterManager.hasBlockWaterTicket((LevelReader)level, (BlockPos)pos);
    }

    public static void turnToBloodySoil(BlockState state, Level level, BlockPos pos) {
        level.m_46597_(pos, BloodySoilFarmlandBlock.m_49897_((BlockState)state, (BlockState)((BloodySoilBlock)((Object)VDBlocks.BLOODY_SOIL.get())).m_49966_(), (LevelAccessor)level, (BlockPos)pos));
    }

    @Override
    public boolean isFertile(BlockState state, BlockGetter world, BlockPos pos) {
        if (state.m_60713_((Block)VDBlocks.BLOODY_SOIL_FARMLAND.get())) {
            return (Integer)state.m_61143_((Property)CursedFarmlandBlock.f_53243_) > 0;
        }
        return false;
    }

    @Override
    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            BloodySoilFarmlandBlock.turnToBloodySoil(state, (Level)level, pos);
        }
    }

    @Override
    public void m_213898_(BlockState blockState, ServerLevel worldIn, BlockPos pos, RandomSource randomSource) {
        int moisture = (Integer)blockState.m_61143_((Property)f_53243_);
        if (!BloodySoilFarmlandBlock.hasWater((LevelReader)worldIn, pos) && !worldIn.m_46758_(pos.m_7494_())) {
            if (moisture > 0) {
                worldIn.m_7731_(pos, (BlockState)blockState.m_61124_((Property)f_53243_, (Comparable)Integer.valueOf(moisture - 1)), 2);
            }
        } else if (moisture < 7) {
            worldIn.m_7731_(pos, (BlockState)blockState.m_61124_((Property)f_53243_, (Comparable)Integer.valueOf(7)), 2);
        } else if (moisture == 7) {
            BloodySoilBlock.boostCrop(blockState, worldIn, pos);
        }
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        return !this.m_49966_().m_60710_((LevelReader)context.m_43725_(), context.m_8083_()) ? ((BloodySoilBlock)((Object)VDBlocks.BLOODY_SOIL.get())).m_49966_() : super.m_5573_(context);
    }

    @Override
    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entityIn, float fallDistance) {
    }
}

